/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ItemEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.FormattedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1822;
import net.minecraft.class_2248;
import net.minecraft.class_2478;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_4587;

public class SignboardScreen
extends ItemEditorScreen {
    private static boolean NEW_FEATURES = Version.newSwitch().range("1.20.0", null, true).range(null, "1.19.4", false).get();
    private boolean newFeatures = NEW_FEATURES;
    private final class_2960 texture;
    private boolean back;
    private FormattedTextFieldWidget lines;

    public static void importSign(ItemReference ref) {
        EditableText version = TextInst.literal(NEW_FEATURES ? ">=1.20" : "<=1.19.4").formatted(class_124.field_1065);
        class_2487 nbt = ref.getItem().method_7969();
        if (nbt != null) {
            class_2487 blockTag = nbt.method_10562("BlockEntityTag");
            boolean alreadyImported = false;
            if (NEW_FEATURES) {
                if (blockTag.method_10545("front_text") || blockTag.method_10545("back_text") || blockTag.method_10545("is_waxed")) {
                    alreadyImported = true;
                }
            } else if (blockTag.method_10545("Text1") || blockTag.method_10545("Text2") || blockTag.method_10545("Text3") || blockTag.method_10545("Text4") || blockTag.method_10545("Color") || blockTag.method_10545("GlowingText")) {
                alreadyImported = true;
            }
            if (alreadyImported) {
                MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.signboard.import.fail", version), false);
                return;
            }
        }
        SignboardScreen screen = new SignboardScreen(ref);
        screen.newFeatures = !NEW_FEATURES;
        boolean glowing = screen.isGlowing();
        class_124 color = screen.getColor();
        List<class_2561> lines = screen.getLines();
        screen.newFeatures = NEW_FEATURES;
        screen.setGlowing(glowing);
        screen.setColor(color);
        screen.setLines(lines);
        ref.saveItem(screen.item, () -> MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.signboard.import.success", version), false));
    }

    public SignboardScreen(ItemReference ref) {
        super(TextInst.of("Signboard"), ref);
        this.texture = this.newFeatures ? new class_2960("minecraft", "textures/block/" + class_2478.method_45459((class_2248)((class_1822)this.item.method_7909()).method_7711()).comp_1299() + "_planks.png") : new class_2960("minecraft", "textures/block/" + MVRegistry.ITEM.getId(ref.getItem().method_7909()).method_12832().replace("_sign", "_planks") + ".png");
    }

    private class_2487 getBlockTag(boolean create) {
        class_2487 blockTag = this.item.method_7941("BlockEntityTag");
        if (blockTag != null || !create) {
            return blockTag;
        }
        return this.item.method_7911("BlockEntityTag");
    }

    private class_2487 getBlockSideTag(boolean create) {
        String key;
        class_2487 blockTag = this.getBlockTag(create);
        if (blockTag == null || !this.newFeatures) {
            return blockTag;
        }
        String string = key = this.back ? "back_text" : "front_text";
        if (blockTag.method_10573(key, 10)) {
            return blockTag.method_10562(key);
        }
        if (!create) {
            return null;
        }
        class_2487 sideTag = new class_2487();
        blockTag.method_10566(key, (class_2520)sideTag);
        return sideTag;
    }

    private void setWaxed(boolean waxed) {
        if (!this.newFeatures) {
            throw new IllegalStateException("Incorrect version!");
        }
        this.getBlockTag(true).method_10556("is_waxed", waxed);
        this.checkSave();
    }

    private boolean isWaxed() {
        class_2487 blockTag = this.getBlockTag(false);
        return blockTag != null && blockTag.method_10577("is_waxed");
    }

    private void setGlowing(boolean glowing) {
        this.getBlockSideTag(true).method_10556(this.newFeatures ? "has_glowing_text" : "GlowingText", glowing);
        this.checkSave();
    }

    private boolean isGlowing() {
        class_2487 sideTag = this.getBlockSideTag(false);
        return sideTag != null && sideTag.method_10577(this.newFeatures ? "has_glowing_text" : "GlowingText");
    }

    private void setColor(class_124 color) {
        this.getBlockSideTag(true).method_10582(this.newFeatures ? "color" : "Color", color.method_537());
    }

    private class_124 getColor() {
        class_2487 sideTag = this.getBlockSideTag(false);
        if (sideTag == null) {
            return class_124.field_1074;
        }
        class_124 color = class_124.method_533((String)sideTag.method_10558(this.newFeatures ? "color" : "Color"));
        if (color == null || !color.method_543()) {
            return class_124.field_1074;
        }
        return color;
    }

    private void setLines(List<class_2561> lines) {
        class_2487 sideTag = this.getBlockSideTag(true);
        while (lines.size() < 4) {
            lines.add(TextInst.of(""));
        }
        if (this.newFeatures) {
            class_2499 messages = new class_2499();
            for (class_2561 line : lines) {
                messages.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)this.fixEditable(this.fixClickEvent(line)))));
            }
            sideTag.method_10566("messages", (class_2520)messages);
        } else {
            for (int i = 0; i < 4; ++i) {
                sideTag.method_10582("Text" + (i + 1), class_2561.class_2562.method_10867((class_2561)this.fixClickEvent(lines.get(i))));
            }
        }
        this.checkSave();
    }

    private List<class_2561> getLines() {
        ArrayList<class_2561> output = new ArrayList<class_2561>();
        class_2487 sideTag = this.getBlockSideTag(false);
        if (sideTag != null) {
            if (this.newFeatures) {
                class_2499 messages = sideTag.method_10554("messages", 8);
                for (int i = 0; i < messages.size() && i < 4; ++i) {
                    output.add((class_2561)class_2561.class_2562.method_10877((String)messages.method_10608(i)));
                }
            } else {
                for (int i = 1; i <= 4; ++i) {
                    if (sideTag.method_10573("Text" + i, 8)) {
                        output.add((class_2561)class_2561.class_2562.method_10877((String)sideTag.method_10558("Text" + i)));
                        continue;
                    }
                    output.add(TextInst.of(""));
                }
            }
        }
        while (output.size() < 4) {
            output.add(TextInst.of(""));
        }
        return output;
    }

    private class_2561 fixClickEvent(class_2561 line) {
        class_2558 event = this.getClickEvent(line);
        if (event == null) {
            return line;
        }
        return TextInst.copy(line).styled(style -> style.method_10958(event));
    }

    private class_2558 getClickEvent(class_2561 text) {
        class_2558 event = text.method_10866().method_10970();
        if (event != null) {
            return event;
        }
        for (class_2561 child : text.method_10855()) {
            event = this.getClickEvent(child);
            if (event == null) continue;
            return event;
        }
        return null;
    }

    private class_2561 fixEditable(class_2561 line) {
        if (TextUtil.styleEqualsExact(line.method_10866(), class_2583.field_24360) && line.method_10855().size() == 1 && ((class_2561)line.method_10855().get(0)).method_10855().isEmpty()) {
            return (class_2561)line.method_10855().get(0);
        }
        return line;
    }

    @Override
    protected void initEditor() {
        if (this.newFeatures) {
            this.method_37063((class_364)MVMisc.newButton(16, 64, 100, 20, TextInst.translatable("nbteditor.signboard.side." + (this.back ? "back" : "front"), new Object[0]), btn -> {
                this.back = !this.back;
                this.method_37067();
                this.method_25426();
            }));
            this.method_37063((class_364)MVMisc.newButton(120, 64, 100, 20, TextInst.translatable("nbteditor.signboard.wax." + (this.isWaxed() ? "enabled" : "disabled"), new Object[0]), btn -> {
                boolean prevWaxed = this.isWaxed();
                this.setWaxed(!prevWaxed);
                btn.method_25355((class_2561)TextInst.translatable("nbteditor.signboard.wax." + (prevWaxed ? "disabled" : "enabled"), new Object[0]));
            }));
        }
        this.method_37063((class_364)MVMisc.newButton(16 + (this.newFeatures ? 208 : 0), 64, 100, 20, TextInst.translatable("nbteditor.signboard.glowing." + (this.isGlowing() ? "enabled" : "disabled"), new Object[0]), btn -> {
            boolean prevGlowing = this.isGlowing();
            this.setGlowing(!prevGlowing);
            btn.method_25355((class_2561)TextInst.translatable("nbteditor.signboard.glowing." + (prevGlowing ? "disabled" : "enabled"), new Object[0]));
        }));
        this.lines = (FormattedTextFieldWidget)this.method_37063(FormattedTextFieldWidget.create(this.lines, 16, 88, this.field_22789 - 32, this.field_22790 - 80 - 24, this.getLines(), class_2583.field_24360.method_10977(this.getColor()), this::setLines));
        this.lines.setMaxLines(4);
        this.lines.setBackgroundColor(0);
        this.lines.setShadow(false);
    }

    @Override
    protected void preRenderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
        MVDrawableHelper.drawTexture(matrices, this.texture, 16, 112, 0.0f, 0.0f, this.field_22789 - 32, this.field_22790 - 80 - 48);
    }
}

