/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.nbtmenugenerators;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtmenugenerators.MenuGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class ListMenuGenerator<T extends class_2520, L extends class_2483<? extends class_2520>>
implements MenuGenerator {
    private final T defaultValue;

    public ListMenuGenerator(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public List<NBTValue> getElements(NBTEditorScreen screen, class_2520 source) {
        class_2483 nbt = (class_2483)source;
        ArrayList<NBTValue> output = new ArrayList<NBTValue>();
        for (int i = 0; i < nbt.size(); ++i) {
            output.add(new NBTValue(screen, "" + i, (class_2520)nbt.get(i), nbt));
        }
        return output;
    }

    @Override
    public class_2520 getElement(class_2520 source, String key) {
        try {
            return (class_2520)((class_2483)source).get(Integer.parseInt(key));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void setElement(class_2520 source, String key, class_2520 value) {
        try {
            class_2483 list = (class_2483)source;
            int index = Integer.parseInt(key);
            if (list.size() == 1 && index == 0 && list instanceof class_2499) {
                class_2499 nonGenericList = (class_2499)list;
                nonGenericList.method_10536(0);
                nonGenericList.add((Object)value);
            } else if (list.method_10601() == value.method_10711()) {
                list.method_10606(index, value);
            }
        }
        catch (NumberFormatException e) {
            NBTEditor.LOGGER.error("Error while modifying a list", (Throwable)e);
        }
    }

    @Override
    public void addElement(NBTEditorScreen screen, class_2520 source, Consumer<String> requestOverwrite, String force) {
        ((class_2483)source).add((Object)this.defaultValue.method_10707());
        requestOverwrite.accept(null);
    }

    @Override
    public void removeElement(class_2520 source, String key) {
        try {
            ((class_2483)source).method_10536(Integer.parseInt(key));
        }
        catch (NumberFormatException e) {
            NBTEditor.LOGGER.error("Error while modifying a list", (Throwable)e);
        }
    }

    @Override
    public void pasteElement(class_2520 source, String key, class_2520 value) {
        class_2483 list = (class_2483)source;
        if (list.method_10601() == value.method_10711()) {
            list.add((Object)value);
        } else if (list.method_10601() == 8) {
            list.add((Object)class_2519.method_23256((String)value.toString()));
        } else if (value instanceof class_2514) {
            class_2514 num = (class_2514)value;
            switch (list.method_10601()) {
                case 1: {
                    list.add((Object)class_2481.method_23233((byte)num.method_10698()));
                    break;
                }
                case 2: {
                    list.add((Object)class_2516.method_23254((short)num.method_10696()));
                    break;
                }
                case 3: {
                    list.add((Object)class_2497.method_23247((int)num.method_10701()));
                    break;
                }
                case 4: {
                    list.add((Object)class_2503.method_23251((long)num.method_10699()));
                    break;
                }
                case 5: {
                    list.add((Object)class_2494.method_23244((float)num.method_10700()));
                    break;
                }
                case 6: {
                    list.add((Object)class_2489.method_23241((double)num.method_10697()));
                }
            }
        }
    }

    @Override
    public boolean renameElement(class_2520 source, String key, String newKey, boolean force) {
        class_2483 list = (class_2483)source;
        try {
            class_2520 value = this.getElement(source, key);
            int keyInt = Integer.parseInt(key);
            int newKeyInt = Integer.parseInt(newKey);
            if (newKeyInt < 0) {
                throw new NumberFormatException(newKeyInt + " is less than 0!");
            }
            if (newKeyInt >= list.size()) {
                list.method_10536(keyInt);
                list.add((Object)value);
            } else {
                list.method_10536(keyInt);
                list.method_10531(newKeyInt, value);
            }
            return true;
        }
        catch (NumberFormatException e) {
            NBTEditor.LOGGER.error("Error while modifying a list", (Throwable)e);
            return true;
        }
    }
}

