/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.nbtmenugenerators;

import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtmenugenerators.MenuGenerator;
import com.luneruniverse.minecraft.mod.nbteditor.util.StringNbtWriterQuoted;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class StringMenuGenerator
implements MenuGenerator {
    public static final List<Thread> STR_BOOL_REQUESTED = new ArrayList<Thread>();

    @Override
    public List<NBTValue> getElements(NBTEditorScreen screen, class_2520 source) {
        class_2520 nbt = this.getRealNbt(source);
        if (nbt == null) {
            return null;
        }
        MenuGenerator gen = MenuGenerator.TYPES.get(nbt.method_10711());
        if (gen == null || gen == this) {
            return null;
        }
        return gen.getElements(screen, nbt);
    }

    @Override
    public class_2520 getElement(class_2520 source, String key) {
        class_2520 nbt = this.getRealNbt(source);
        if (nbt == null) {
            return null;
        }
        MenuGenerator gen = MenuGenerator.TYPES.get(nbt.method_10711());
        if (gen == null || gen == this) {
            return null;
        }
        return gen.getElement(nbt, key);
    }

    @Override
    public void setElement(class_2520 source, String key, class_2520 value) {
        class_2520 nbt = this.getRealNbt(source);
        if (nbt == null) {
            return;
        }
        MenuGenerator gen = MenuGenerator.TYPES.get(nbt.method_10711());
        if (gen == null || gen == this) {
            return;
        }
        gen.setElement(nbt, key, value);
        this.save(source, nbt);
    }

    @Override
    public void addElement(NBTEditorScreen screen, class_2520 source, Consumer<String> requestOverwrite, String force) {
        class_2520 nbt = this.getRealNbt(source);
        if (nbt == null) {
            return;
        }
        MenuGenerator gen = MenuGenerator.TYPES.get(nbt.method_10711());
        if (gen == null || gen == this) {
            return;
        }
        gen.addElement(screen, nbt, force2 -> {
            if (force2 == null) {
                this.save(source, nbt);
            }
            requestOverwrite.accept((String)force2);
        }, force);
    }

    @Override
    public void removeElement(class_2520 source, String key) {
        class_2520 nbt = this.getRealNbt(source);
        if (nbt == null) {
            return;
        }
        MenuGenerator gen = MenuGenerator.TYPES.get(nbt.method_10711());
        if (gen == null || gen == this) {
            return;
        }
        gen.removeElement(nbt, key);
        this.save(source, nbt);
    }

    @Override
    public void pasteElement(class_2520 source, String key, class_2520 value) {
        class_2520 nbt = this.getRealNbt(source);
        if (nbt == null) {
            return;
        }
        MenuGenerator gen = MenuGenerator.TYPES.get(nbt.method_10711());
        if (gen == null || gen == this) {
            return;
        }
        gen.pasteElement(nbt, key, value);
        this.save(source, nbt);
    }

    @Override
    public boolean renameElement(class_2520 source, String key, String newKey, boolean force) {
        class_2520 nbt = this.getRealNbt(source);
        if (nbt == null) {
            return true;
        }
        MenuGenerator gen = MenuGenerator.TYPES.get(nbt.method_10711());
        if (gen == null || gen == this) {
            return true;
        }
        boolean output = gen.renameElement(nbt, key, newKey, force);
        this.save(source, nbt);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private class_2520 getRealNbt(class_2520 str) {
        try {
            STR_BOOL_REQUESTED.add(Thread.currentThread());
            class_2520 class_25202 = MixinLink.parseSpecialElement(new StringReader(((class_2519)str).method_10714()));
            return class_25202;
        }
        catch (CommandSyntaxException e) {
            class_2520 class_25203 = null;
            return class_25203;
        }
        finally {
            STR_BOOL_REQUESTED.remove(Thread.currentThread());
        }
    }

    private void save(class_2520 source, class_2520 nbt) {
        ((class_2519)source).field_11590 = new StringNbtWriterQuoted().method_32288(nbt);
    }
}

