/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.widgets;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.GroupWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_4185;

public class ButtonDropdownWidget
extends GroupWidget {
    private final ButtonGrid grid;
    private boolean open;

    public ButtonDropdownWidget(int x, int y, int btnWidth, int btnHeight, class_2561 msg, MVTooltip tooltip, int gridWidth, int gridHeight) {
        this.grid = new ButtonGrid(x, y + btnHeight, gridWidth, gridHeight, grid2 -> this.setOpen(false));
        this.addWidget(MVMisc.newButton(x, y, btnWidth, btnHeight, msg, btn -> this.setOpen(!this.open), tooltip));
    }

    public ButtonDropdownWidget(int x, int y, int btnWidth, int btnHeight, class_2561 msg, int gridWidth, int gridHeight) {
        this(x, y, btnWidth, btnHeight, msg, null, gridWidth, gridHeight);
    }

    public ButtonDropdownWidget addButton(class_2561 msg, class_4185.class_4241 onPress, MVTooltip tooltip) {
        this.grid.addButton(msg, onPress, tooltip);
        return this;
    }

    public ButtonDropdownWidget addButton(class_2561 msg, class_4185.class_4241 onPress) {
        return this.addButton(msg, onPress, null);
    }

    public ButtonDropdownWidget build() {
        this.grid.build();
        return this;
    }

    public void setOpen(boolean open) {
        if (this.open == open) {
            return;
        }
        this.open = open;
        if (open) {
            this.addWidget(this.grid);
        } else {
            this.removeWidget(this.grid);
        }
    }

    private static class ButtonGrid
    extends GroupWidget {
        private final int x;
        private final int y;
        private final int gridWidth;
        private final int gridHeight;
        private final Consumer<ButtonGrid> close;
        private final List<QueuedButton> buttons;

        public ButtonGrid(int x, int y, int gridWidth, int gridHeight, Consumer<ButtonGrid> close) {
            this.x = x;
            this.y = y;
            this.gridWidth = gridWidth;
            this.gridHeight = gridHeight;
            this.close = close;
            this.buttons = new ArrayList<QueuedButton>();
        }

        public void addButton(class_2561 msg, class_4185.class_4241 onPress, MVTooltip tooltip) {
            this.buttons.add(new QueuedButton(msg, onPress, tooltip));
        }

        public void build() {
            this.clearWidgets();
            int columns = (int)Math.ceil(Math.sqrt((double)this.buttons.size() * (double)this.gridHeight / (double)this.gridWidth));
            for (int i = 0; i < this.buttons.size(); ++i) {
                QueuedButton btn = this.buttons.get(i);
                int gridX = i % columns;
                int gridY = i / columns;
                this.addWidget(MVMisc.newButton(this.x + gridX * this.gridWidth, this.y + gridY * this.gridHeight, this.gridWidth, this.gridHeight, btn.msg(), btn.onPress(), btn.tooltip()));
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            boolean output = super.method_25402(mouseX, mouseY, button);
            if (!output) {
                this.close.accept(this);
            }
            return output;
        }

        private record QueuedButton(class_2561 msg, class_4185.class_4241 onPress, MVTooltip tooltip) {
        }
    }
}

