/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.widgets;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.OverlaySupportingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueDropdownEnum;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.ButtonDropdownWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.GroupWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.InitializableOverlay;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.MultiLineTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.StringInputWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.TranslatedGroupWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class FormattedTextFieldWidget
extends GroupWidget {
    private int x;
    private int y;
    private int width;
    private int height;
    private InternalTextFieldWidget field;
    private ButtonDropdownWidget colors;

    public static FormattedTextFieldWidget create(FormattedTextFieldWidget prev, int x, int y, int width, int height, class_2561 text, boolean newLines, class_2583 base, Consumer<class_2561> onChange) {
        if (prev == null) {
            return new FormattedTextFieldWidget(x, y, width, height, text, newLines, base, onChange);
        }
        prev.x = x;
        prev.y = y;
        prev.width = width;
        prev.height = height;
        prev.field = InternalTextFieldWidget.create(prev.field, x, y + 24, width, height - 24, text, newLines, base, onChange);
        prev.clearWidgets();
        prev.genColors();
        prev.addElement(prev.field);
        prev.addTickable(prev.field);
        prev.setText(text);
        prev.setChangeListener(onChange);
        if (prev.isMultiFocused()) {
            prev.onFocusChange(false);
        }
        return prev;
    }

    public static FormattedTextFieldWidget create(FormattedTextFieldWidget prev, int x, int y, int width, int height, List<class_2561> lines, class_2583 base, Consumer<List<class_2561>> onChange) {
        return FormattedTextFieldWidget.create(prev, x, y, width, height, TextUtil.joinLines(lines), true, base, text -> onChange.accept(TextUtil.splitText(text)));
    }

    protected FormattedTextFieldWidget(int x, int y, int width, int height, class_2561 text, boolean newLines, class_2583 base, Consumer<class_2561> onChange) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.field = InternalTextFieldWidget.create(null, x, y + 24, width, height - 24, text, newLines, base, onChange);
        this.genColors();
        this.addElement(this.field);
        this.addTickable(this.field);
    }

    private void genColors() {
        if (this.width < 320 + (ConfigScreen.isHideFormatButtons() ? 0 : 172)) {
            this.colors = this.addElement(new ButtonDropdownWidget(this.x, this.y, 20, 20, TextInst.literal("\u2b1b").formatted(class_124.field_1075), 20, 20));
            for (class_124 formatting : class_124.values()) {
                if (!formatting.method_543()) break;
                this.colors.addButton(TextInst.literal("\u2b1b").formatted(formatting), btn -> {
                    this.field.applyFormatting(formatting);
                    this.colors.setOpen(false);
                }, new MVTooltip(TextInst.of(formatting.method_537())));
            }
            this.colors.build();
        } else {
            this.colors = null;
            int i = 0;
            for (class_124 formatting : class_124.values()) {
                if (!formatting.method_543()) break;
                this.addWidget(MVMisc.newButton(this.x + i * 20, this.y, 20, 20, TextInst.literal("\u2b1b").formatted(formatting), btn -> this.field.applyFormatting(formatting), new MVTooltip(TextInst.of(formatting.method_537()))));
                ++i;
            }
        }
        if (!ConfigScreen.isHideFormatButtons()) {
            int afterColorsX = this.x + (this.colors == null ? 320 : 20);
            int i = 0;
            for (class_124 formatting : new class_124[]{class_124.field_1067, class_124.field_1056, class_124.field_1073, class_124.field_1055, class_124.field_1051, class_124.field_1070}) {
                Object btnText = formatting == class_124.field_1070 ? TextInst.of("") : TextInst.literal(formatting.name().substring(0, 1)).formatted(formatting);
                this.addWidget(MVMisc.newButton(afterColorsX + 24 + i * 20 + (i >= 5 ? 28 : 0), this.y, 20, 20, btnText, btn -> this.field.applyFormatting(formatting), new MVTooltip(TextInst.of(formatting.method_537()))));
                ++i;
            }
            this.addWidget(MVMisc.newButton(afterColorsX, this.y, 20, 20, TextInst.literal("\u2b1b").setStyle(class_2583.field_24360.method_36139(0x9999C0).method_27706(class_124.field_1056)), btn -> this.field.showCustomColor(), new MVTooltip(TextInst.translatable("nbteditor.formatted_text.custom_color", new Object[0]))));
            this.addWidget(MVMisc.newButton(afterColorsX + 24 + 100 + 4, this.y, 20, 20, TextInst.literal("E"), btn -> this.field.showEvents(), new MVTooltip(TextInst.translatable("nbteditor.formatted_text.events", new Object[0]))));
        }
    }

    public FormattedTextFieldWidget setChangeListener(Consumer<class_2561> onChange) {
        this.field.setTextChangeListener(onChange);
        return this;
    }

    public FormattedTextFieldWidget setMaxLines(int maxLines) {
        this.field.setMaxLines(maxLines);
        return this;
    }

    public FormattedTextFieldWidget setBackgroundColor(int bgColor) {
        this.field.setBackgroundColor(bgColor);
        return this;
    }

    public FormattedTextFieldWidget setCursorColor(int cursorColor) {
        this.field.setCursorColor(cursorColor);
        return this;
    }

    public FormattedTextFieldWidget setSelectionColor(int selColor) {
        this.field.setSelectionColor(selColor);
        return this;
    }

    public FormattedTextFieldWidget setShadow(boolean shadow) {
        this.field.setShadow(shadow);
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setText(class_2561 text) {
        this.field.setFormattedText(text);
    }

    public void setText(List<class_2561> lines) {
        this.setText(TextUtil.joinLines(lines));
    }

    public class_2561 getText() {
        return this.field.getFormattedText();
    }

    public List<class_2561> getTextLines() {
        return TextUtil.splitText(this.getText());
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25395(this.isMultiFocused() ? this.field : null);
        this.field.render(matrices, mouseX, mouseY, delta);
        if (this.colors != null) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 1.0);
            this.colors.render(matrices, mouseX, mouseY, delta);
            matrices.method_22909();
        }
        super.render(matrices, mouseX, mouseY, delta);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    private static class InternalTextFieldWidget
    extends MultiLineTextFieldWidget {
        private Consumer<class_2561> onChange;
        private final class_2583 base;
        private final class_2583 baseReset;
        private final List<class_2583> styles;
        private class_2583 cursorStyle;
        private class_2561 text;
        private boolean ignoreNextEditStyles;
        private boolean ignoreNextSetText;
        private final List<class_2561> undo;
        private int undoPos;

        public static InternalTextFieldWidget create(InternalTextFieldWidget prev, int x, int y, int width, int height, class_2561 text, boolean newLines, class_2583 base, Consumer<class_2561> onChange) {
            if (prev == null) {
                return new InternalTextFieldWidget(x, y, width, height, text, newLines, base, onChange);
            }
            if (prev.allowsNewLines() != newLines) {
                throw new IllegalArgumentException("Cannot convert to/from newLines on FormattedTextFieldWidget");
            }
            if (!TextUtil.styleEqualsExact(prev.base, base)) {
                throw new IllegalArgumentException("Cannot change base on FormattedTextFieldWidget");
            }
            prev.setTextChangeListener(onChange);
            prev.ignoreNextSetText = true;
            MultiLineTextFieldWidget.create(prev, x, y, width, height, text.getString(), str -> prev.text, newLines, (String str) -> prev.onChange.accept(prev.text));
            prev.setFormattedText(text);
            return prev;
        }

        protected InternalTextFieldWidget(int x, int y, int width, int height, class_2561 text, boolean newLines, class_2583 base, Consumer<class_2561> onChange) {
            super(x, y, width, height, text.getString(), newLines, null);
            this.onChange = onChange;
            this.base = base;
            this.baseReset = TextUtil.forceReset(base);
            this.styles = new ArrayList<class_2583>();
            this.text = text.method_27661();
            this.undo = new ArrayList<class_2561>();
            this.undo.add(text);
            this.undoPos = 0;
            this.genStyles(text, base, 0);
            this.setFormatter(str -> this.text);
            this.setChangeListener(str -> this.onChange.accept(this.text));
            this.onEdit("", 0, 0);
            this.generateLines();
        }

        public InternalTextFieldWidget setTextChangeListener(Consumer<class_2561> onChange) {
            this.onChange = onChange;
            return this;
        }

        private void genStyles(class_2561 text, class_2583 parent, int index) {
            int len = MVMisc.getContent(text).length();
            class_2583 style = text.method_10866().method_27702(parent);
            if (len > 0) {
                this.setStyle(index, style);
                index += len;
            }
            for (class_2561 child : text.method_10855()) {
                this.genStyles(child, style, index);
                index += MVMisc.stripInvalidChars(child.getString(), this.allowsNewLines()).length();
            }
        }

        private void setStyle(int index, class_2583 style) {
            while (this.styles.size() <= index) {
                this.styles.add(this.styles.size(), null);
            }
            this.styles.set(index, style);
        }

        private class_2583 getStyle(int index) {
            class_2583 output = this.base;
            for (int i = 0; i <= index && i < this.styles.size(); ++i) {
                class_2583 style = this.styles.get(i);
                if (style == null) continue;
                output = style;
            }
            return output;
        }

        private void applyFormatting(class_124 formatting) {
            class_2583 style;
            int i;
            int end;
            int start = this.getSelStart();
            if (start == (end = this.getSelEnd())) {
                if (this.cursorStyle == null) {
                    this.cursorStyle = this.getStyle(start == 0 ? 0 : start - 1);
                }
                this.cursorStyle = TextUtil.hasFormatting(this.cursorStyle, formatting) ? TextUtil.removeFormatting(this.cursorStyle, formatting, true) : this.withFormatting(this.cursorStyle, formatting);
                return;
            }
            class_2583 startStyle = this.getStyle(start);
            class_2583 endStyle = this.getStyle(end);
            boolean filled = TextUtil.hasFormatting(startStyle, formatting);
            this.setStyle(start, this.withFormatting(startStyle, formatting));
            for (i = start + 1; i < end && i < this.styles.size(); ++i) {
                style = this.styles.get(i);
                if (style == null || TextUtil.hasFormatting(style, formatting)) continue;
                this.styles.set(i, this.withFormatting(style, formatting));
                filled = false;
            }
            this.setStyle(end, endStyle);
            if (filled) {
                this.setStyle(start, TextUtil.removeFormatting(startStyle, formatting, true));
                for (i = start + 1; i < end && i < this.styles.size(); ++i) {
                    style = this.styles.get(i);
                    if (style == null) continue;
                    this.styles.set(i, TextUtil.removeFormatting(style, formatting, true));
                }
            }
            this.markUndo();
            this.onEdit("", start, 0);
            this.generateLines();
            this.onChange.accept(this.text);
        }

        private class_2583 withFormatting(class_2583 style, class_124 formatting) {
            if (formatting == class_124.field_1070) {
                return this.baseReset;
            }
            return style.method_27706(formatting);
        }

        private void applyEvents(class_2558 clickEvent, class_2568 hoverEvent) {
            int end;
            int start = this.getSelStart();
            if (start == (end = this.getSelEnd())) {
                if (this.cursorStyle == null) {
                    this.cursorStyle = this.getStyle(start == 0 ? 0 : start - 1);
                }
                this.cursorStyle = this.cursorStyle.method_10958(clickEvent).method_10949(hoverEvent);
                return;
            }
            class_2583 startStyle = this.getStyle(start);
            class_2583 endStyle = this.getStyle(end);
            this.setStyle(start, startStyle.method_10958(clickEvent).method_10949(hoverEvent));
            for (int i = start + 1; i < end && i < this.styles.size(); ++i) {
                class_2583 style = this.styles.get(i);
                if (style == null) continue;
                this.styles.set(i, style.method_10958(clickEvent).method_10949(hoverEvent));
            }
            this.setStyle(end, endStyle);
            this.markUndo();
            this.onEdit("", start, 0);
            this.onChange.accept(this.text);
        }

        public void setFormattedText(class_2561 text) {
            this.styles.clear();
            this.genStyles(text, this.base, 0);
            this.ignoreNextEditStyles = true;
            this.setText(text.getString());
            this.ignoreNextEditStyles = false;
        }

        public class_2561 getFormattedText() {
            return this.text;
        }

        @Override
        public void setText(String text) {
            if (this.ignoreNextSetText) {
                this.ignoreNextSetText = false;
                return;
            }
            super.setText(text);
        }

        private class_2583 getInitialCustomStyle() {
            return this.getSelStart() == this.getSelEnd() ? (this.cursorStyle == null ? this.getStyle(this.getSelStart() == 0 ? 0 : this.getSelStart() - 1) : this.cursorStyle) : this.getStyle(this.getSelStart());
        }

        private void showCustomColor() {
            class_2583 initialStyle = this.getInitialCustomStyle();
            OverlaySupportingScreen.setOverlayStatic(new StringInputWidget(initialStyle.method_10973() == null ? "#FFFFFF" : initialStyle.method_10973().method_27723(), str -> {
                int end;
                int rgb = Integer.parseInt(str.substring(1), 16);
                int start = this.getSelStart();
                if (start == (end = this.getSelEnd())) {
                    if (this.cursorStyle == null) {
                        this.cursorStyle = this.getStyle(start == 0 ? 0 : start - 1);
                    }
                    this.cursorStyle = this.cursorStyle.method_36139(rgb);
                    return;
                }
                class_2583 startStyle = this.getStyle(start);
                class_2583 endStyle = this.getStyle(end);
                this.setStyle(start, startStyle.method_36139(rgb));
                for (int i = start + 1; i < end && i < this.styles.size(); ++i) {
                    class_2583 style = this.styles.get(i);
                    if (style == null) continue;
                    this.styles.set(i, style.method_36139(rgb));
                }
                this.setStyle(end, endStyle);
                this.markUndo();
                this.onEdit("", start, 0);
                this.generateLines();
                this.onChange.accept(this.text);
            }, str -> str.matches("#[0-9a-fA-F]{6}"), widget -> OverlaySupportingScreen.setOverlayStatic(null)));
        }

        private void showEvents() {
            class_2583 initialStyle = this.getInitialCustomStyle();
            OverlaySupportingScreen.setOverlayStatic(new EventEditorWidget(initialStyle.method_10970(), initialStyle.method_10969(), this::applyEvents), 200.0);
        }

        @Override
        protected void renderHighlightsBelow(class_4587 matrices, int mouseX, int mouseY, float delta) {
            class_2583 initialStyle = this.getStyle(0);
            int start = initialStyle.method_10970() != null || initialStyle.method_10969() != null ? 0 : -1;
            for (int i = 0; i < this.styles.size(); ++i) {
                class_2583 style = this.styles.get(i);
                if (style == null) continue;
                if (style.method_10970() != null || style.method_10969() != null) {
                    if (start != -1) continue;
                    start = i;
                    continue;
                }
                if (start == -1) continue;
                this.renderHighlight(matrices, start, i, 1442818560);
                start = -1;
            }
            if (start != -1) {
                this.renderHighlight(matrices, start, this.getText().length(), 1442818560);
            }
        }

        @Override
        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (super.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443()) {
                class_124 formatting;
                switch (keyCode) {
                    case 66: {
                        class_124 class_1242 = class_124.field_1067;
                        break;
                    }
                    case 73: {
                        class_124 class_1242 = class_124.field_1056;
                        break;
                    }
                    case 85: {
                        class_124 class_1242 = class_124.field_1073;
                        break;
                    }
                    case 68: {
                        class_124 class_1242 = class_124.field_1055;
                        break;
                    }
                    case 75: {
                        class_124 class_1242 = class_124.field_1051;
                        break;
                    }
                    case 92: {
                        class_124 class_1242 = class_124.field_1070;
                        break;
                    }
                    default: {
                        class_124 class_1242 = formatting = null;
                    }
                }
                if (formatting != null) {
                    this.applyFormatting(formatting);
                    return true;
                }
            }
            if (class_437.method_25441() && class_437.method_25442() && !class_437.method_25443()) {
                if (keyCode == 67) {
                    this.showCustomColor();
                } else if (keyCode == 69) {
                    this.showEvents();
                }
            }
            return false;
        }

        @Override
        protected void onCursorMove(int cursor, int selStart, int selEnd) {
            if (this.getCursor() == cursor && this.getSelStart() == selStart && this.getSelEnd() == selEnd) {
                return;
            }
            this.cursorStyle = null;
        }

        @Override
        protected void onEdit(String insertedText, int pos, int overwrittenLen) {
            class_2583 style;
            while (this.undoPos > 0) {
                this.undo.remove(0);
                --this.undoPos;
            }
            if (this.ignoreNextEditStyles) {
                this.ignoreNextEditStyles = false;
            } else if (overwrittenLen == 0) {
                class_2583 style2 = this.getStyle(pos);
                this.setStyle(pos, style2);
                for (int i = 0; i < insertedText.length(); ++i) {
                    this.styles.add(pos, null);
                }
                if (this.cursorStyle != null) {
                    this.setStyle(pos, this.cursorStyle);
                } else if (pos == 0) {
                    this.setStyle(0, style2);
                }
            } else {
                int i;
                class_2583 startStyle = this.getStyle(pos);
                class_2583 endStyle = null;
                for (i = 0; i < overwrittenLen && pos < this.styles.size(); ++i) {
                    style = this.styles.remove(pos);
                    if (style == null) continue;
                    endStyle = style;
                }
                if (endStyle != null && (pos >= this.styles.size() || this.styles.get(pos) == null)) {
                    this.setStyle(pos, endStyle);
                }
                if (pos < this.styles.size()) {
                    for (i = 0; i < insertedText.length(); ++i) {
                        this.styles.add(pos, null);
                    }
                }
                if (!insertedText.isEmpty()) {
                    this.setStyle(pos, startStyle);
                }
            }
            String afterEdit = new StringBuilder(this.getText()).replace(pos, pos + overwrittenLen, insertedText).toString();
            EditableText text = TextInst.literal("");
            Object part = "";
            style = !this.styles.isEmpty() && this.styles.get(0) != null ? this.styles.get(0) : this.base;
            for (int i = 0; i < afterEdit.length(); ++i) {
                class_2583 newStyle;
                class_2583 class_25832 = newStyle = i == 0 || i >= this.styles.size() ? null : this.styles.get(i);
                if (newStyle != null) {
                    if (newStyle.equals((Object)style)) {
                        this.styles.set(i, null);
                    } else {
                        text.append(TextInst.literal((String)part).setStyle(style));
                        part = "";
                        style = newStyle;
                    }
                }
                part = (String)part + afterEdit.charAt(i);
            }
            if (!((String)part).isEmpty()) {
                text.append(TextInst.literal((String)part).setStyle(style));
            }
            this.undo.add(0, text);
            this.text = text;
            while (this.styles.size() > afterEdit.length()) {
                this.styles.remove(afterEdit.length());
            }
        }

        @Override
        protected void onUndo(String newText) {
            if (this.undoPos < this.undo.size() - 1) {
                this.text = this.undo.get(++this.undoPos);
                this.styles.clear();
                this.genStyles(this.text, class_2583.field_24360, 0);
            }
        }

        @Override
        protected void onRedo(String newText) {
            if (this.undoPos > 0) {
                this.text = this.undo.get(--this.undoPos);
                this.styles.clear();
                this.genStyles(this.text, class_2583.field_24360, 0);
            }
        }

        @Override
        protected void onUndoDiscard() {
            while (this.undoPos > 0) {
                this.undo.remove(0);
                --this.undoPos;
            }
            this.undo.remove(0);
        }

        @Override
        protected String onCopy(String text, int pos, int len) {
            return class_2561.class_2562.method_10867((class_2561)TextUtil.substring(this.text, pos, pos + len));
        }

        @Override
        protected String onPaste(String text, int pos, int overwrittenLen) {
            try {
                int i;
                class_2561 textValue = this.pasteFilter((class_2561)class_2561.class_2562.method_10877((String)text));
                String textValueStr = textValue.getString();
                int textLen = textValueStr.length();
                class_2583 endStyle = this.getStyle(pos);
                for (i = 0; i < overwrittenLen && pos < this.styles.size(); ++i) {
                    class_2583 style = this.styles.remove(pos);
                    if (style == null) continue;
                    endStyle = style;
                }
                if (endStyle != null && (pos >= this.styles.size() || this.styles.get(pos) == null)) {
                    this.setStyle(pos, endStyle);
                }
                if (pos < this.styles.size()) {
                    for (i = 0; i < textLen; ++i) {
                        this.styles.add(pos, null);
                    }
                }
                this.genStyles(textValue, class_2583.field_24360, pos);
                this.ignoreNextEditStyles = true;
                return textValueStr;
            }
            catch (Exception e) {
                return text;
            }
        }

        private class_2561 pasteFilter(class_2561 toPaste) {
            int i;
            toPaste = TextUtil.stripInvalidChars(toPaste, this.allowsNewLines());
            int numNewLines = this.getNumNewLines(this.getText());
            int toPasteNewLines = this.getNumNewLines(toPaste);
            while (numNewLines + toPasteNewLines + 1 > this.maxLines && (i = TextUtil.lastIndexOf(toPaste, 10)) != -1) {
                toPaste = TextUtil.deleteCharAt(toPaste, i);
                --toPasteNewLines;
            }
            return toPaste;
        }

        private int getNumNewLines(class_2561 text) {
            AtomicInteger output = new AtomicInteger(0);
            text.method_27657(str -> {
                int numNewLines = this.getNumNewLines(str);
                if (numNewLines != 0) {
                    output.setPlain(output.getPlain() + numNewLines);
                }
                return Optional.empty();
            });
            return output.getPlain();
        }

        private static class EventEditorWidget
        extends GroupWidget
        implements InitializableOverlay<class_437> {
            private int x;
            private int y;
            private final ConfigValueDropdownEnum<ClickAction> clickActionDropdown;
            private final TranslatedGroupWidget clickActionField;
            private final NamedTextFieldWidget clickValueField;
            private final ConfigValueDropdownEnum<HoverAction> hoverActionDropdown;
            private final TranslatedGroupWidget hoverActionField;
            private final NamedTextFieldWidget hoverValueField;
            private final class_4185 ok;
            private final class_4185 cancel;

            public EventEditorWidget(class_2558 clickEvent, class_2568 hoverEvent, EventPairCallback onDone) {
                class_2558.class_2559 clickAction = clickEvent == null ? null : clickEvent.method_10845();
                String clickValue = clickEvent == null ? "" : clickEvent.method_10844();
                class_2568.class_5247 hoverAction = hoverEvent == null ? null : hoverEvent.method_10892();
                String hoverValue = hoverEvent == null ? "" : hoverEvent.method_10892().method_27669(hoverEvent.method_10891(hoverEvent.method_10892())).toString();
                class_327 textRenderer = MainUtil.client.field_1772;
                this.clickActionDropdown = new ConfigValueDropdownEnum<ClickAction>(ClickAction.get(clickAction), ClickAction.NONE, ClickAction.class);
                this.clickActionDropdown.method_25358(150);
                this.clickActionField = this.addElement(TranslatedGroupWidget.forWidget(this.clickActionDropdown, 0.0, 0.0, 0.0));
                this.clickValueField = this.addWidget(new NamedTextFieldWidget(textRenderer, 0, 0, 150, 16, TextInst.of(""))).name(TextInst.translatable("nbteditor.formatted_text.click_event_value", new Object[0]));
                this.clickValueField.method_1880(Integer.MAX_VALUE);
                this.clickValueField.method_1852(clickValue);
                this.hoverActionDropdown = new ConfigValueDropdownEnum<HoverAction>(HoverAction.get(hoverAction), HoverAction.NONE, HoverAction.class);
                this.hoverActionDropdown.method_25358(150);
                this.hoverActionDropdown.addValueListener(value -> this.updateOk());
                this.hoverActionField = this.addElement(TranslatedGroupWidget.forWidget(this.hoverActionDropdown, 0.0, 0.0, 0.0));
                this.hoverValueField = this.addWidget(new NamedTextFieldWidget(textRenderer, 0, 0, 150, 16, TextInst.of(""))).name(TextInst.translatable("nbteditor.formatted_text.hover_event_value", new Object[0]));
                this.hoverValueField.method_1880(Integer.MAX_VALUE);
                this.hoverValueField.method_1852(hoverValue);
                this.hoverValueField.method_1863(str -> this.updateOk());
                this.ok = this.addWidget(MVMisc.newButton(0, 0, 150, 20, TextInst.translatable("nbteditor.ok", new Object[0]), btn -> {
                    onDone.onEventChange(((ClickAction)((Object)((Object)this.clickActionDropdown.getValidValue()))).toEvent(this.clickValueField.method_1882()), ((HoverAction)((Object)((Object)this.hoverActionDropdown.getValidValue()))).toEvent(this.hoverValueField.method_1882()));
                    OverlaySupportingScreen.setOverlayStatic(null);
                }));
                this.cancel = this.addWidget(MVMisc.newButton(0, 0, 150, 20, TextInst.translatable("nbteditor.cancel", new Object[0]), btn -> OverlaySupportingScreen.setOverlayStatic(null)));
                this.addDrawable(this.hoverActionField);
                this.addDrawable(this.clickActionField);
            }

            @Override
            public void init(class_437 parent, int width, int height) {
                this.x = width / 2;
                this.y = height / 2;
                this.clickActionField.setTranslation(this.x - 152, this.y - 34, 0.0);
                this.clickValueField.field_22760 = this.x + 2;
                this.clickValueField.field_22761 = this.y - 32;
                this.hoverActionField.setTranslation(this.x - 152, this.y - 12, 0.0);
                this.hoverValueField.field_22760 = this.x + 2;
                this.hoverValueField.field_22761 = this.y - 10;
                this.ok.field_22760 = this.x - 152;
                this.ok.field_22761 = this.y + 12;
                this.cancel.field_22760 = this.x + 2;
                this.cancel.field_22761 = this.y + 12;
            }

            private void updateOk() {
                if (this.hoverActionDropdown.getValidValue() == HoverAction.NONE) {
                    this.ok.field_22763 = true;
                    return;
                }
                try {
                    ((HoverAction)((Object)this.hoverActionDropdown.getValidValue())).toEvent(this.hoverValueField.method_1882());
                    this.ok.field_22763 = true;
                }
                catch (Exception e) {
                    this.ok.field_22763 = false;
                }
            }

            @Override
            public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
                MainUtil.client.field_1755.renderBackground(matrices);
                super.render(matrices, mouseX, mouseY, delta);
            }

            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                if (keyCode == 256) {
                    OverlaySupportingScreen.setOverlayStatic(null);
                    return true;
                }
                if (keyCode == 257) {
                    if (this.ok.field_22763) {
                        this.ok.method_25306();
                    }
                    return true;
                }
                return super.method_25404(keyCode, scanCode, modifiers);
            }

            public static enum ClickAction {
                NONE(null),
                OPEN_URL(class_2558.class_2559.field_11749),
                OPEN_FILE(class_2558.class_2559.field_11746),
                RUN_COMMAND(class_2558.class_2559.field_11750),
                SUGGEST_COMMAND(class_2558.class_2559.field_11745),
                CHANGE_PAGE(class_2558.class_2559.field_11748),
                COPY_TO_CLIPBOARD(class_2558.class_2559.field_21462);

                private final class_2558.class_2559 value;

                public static ClickAction get(class_2558.class_2559 value) {
                    for (ClickAction action : ClickAction.values()) {
                        if (action.value != value) continue;
                        return action;
                    }
                    throw new IllegalArgumentException("Invalid click action: " + value);
                }

                private ClickAction(class_2558.class_2559 value) {
                    this.value = value;
                }

                public class_2558 toEvent(String value) {
                    if (this == NONE) {
                        return null;
                    }
                    return new class_2558(this.value, value);
                }

                public String toString() {
                    if (this == NONE) {
                        return "none";
                    }
                    return this.value.method_10846();
                }
            }

            public static enum HoverAction {
                NONE(null),
                SHOW_TEXT(class_2568.class_5247.field_24342),
                SHOW_ITEM(class_2568.class_5247.field_24343),
                SHOW_ENTITY(class_2568.class_5247.field_24344);

                private final class_2568.class_5247<?> value;

                public static HoverAction get(class_2568.class_5247<?> value) {
                    for (HoverAction action : HoverAction.values()) {
                        if (action.value != value) continue;
                        return action;
                    }
                    throw new IllegalArgumentException("Invalid hover action: " + value);
                }

                private HoverAction(class_2568.class_5247<?> value) {
                    this.value = value;
                }

                public class_2568 toEvent(String value) {
                    if (this == NONE) {
                        return null;
                    }
                    return this.value.method_27668((JsonElement)new Gson().fromJson(value, JsonElement.class));
                }

                public String toString() {
                    if (this == NONE) {
                        return "none";
                    }
                    return this.value.method_27674();
                }
            }

            public static interface EventPairCallback {
                public void onEventChange(class_2558 var1, class_2568 var2);
            }
        }
    }
}

