/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.widgets;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawable;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVElement;
import com.luneruniverse.minecraft.mod.nbteditor.screens.Tickable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class GroupWidget
extends class_362
implements MVDrawable,
MVElement,
Tickable,
class_6379 {
    private final List<class_4068> drawables = new ArrayList<class_4068>();
    private final List<class_364> elements = new ArrayList<class_364>();
    private final List<Tickable> tickables = new ArrayList<Tickable>();

    public <T extends class_4068> T addDrawable(T drawable) {
        if (!this.drawables.contains(drawable)) {
            this.drawables.add(drawable);
        }
        return drawable;
    }

    public <T extends class_364> T addElement(T element) {
        if (!this.elements.contains(element)) {
            this.elements.add(element);
        }
        return element;
    }

    public <T extends Tickable> T addTickable(T tickable) {
        if (!this.tickables.contains(tickable)) {
            this.tickables.add(tickable);
        }
        return tickable;
    }

    public <T extends class_4068 & class_364> T addWidget(T widget) {
        this.addDrawable(widget);
        this.addElement(widget);
        if (widget instanceof Tickable) {
            Tickable tickable = (Tickable)widget;
            this.addTickable(tickable);
        }
        return widget;
    }

    public boolean removeDrawable(class_4068 drawable) {
        return this.drawables.remove(drawable);
    }

    public boolean removeElement(class_364 element) {
        return this.elements.remove(element);
    }

    public boolean removeTickable(Tickable tickable) {
        return this.tickables.remove(tickable);
    }

    public <T extends class_4068 & class_364> boolean removeWidget(T widget) {
        Tickable tickable;
        return this.removeDrawable(widget) | this.removeElement(widget) | (widget instanceof Tickable && this.removeTickable(tickable = (Tickable)widget));
    }

    public boolean filterDrawables(Predicate<class_4068> filter) {
        return this.drawables.removeIf(filter.negate());
    }

    public boolean filterElements(Predicate<class_364> filter) {
        return this.elements.removeIf(filter.negate());
    }

    public boolean filterTickables(Predicate<Tickable> filter) {
        return this.tickables.removeIf(filter.negate());
    }

    public boolean filterWidgets(Predicate<Object> filter) {
        HashSet<Object> widgets = new HashSet<Object>();
        widgets.addAll(this.drawables);
        widgets.addAll(this.elements);
        widgets.addAll(this.tickables);
        widgets.removeIf(filter.negate());
        boolean output = this.drawables.retainAll(widgets);
        return (output |= this.elements.retainAll(widgets)) | this.tickables.retainAll(widgets);
    }

    public boolean clearDrawables() {
        if (this.drawables.isEmpty()) {
            return false;
        }
        this.drawables.clear();
        return true;
    }

    public boolean clearElements() {
        if (this.elements.isEmpty()) {
            return false;
        }
        this.elements.clear();
        return true;
    }

    public boolean clearTickables() {
        if (this.tickables.isEmpty()) {
            return false;
        }
        this.tickables.clear();
        return true;
    }

    public boolean clearWidgets() {
        return this.clearDrawables() | this.clearElements() | this.clearTickables();
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        for (class_4068 drawable : this.drawables) {
            drawable.render(matrices, mouseX, mouseY, delta);
        }
    }

    @Override
    public void tick() {
        for (Tickable tickable : this.tickables) {
            tickable.tick();
        }
    }

    public List<? extends class_364> method_25396() {
        return new ArrayList<class_364>(this.elements);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        for (class_364 element : this.elements) {
            if (!element.method_25405(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void method_25365(boolean focused) {
        MVElement.super.method_25365(focused);
    }

    @Override
    public boolean method_25370() {
        return MVElement.super.method_25370();
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 var1) {
    }
}

