/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.widgets;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawable;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVElement;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.Panel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class List2D
extends Panel<List2DValue> {
    private int itemWidth;
    private int itemHeight;
    private int itemPadding;
    private final List<Panel.PositionedPanelElement<List2DValue>> elements;
    private class_364 finalEventHandler;

    public List2D(int x, int y, int width, int height, int outerPadding, int itemWidth, int itemHeight, int itemPadding) {
        super(x, y, width, height, outerPadding, true);
        this.itemWidth = itemWidth;
        this.itemHeight = itemHeight;
        this.itemPadding = itemPadding;
        this.elements = new ArrayList<Panel.PositionedPanelElement<List2DValue>>();
    }

    public List2D setFinalEventHandler(class_364 finalEventHandler) {
        this.finalEventHandler = finalEventHandler;
        return this;
    }

    public List2D addElement(List2DValue element) {
        this.elements.add(this.genPositioned(element, this.elements.size()));
        return this;
    }

    public List2D removeElement(List2DValue element) {
        if (this.elements.removeIf(pos -> pos.element() == element)) {
            this.elements.replaceAll(new UnaryOperator<Panel.PositionedPanelElement<List2DValue>>(){
                private int i = 0;

                @Override
                public Panel.PositionedPanelElement<List2DValue> apply(Panel.PositionedPanelElement<List2DValue> pos) {
                    return List2D.this.genPositioned(pos.element(), this.i++);
                }
            });
        }
        return this;
    }

    public List2D clearElements() {
        this.elements.clear();
        return this;
    }

    public List2D addElements(List<List2DValue> elements) {
        elements.forEach(this::addElement);
        return this;
    }

    public List<List2DValue> getElements() {
        return this.elements.stream().map(Panel.PositionedPanelElement::element).toList();
    }

    private Panel.PositionedPanelElement<List2DValue> genPositioned(List2DValue element, int i) {
        int elementsPerRow = (this.width + this.itemPadding) / (this.itemWidth + this.itemPadding);
        int x = i % elementsPerRow * (this.itemWidth + this.itemPadding);
        int y = i / elementsPerRow * (this.itemHeight + this.itemPadding);
        return new Panel.PositionedPanelElement<List2DValue>(element, x, y);
    }

    @Override
    protected Iterable<Panel.PositionedPanelElement<List2DValue>> getPanelElements() {
        return this.elements;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button) || this.finalEventHandler.method_25402(mouseX - (double)this.x, mouseY - (double)this.y, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button) || this.finalEventHandler.method_25406(mouseX - (double)this.x, mouseY - (double)this.y, button);
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        this.finalEventHandler.method_16014(mouseX, mouseY);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY) || this.finalEventHandler.method_25403(mouseX - (double)this.x, mouseY - (double)this.y, button, deltaX, deltaY);
    }

    @Override
    protected void updateMousePos(double mouseX, double mouseY) {
        boolean hovering = this.method_25405(mouseX, mouseY);
        for (Panel.PositionedPanelElement<List2DValue> pos : this.elements) {
            pos.element().setInsideList(hovering);
        }
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return super.method_25401(mouseX, mouseY, amount) || this.finalEventHandler.method_25401(mouseX, mouseY, amount);
    }

    @Override
    protected int getPanelElementHeight(List2DValue element) {
        return this.itemHeight;
    }

    public void setScroll(int scroll) {
        this.scroll = scroll;
    }

    public int getScroll() {
        return this.scroll;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers) || this.finalEventHandler.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return super.method_16803(keyCode, scanCode, modifiers) || this.finalEventHandler.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char chr, int modifiers) {
        return super.method_25400(chr, modifiers) || this.finalEventHandler.method_25400(chr, modifiers);
    }

    public void method_37020(class_6382 builder) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33786;
    }

    public static abstract class List2DValue
    implements MVDrawable,
    MVElement {
        protected static final class_310 client = class_310.method_1551();
        protected static final class_327 textRenderer = List2DValue.client.field_1772;
        private boolean insideList;

        private void setInsideList(boolean insideList) {
            this.insideList = insideList;
        }

        protected boolean isInsideList() {
            return this.insideList;
        }
    }
}

