/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.widgets;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawable;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVElement;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.OverlaySupportingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.Tickable;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.TranslatedGroupWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.TextUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class MultiLineTextFieldWidget
implements MVDrawable,
MVElement,
Tickable,
class_6379 {
    private static final class_327 textRenderer = MainUtil.client.field_1772;
    private int x;
    private int y;
    private int width;
    private int height;
    private String text;
    private Function<String, class_2561> formatter;
    private final boolean newLines;
    private Consumer<String> onChange;
    protected int maxLines;
    private int bgColor;
    private int cursorColor;
    private int selColor;
    private boolean shadow;
    private final List<class_2561> lines;
    private final List<class_2561> renderedLines;
    private final List<Map.Entry<String, Integer>> undo;
    private int undoPos;
    private int cursor;
    private int selStart;
    private int selEnd;
    private int cursorBlinkTracker;
    private int cursorX;
    private int scroll;

    public static MultiLineTextFieldWidget create(MultiLineTextFieldWidget prev, int x, int y, int width, int height, String text, Function<String, class_2561> formatter, boolean newLines, Consumer<String> onChange) {
        if (prev == null) {
            return new MultiLineTextFieldWidget(x, y, width, height, text, formatter, newLines, onChange);
        }
        if (prev.newLines != newLines) {
            throw new IllegalArgumentException("Cannot convert to/from newLines on MultiLineTextFieldWidget");
        }
        prev.x = x;
        prev.y = y;
        prev.width = width;
        prev.height = height;
        prev.setText(text);
        prev.setFormatter(formatter);
        prev.setChangeListener(onChange);
        prev.generateLines();
        if (prev.isMultiFocused()) {
            prev.onFocusChange(false);
        }
        return prev;
    }

    public static MultiLineTextFieldWidget create(MultiLineTextFieldWidget prev, int x, int y, int width, int height, String text, boolean newLines, Consumer<String> onChange) {
        return MultiLineTextFieldWidget.create(prev, x, y, width, height, text, null, newLines, onChange);
    }

    protected MultiLineTextFieldWidget(int x, int y, int width, int height, String text, Function<String, class_2561> formatter, boolean newLines, Consumer<String> onChange) {
        text = MVMisc.stripInvalidChars(text, newLines);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.text = text;
        this.formatter = formatter;
        this.newLines = newLines;
        this.onChange = str -> {
            this.generateLines();
            onChange.accept((String)str);
        };
        this.maxLines = Integer.MAX_VALUE;
        this.bgColor = 0x55000000;
        this.cursorColor = -1;
        this.selColor = 0x55FFFFFF;
        this.shadow = true;
        this.lines = new ArrayList<class_2561>();
        this.renderedLines = new ArrayList<class_2561>();
        this.undo = new ArrayList<Map.Entry<String, Integer>>();
        this.undo.add(0, Map.entry(text, text.length()));
        this.undoPos = 0;
        this.setCursor(text.length());
        this.cursorX = -1;
        this.generateLines();
    }

    protected MultiLineTextFieldWidget(int x, int y, int width, int height, String text, boolean newLines, Consumer<String> onChange) {
        this(x, y, width, height, text, null, newLines, onChange);
    }

    public MultiLineTextFieldWidget setFormatter(Function<String, class_2561> formatter) {
        this.formatter = formatter;
        this.generateLines();
        return this;
    }

    public MultiLineTextFieldWidget setChangeListener(Consumer<String> onChange) {
        this.onChange = str -> {
            this.generateLines();
            onChange.accept((String)str);
        };
        return this;
    }

    public MultiLineTextFieldWidget setMaxLines(int maxLines) {
        this.maxLines = maxLines;
        return this;
    }

    public MultiLineTextFieldWidget setBackgroundColor(int bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public MultiLineTextFieldWidget setCursorColor(int cursorColor) {
        this.cursorColor = cursorColor;
        return this;
    }

    public MultiLineTextFieldWidget setSelectionColor(int selColor) {
        this.selColor = selColor;
        return this;
    }

    public MultiLineTextFieldWidget setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setText(String text) {
        if (this.text.equals(text)) {
            return;
        }
        this.selStart = 0;
        this.selEnd = this.text.length();
        this.write(text);
    }

    public String getText() {
        return this.text;
    }

    public boolean allowsNewLines() {
        return this.newLines;
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        boolean scissor;
        MVDrawableHelper.fill(matrices, this.x, this.y, this.x + this.width, this.y + this.height, this.bgColor);
        boolean bl = scissor = !ConfigScreen.isMacScrollPatch();
        if (scissor) {
            class_310 client = MainUtil.client;
            RenderSystem.enableScissor((int)((int)((double)this.x * client.method_22683().method_4495())), (int)(client.method_22683().method_4507() - (int)((double)(this.y + this.height) * client.method_22683().method_4495())), (int)((int)((double)this.width * client.method_22683().method_4495())), (int)((int)((double)this.height * client.method_22683().method_4495())));
        }
        matrices.method_22903();
        matrices.method_22904(0.0, (double)this.scroll, 0.0);
        this.renderHighlightsBelow(matrices, mouseX, mouseY, delta);
        int yOffset = this.y;
        for (class_2561 line : this.renderedLines) {
            Objects.requireNonNull(textRenderer);
            Objects.requireNonNull(textRenderer);
            MVDrawableHelper.drawText(matrices, textRenderer, line, this.x + 9, yOffset + 9, -1, this.shadow);
            double d = yOffset;
            Objects.requireNonNull(textRenderer);
            yOffset = (int)(d + 9.0 * 1.5);
        }
        Version.newSwitch().range("1.20.0", (String)null, () -> matrices.method_22904(0.0, 0.0, 1.0)).range((String)null, "1.19.4", () -> {}).run();
        this.renderHighlightsAbove(matrices, mouseX, mouseY, delta);
        this.renderHighlight(matrices, this.getSelStart(), this.getSelEnd(), this.selColor);
        if (this.isMultiFocused() && this.cursorBlinkTracker / 6 % 2 == 0) {
            Point cursor = this.getXYPos(this.cursor);
            int n = cursor.x;
            int n2 = cursor.y;
            int n3 = cursor.x + 1;
            int n4 = cursor.y;
            Objects.requireNonNull(textRenderer);
            MVDrawableHelper.fill(matrices, n, n2, n3, n4 + 9, this.cursorColor);
        }
        matrices.method_22909();
        if (scissor) {
            RenderSystem.disableScissor();
        }
    }

    protected void renderHighlightsBelow(class_4587 matrices, int mouseX, int mouseY, float delta) {
    }

    protected void renderHighlightsAbove(class_4587 matrices, int mouseX, int mouseY, float delta) {
    }

    protected void renderHighlight(class_4587 matrices, int start, int end, int color) {
        Point startPos = this.getXYPos(start);
        Point endPos = this.getXYPos(end);
        if (startPos.y == endPos.y) {
            int n = startPos.x;
            int n2 = startPos.y;
            int n3 = endPos.x;
            int n4 = endPos.y;
            Objects.requireNonNull(textRenderer);
            MVDrawableHelper.fill(matrices, n, n2, n3, n4 + 9, color);
        } else {
            int lineY;
            int line = 0;
            while (true) {
                Point point;
                int n = startPos.y;
                Objects.requireNonNull(textRenderer);
                lineY = n + line * (int)(9.0 * 1.5);
                if (lineY >= endPos.y) break;
                if (line == 0) {
                    point = startPos;
                } else {
                    Objects.requireNonNull(textRenderer);
                    point = new Point(this.x + 9, lineY);
                }
                Point lineStart = point;
                int n5 = lineStart.x;
                int n6 = lineStart.y;
                Objects.requireNonNull(textRenderer);
                int n7 = lineStart.y;
                Objects.requireNonNull(textRenderer);
                MVDrawableHelper.fill(matrices, n5, n6, this.x + this.width - 9, n7 + 9, color);
                ++line;
            }
            Objects.requireNonNull(textRenderer);
            int n = endPos.x;
            int n8 = endPos.y;
            Objects.requireNonNull(textRenderer);
            MVDrawableHelper.fill(matrices, this.x + 9, lineY, n, n8 + 9, color);
        }
    }

    @Override
    public void tick() {
        ++this.cursorBlinkTracker;
    }

    protected void generateLines() {
        this.lines.clear();
        this.renderedLines.clear();
        String text = this.text;
        class_2561 formattedText = this.formatter == null ? TextInst.of(text) : this.formatter.apply(text);
        boolean endsWithNewLine = false;
        while (!text.isEmpty()) {
            int n;
            if (text.charAt(0) == '\n') {
                endsWithNewLine = true;
                this.lines.add(TextInst.of("\n"));
                this.renderedLines.add(TextInst.of(""));
                text = text.substring(1);
                formattedText = TextUtil.substring(formattedText, 1);
                continue;
            }
            int charPos = 1;
            do {
                n = textRenderer.method_27525((class_5348)TextUtil.substring(formattedText, 0, charPos));
                Objects.requireNonNull(textRenderer);
            } while (n < this.width - 9 * 2 && text.length() >= ++charPos && text.charAt(charPos - 1) != '\n');
            endsWithNewLine = charPos - 1 < text.length() && text.charAt(charPos - 1) == '\n';
            int extraPos = charPos - 1 + (endsWithNewLine ? 1 : 0);
            this.lines.add(TextUtil.substring(formattedText, 0, extraPos));
            this.renderedLines.add(TextUtil.substring(formattedText, 0, charPos - 1));
            text = text.substring(extraPos);
            formattedText = TextUtil.substring(formattedText, extraPos);
        }
        if (endsWithNewLine) {
            class_2561 emptyLine = TextInst.of("");
            this.lines.add(emptyLine);
            this.renderedLines.add(emptyLine);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        this.setCursor(this.getCharPos(mouseX, mouseY - (double)this.scroll), true);
        this.cursorX = -1;
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        int selEnd = this.getCharPos(mouseX, mouseY - (double)this.scroll);
        this.onCursorMove(selEnd, Math.min(this.selStart, selEnd), Math.max(this.selStart, selEnd));
        this.selEnd = selEnd;
        this.cursor = selEnd;
        this.cursorX = -1;
        return true;
    }

    public int getSelStart() {
        return Math.min(this.selStart, this.selEnd);
    }

    public int getSelEnd() {
        return Math.max(this.selStart, this.selEnd);
    }

    public int getCursor() {
        return this.cursor;
    }

    private int getCharPos(int mouseX, int mouseY) {
        int n;
        if (this.lines.isEmpty()) {
            return 0;
        }
        Objects.requireNonNull(textRenderer);
        Objects.requireNonNull(textRenderer);
        int line = (mouseY - this.y - 9) / (int)(9.0 * 1.5);
        if (line >= this.lines.size()) {
            line = this.lines.size() - 1;
        }
        class_2561 lineValue = this.renderedLines.get(line);
        int lineLen = lineValue.getString().length();
        int charPos = 0;
        do {
            n = textRenderer.method_27525((class_5348)TextUtil.substring(lineValue, 0, charPos));
            Objects.requireNonNull(textRenderer);
        } while (n < mouseX - this.x - 9 && ++charPos <= lineLen);
        if (charPos != 0) {
            --charPos;
        }
        for (int i = 0; i < line; ++i) {
            charPos += this.lines.get(i).getString().length();
        }
        return charPos;
    }

    private int getCharPos(double mouseX, double mouseY) {
        return this.getCharPos((int)mouseX, (int)mouseY);
    }

    private Point getXYPos(int charPos) {
        int lineX = 0;
        int lineY = 0;
        if (charPos >= this.text.length()) {
            lineX = this.lines.isEmpty() ? 0 : textRenderer.method_27525((class_5348)this.lines.get(this.lines.size() - 1));
            lineY = this.lines.isEmpty() ? 0 : this.lines.size() - 1;
        } else {
            int i = 0;
            for (class_2561 line : this.lines) {
                int lineLen = line.getString().length();
                if (lineLen <= charPos) {
                    ++lineY;
                    charPos -= lineLen;
                } else {
                    lineX = textRenderer.method_27525((class_5348)TextUtil.substring(this.lines.get(i), 0, charPos));
                    break;
                }
                ++i;
            }
        }
        Objects.requireNonNull(textRenderer);
        Objects.requireNonNull(textRenderer);
        int n = lineY * (int)(9.0 * 1.5);
        Objects.requireNonNull(textRenderer);
        return new Point(lineX + 9 + this.x, n + 9 + this.y);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.method_25405(mouseX, mouseY)) {
            int n = this.lines.size();
            Objects.requireNonNull(textRenderer);
            int n2 = n * (int)(9.0 * 1.5);
            Objects.requireNonNull(textRenderer);
            int maxScroll = -Math.max(0, n2 + 9 + this.height / 3 - this.height);
            if (amount < 0.0 && this.scroll > maxScroll) {
                this.scroll = (int)((double)this.scroll + amount * 5.0);
                if (this.scroll < maxScroll) {
                    this.scroll = maxScroll;
                }
            }
            if (amount > 0.0 && this.scroll < 0) {
                this.scroll = (int)((double)this.scroll + amount * 5.0);
                if (this.scroll > 0) {
                    this.scroll = 0;
                }
            }
            return true;
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    public void setCursor(int cursor, boolean select) {
        int selStart = this.selStart;
        int selEnd = this.selEnd;
        if (select && class_437.method_25442()) {
            selEnd = cursor;
        } else {
            selStart = cursor;
            selEnd = cursor;
        }
        this.onCursorMove(cursor, Math.min(selStart, selEnd), Math.max(selStart, selEnd));
        this.cursor = cursor;
        this.selStart = selStart;
        this.selEnd = selEnd;
    }

    public void setCursor(int cursor) {
        this.setCursor(cursor, false);
    }

    private void write(String text) {
        while (this.undoPos > 0) {
            this.undo.remove(0);
            --this.undoPos;
        }
        text = MVMisc.stripInvalidChars(text, this.newLines);
        this.onEdit(text, this.getSelStart(), this.getSelEnd() - this.getSelStart());
        this.text = new StringBuilder(this.text).replace(this.getSelStart(), this.getSelEnd(), text).toString();
        this.setCursor(this.getSelStart() + text.length());
        this.undo.add(0, Map.entry(this.text, this.cursor));
        this.onChange.accept(this.text);
    }

    public String getSelectedText() {
        return this.text.substring(this.getSelStart(), this.getSelEnd());
    }

    private void moveCursorUp() {
        Point pos = this.getXYPos(this.cursor);
        if (this.cursorX == -1) {
            this.cursorX = pos.x;
        }
        if (pos.y == this.getXYPos((int)0).y) {
            this.setCursor(0, true);
            this.cursorX = -1;
        } else {
            int n = pos.y;
            Objects.requireNonNull(textRenderer);
            this.setCursor(this.getCharPos(this.cursorX, n - (int)(9.0 * 1.5)), true);
        }
    }

    private void moveCursorDown() {
        Point pos = this.getXYPos(this.cursor);
        if (this.cursorX == -1) {
            this.cursorX = pos.x;
        }
        if (pos.y == this.getXYPos((int)this.text.length()).y) {
            this.setCursor(this.text.length(), true);
            this.cursorX = -1;
        } else {
            int n = pos.y;
            Objects.requireNonNull(textRenderer);
            this.setCursor(this.getCharPos(this.cursorX, n + (int)(9.0 * 1.5)), true);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_437.method_25439((int)keyCode)) {
            this.onCursorMove(this.text.length(), 0, this.text.length());
            this.selStart = 0;
            this.cursor = this.selEnd = this.text.length();
            this.cursorX = -1;
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            MainUtil.client.field_1774.method_1455(this.onCopy(this.getSelectedText(), this.getSelStart(), this.getSelEnd() - this.getSelStart()));
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            this.write(this.pasteFilter(this.onPaste(MainUtil.client.field_1774.method_1460(), this.getSelStart(), this.getSelEnd() - this.getSelStart())));
            this.cursorX = -1;
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            MainUtil.client.field_1774.method_1455(this.onCopy(this.getSelectedText(), this.getSelStart(), this.getSelEnd() - this.getSelStart()));
            this.write("");
            this.cursorX = -1;
            return true;
        }
        if (MultiLineTextFieldWidget.isUndo(keyCode)) {
            if (this.undoPos < this.undo.size() - 1) {
                Map.Entry<String, Integer> undoData = this.undo.get(++this.undoPos);
                this.onUndo(undoData.getKey());
                this.text = undoData.getKey();
                this.setCursor(undoData.getValue());
                this.cursorX = -1;
                this.onChange.accept(this.text);
            }
            return true;
        }
        if (MultiLineTextFieldWidget.isRedo(keyCode)) {
            if (this.undoPos > 0) {
                Map.Entry<String, Integer> undoData = this.undo.get(--this.undoPos);
                this.onRedo(undoData.getKey());
                this.text = undoData.getKey();
                this.setCursor(undoData.getValue());
                this.cursorX = -1;
                this.onChange.accept(this.text);
            }
            return true;
        }
        if (MultiLineTextFieldWidget.isFind(keyCode)) {
            OverlaySupportingScreen.setOverlayStatic(new FindAndReplaceWidget());
            return true;
        }
        switch (keyCode) {
            case 263: {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(true, false), true);
                } else {
                    this.moveCursor(-1);
                }
                this.cursorX = -1;
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(false, false), true);
                } else {
                    this.moveCursor(1);
                }
                this.cursorX = -1;
                return true;
            }
            case 265: {
                if (class_437.method_25441()) {
                    this.setCursor(0, true);
                } else {
                    this.moveCursorUp();
                }
                return true;
            }
            case 264: {
                if (class_437.method_25441()) {
                    this.setCursor(this.text.length(), true);
                } else {
                    this.moveCursorDown();
                }
                return true;
            }
            case 259: {
                this.erase(true);
                this.cursorX = -1;
                return true;
            }
            case 261: {
                this.erase(false);
                this.cursorX = -1;
                return true;
            }
            case 268: {
                this.setCursor(0, true);
                this.cursorX = -1;
                return true;
            }
            case 269: {
                this.setCursor(this.text.length(), true);
                this.cursorX = -1;
                return true;
            }
            case 257: {
                if (this.newLines && this.getNumNewLines(this.text) + 1 < this.maxLines) {
                    this.write("\n");
                    this.cursorX = -1;
                }
                return true;
            }
        }
        return false;
    }

    protected String pasteFilter(String toPaste) {
        int i;
        toPaste = MVMisc.stripInvalidChars(toPaste, this.newLines);
        int numNewLines = this.getNumNewLines(this.text);
        int toPasteNewLines = this.getNumNewLines(toPaste);
        while (numNewLines + toPasteNewLines + 1 > this.maxLines && (i = toPaste.lastIndexOf(10)) != -1) {
            toPaste = new StringBuilder(toPaste).deleteCharAt(i).toString();
            --toPasteNewLines;
        }
        return toPaste;
    }

    protected int getNumNewLines(String str) {
        int numNewLines = 0;
        for (char c : str.toCharArray()) {
            if (c != '\n') continue;
            ++numNewLines;
        }
        return numNewLines;
    }

    public static boolean isUndo(int code) {
        return code == 90 && class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443();
    }

    public static boolean isRedo(int code) {
        return code == 89 && class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443();
    }

    public static boolean isFind(int code) {
        return code == 70 && class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443();
    }

    private int getWordSkipPosition(boolean backward, boolean passOneSpace) {
        boolean findingText = true;
        boolean foundSpace = false;
        boolean findingText2 = false;
        for (int i = this.cursor + (backward ? -1 : 0); 0 <= i && i < this.text.length(); i += backward ? -1 : 1) {
            char c = this.text.charAt(i);
            if (c == ' ' || c == '\n') {
                if (findingText2) continue;
                if (findingText) {
                    foundSpace = true;
                    continue;
                }
                if (foundSpace || !passOneSpace) {
                    if (backward) {
                        return i + 1;
                    }
                    return i;
                }
                findingText2 = true;
                continue;
            }
            if (findingText2) {
                if (backward) {
                    return i + 1;
                }
                return i;
            }
            findingText = false;
        }
        if (backward) {
            return 0;
        }
        return this.text.length();
    }

    private void moveCursor(int offset) {
        this.setCursor(this.getCursorPosWithOffset(offset), true);
    }

    private int getCursorPosWithOffset(int offset) {
        return class_156.method_27761((String)this.text, (int)(class_437.method_25442() ? this.cursor : (offset > 0 ? this.getSelEnd() : this.getSelStart())), (int)offset);
    }

    private void erase(boolean backwards) {
        if (class_437.method_25441()) {
            this.eraseWords(backwards);
        } else {
            this.eraseCharacters(backwards ? -1 : 1);
        }
    }

    private void eraseWords(boolean backwards) {
        if (this.text.isEmpty()) {
            return;
        }
        if (this.selStart != this.selEnd) {
            this.write("");
            return;
        }
        this.eraseCharacters(this.getWordSkipPosition(backwards, true) - this.getSelStart());
    }

    private void eraseCharacters(int characterOffset) {
        String string;
        int k;
        while (this.undoPos > 0) {
            this.undo.remove(0);
            --this.undoPos;
        }
        if (this.text.isEmpty()) {
            return;
        }
        if (this.selStart != this.selEnd) {
            this.write("");
            return;
        }
        int i = this.getCursorPosWithOffset(characterOffset);
        int j = Math.min(i, this.getSelStart());
        if (j == (k = Math.max(i, this.getSelStart()))) {
            return;
        }
        this.onEdit("", j, k - j);
        this.text = string = new StringBuilder(this.text).delete(j, k).toString();
        this.setCursor(j);
        this.undo.add(0, Map.entry(this.text, this.cursor));
        this.onChange.accept(this.text);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (class_155.method_643((char)chr)) {
            this.write(Character.toString(chr));
            this.cursorX = -1;
            return true;
        }
        return false;
    }

    protected void onCursorMove(int cursor, int selStart, int selEnd) {
    }

    protected void onEdit(String insertedText, int pos, int overwrittenLen) {
    }

    protected void onUndo(String newText) {
    }

    protected void onRedo(String newText) {
    }

    protected void onUndoDiscard() {
    }

    protected String onCopy(String text, int pos, int len) {
        return text;
    }

    protected String onPaste(String text, int pos, int overwrittenLen) {
        return text;
    }

    protected void markUndo() {
        while (this.undoPos > 0) {
            this.undo.remove(0);
            --this.undoPos;
        }
        this.undo.add(0, Map.entry(this.text, this.cursor));
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 var1) {
    }

    private class FindAndReplaceWidget
    extends TranslatedGroupWidget {
        private static String findValue = "";
        private static String replaceValue = "";
        private static boolean regex = false;
        private final NamedTextFieldWidget find;
        private final NamedTextFieldWidget replace;
        private final class_4185 regexBtn;
        private boolean dragging;
        private Matcher lastRegexMatch;

        public FindAndReplaceWidget() {
            super(MainUtil.client.method_22683().method_4486() / 2 - 100, MainUtil.client.method_22683().method_4502() / 2 - 30, 200.0);
            this.find = this.addWidget(new NamedTextFieldWidget(textRenderer, 0, 0, 176, 16, TextInst.of("")).name(TextInst.translatable("nbteditor.multi_line_text.find", new Object[0])));
            this.replace = this.addWidget(new NamedTextFieldWidget(textRenderer, 0, 20, 200, 16, TextInst.of("")).name(TextInst.translatable("nbteditor.multi_line_text.replace", new Object[0])));
            this.regexBtn = this.addWidget(MVMisc.newButton(180, -2, 20, 20, TextInst.translatable("nbteditor.multi_line_text.regex." + (regex ? "on" : "off"), new Object[0]), btn -> {
                regex = !regex;
                btn.method_25355((class_2561)TextInst.translatable("nbteditor.multi_line_text.regex." + (regex ? "on" : "off"), new Object[0]));
            }, new MVTooltip("nbteditor.multi_line_text.regex")));
            this.addWidget(MVMisc.newButton(0, 40, 40, 20, TextInst.translatable("nbteditor.multi_line_text.find", new Object[0]), btn -> this.goToNext(class_437.method_25442(), true)));
            this.addWidget(MVMisc.newButton(44, 40, 64, 20, TextInst.translatable("nbteditor.multi_line_text.replace", new Object[0]), btn -> {
                if (this.goToNext(class_437.method_25442(), true)) {
                    this.replaceSel();
                }
            }));
            this.addWidget(MVMisc.newButton(112, 40, 64, 20, TextInst.translatable("nbteditor.multi_line_text.replace_all", new Object[0]), btn -> {
                boolean first = true;
                int prevCursor = MultiLineTextFieldWidget.this.cursor;
                MultiLineTextFieldWidget.this.cursor = 0;
                while (this.goToNext(false, false)) {
                    if (first) {
                        first = false;
                    } else {
                        MultiLineTextFieldWidget.this.undo.remove(0);
                        MultiLineTextFieldWidget.this.onUndoDiscard();
                    }
                    this.replaceSel();
                }
                if (first) {
                    MultiLineTextFieldWidget.this.cursor = prevCursor;
                }
            }));
            this.addWidget(MVMisc.newButton(180, 40, 20, 20, TextInst.translatable("nbteditor.multi_line_text.x", new Object[0]), btn -> OverlaySupportingScreen.setOverlayStatic(null)));
            if (MultiLineTextFieldWidget.this.selStart != MultiLineTextFieldWidget.this.selEnd) {
                findValue = MultiLineTextFieldWidget.this.getSelectedText();
            }
            this.find.method_1880(Integer.MAX_VALUE);
            this.find.method_1852(findValue);
            this.find.method_1863(str -> {
                findValue = str;
            });
            this.method_25395((class_364)this.find);
            this.replace.method_1880(Integer.MAX_VALUE);
            this.replace.method_1852(replaceValue);
            this.replace.method_1863(str -> {
                replaceValue = str;
            });
        }

        private boolean goToNext(boolean backward, boolean wrap) {
            if (findValue.isEmpty()) {
                return false;
            }
            if (backward) {
                if (MultiLineTextFieldWidget.this.cursor == 0 || !this.goToRange(MultiLineTextFieldWidget.this.text, findValue, MultiLineTextFieldWidget.this.cursor - 1, true)) {
                    return wrap && this.goToRange(MultiLineTextFieldWidget.this.text, findValue, MultiLineTextFieldWidget.this.text.length(), true);
                }
            } else if (!this.goToRange(MultiLineTextFieldWidget.this.text, findValue, MultiLineTextFieldWidget.this.cursor, false)) {
                return wrap && this.goToRange(MultiLineTextFieldWidget.this.text, findValue, 0, false);
            }
            return true;
        }

        private boolean goToRange(String str, String expr, int start, boolean last) {
            if (regex) {
                if (last) {
                    str = str.substring(0, start);
                }
                try {
                    Matcher matcher = Pattern.compile(expr).matcher(str);
                    if (!matcher.find(last ? 0 : start)) {
                        return false;
                    }
                    int numMatches = 0;
                    do {
                        ++numMatches;
                        MultiLineTextFieldWidget.this.selStart = matcher.start();
                        MultiLineTextFieldWidget.this.selEnd = matcher.end();
                        if (MultiLineTextFieldWidget.this.selStart != MultiLineTextFieldWidget.this.selEnd) continue;
                        return false;
                    } while (last && matcher.find());
                    if (last) {
                        matcher.reset();
                        for (int i = 0; i < numMatches; ++i) {
                            matcher.find();
                        }
                    }
                    this.lastRegexMatch = matcher;
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            } else {
                int i;
                int n = i = last ? str.substring(0, start).lastIndexOf(expr) : str.indexOf(expr, start);
                if (i == -1) {
                    return false;
                }
                MultiLineTextFieldWidget.this.selStart = i;
                MultiLineTextFieldWidget.this.selEnd = MultiLineTextFieldWidget.this.selStart + expr.length();
            }
            MultiLineTextFieldWidget.this.cursor = MultiLineTextFieldWidget.this.selEnd;
            MultiLineTextFieldWidget.this.cursorX = -1;
            return true;
        }

        private void replaceSel() {
            if (MultiLineTextFieldWidget.this.selStart == MultiLineTextFieldWidget.this.selEnd) {
                return;
            }
            if (!regex) {
                MultiLineTextFieldWidget.this.write(replaceValue);
                return;
            }
            StringBuilder replacement = new StringBuilder();
            this.lastRegexMatch.appendReplacement(replacement, replaceValue);
            replacement.delete(0, this.lastRegexMatch.start());
            MultiLineTextFieldWidget.this.write(replacement.toString());
        }

        @Override
        public void renderPre(class_4587 matrices, int mouseX, int mouseY, float delta) {
            MVDrawableHelper.fill(matrices, -16, -16, 216, 76, -938471408);
        }

        @Override
        protected boolean mouseClickedPre(double mouseX, double mouseY, int button) {
            if (!(!this.method_25405(mouseX, mouseY) || mouseX >= 0.0 && mouseX <= 200.0 && mouseY >= 0.0 && mouseY <= 60.0)) {
                this.dragging = true;
            }
            return false;
        }

        @Override
        protected boolean mouseReleasedPre(double mouseX, double mouseY, int button) {
            this.dragging = false;
            return false;
        }

        @Override
        public boolean mouseDraggedPre(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.dragging) {
                this.addTranslation(deltaX, deltaY, 0.0);
            }
            return false;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 256) {
                OverlaySupportingScreen.setOverlayStatic(null);
                return true;
            }
            if (keyCode == 257) {
                this.goToNext(class_437.method_25442(), true);
                return true;
            }
            if (keyCode == 258) {
                if (this.method_25399() == this.find) {
                    this.method_25395((class_364)this.replace);
                } else {
                    this.method_25395((class_364)this.find);
                }
                return true;
            }
            if (keyCode == 82 && class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443()) {
                regex = !regex;
                this.regexBtn.method_25355((class_2561)TextInst.translatable("nbteditor.multi_line_text.regex." + (regex ? "on" : "off"), new Object[0]));
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return mouseX >= -16.0 && mouseX <= 216.0 && mouseY >= -16.0 && mouseY <= 76.0;
        }
    }
}

