/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.widgets;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawable;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVElement;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import org.lwjgl.glfw.GLFW;

public abstract class Panel<T extends class_4068 & class_364>
implements MVDrawable,
MVElement,
class_6379 {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int renderPadding;
    protected boolean scrollable;
    protected int scroll;
    private int dragStartX = -1;
    private int dragStartY = -1;
    private int dragStartScroll;

    protected Panel(int x, int y, int width, int height, int renderPadding, boolean scrollable) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.renderPadding = renderPadding;
        this.scrollable = scrollable;
        this.scroll = 0;
    }

    private int getPaddedX() {
        return this.x - this.renderPadding;
    }

    private int getPaddedY() {
        return this.y - this.renderPadding;
    }

    private int getPaddedWidth() {
        return this.width + this.renderPadding * 2;
    }

    private int getPaddedHeight() {
        return this.height + this.renderPadding * 2;
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        double maxScroll;
        double scrollArea;
        boolean scissor;
        boolean dragging;
        this.updateMousePos(mouseX, mouseY);
        this.checkOverScroll();
        boolean bl = dragging = GLFW.glfwGetMouseButton((long)MainUtil.client.method_22683().method_4490(), (int)0) != 0;
        if (!dragging && this.dragStartX != -1) {
            this.dragStartX = -1;
            this.dragStartY = -1;
            this.dragStartScroll = -1;
        }
        if (dragging && this.dragStartX != -1) {
            this.globalMouseDragged(mouseX, mouseY, mouseX - this.dragStartX, mouseY - this.dragStartY);
        }
        if (scissor = this.shouldScissor()) {
            double scale = MainUtil.client.method_22683().method_4495();
            RenderSystem.enableScissor((int)((int)((double)this.getPaddedX() * scale)), (int)(MainUtil.client.method_22683().method_4507() - (int)((double)(this.getPaddedY() + this.getPaddedHeight()) * scale)), (int)((int)((double)this.getPaddedWidth() * scale)), (int)((int)((double)this.getPaddedHeight() * scale)));
        }
        for (PositionedPanelElement<T> pos : this.getPanelElementsSafe()) {
            T element = pos.element();
            matrices.method_22903();
            matrices.method_22904((double)(pos.x() + this.x), (double)(pos.y() + this.y + this.scroll), 0.0);
            element.render(matrices, mouseX - pos.x() - this.x, mouseY - pos.y() - this.y - this.scroll, delta);
            matrices.method_22909();
        }
        if (scissor) {
            RenderSystem.disableScissor();
        }
        if ((scrollArea = (double)this.height / (maxScroll = (double)(-Math.min(this.scroll - this.height, this.getMaxScroll() - this.height)))) < 1.0) {
            double barY = (double)this.y - (double)this.scroll / (maxScroll + scrollArea) * (double)this.height;
            MVDrawableHelper.fill(matrices, this.x + this.width + this.renderPadding - 8, this.y, this.x + this.width + this.renderPadding, this.y + this.height, -5592406);
            MVDrawableHelper.fill(matrices, this.x + this.width + this.renderPadding - 8, (int)barY, this.x + this.width + this.renderPadding, (int)(barY + scrollArea * (double)this.height + 1.0), -16777216);
        }
        if (dragging && this.dragStartX == -1) {
            this.dragStartX = mouseX;
            this.dragStartY = mouseY;
            this.dragStartScroll = this.scroll;
        }
    }

    private void checkOverScroll() {
        int maxScroll = this.getMaxScroll();
        if (this.scroll < maxScroll) {
            this.scroll = maxScroll;
        }
    }

    private void globalMouseDragged(int mouseX, int mouseY, int deltaX, int deltaY) {
        double maxScroll = -Math.min(this.scroll - this.height, this.getMaxScroll() - this.height);
        double scrollArea = (double)this.height / maxScroll;
        if (scrollArea < 1.0 && mouseX >= this.x + this.width + this.renderPadding - 8 && mouseX <= this.x + this.width + this.renderPadding && mouseY >= this.y && mouseY <= this.y + this.height) {
            this.scroll = this.dragStartScroll;
            double barY = (double)this.y - (double)this.scroll / (maxScroll + scrollArea) * (double)this.height;
            this.scroll(((double)this.y - barY - (double)deltaY) * (maxScroll + scrollArea) / (double)this.height - (double)this.scroll);
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    protected abstract Iterable<PositionedPanelElement<T>> getPanelElements();

    protected final List<PositionedPanelElement<T>> getPanelElementsSafe() {
        ArrayList<PositionedPanelElement<T>> output = new ArrayList<PositionedPanelElement<T>>();
        this.getPanelElements().forEach(output::add);
        return output;
    }

    protected boolean shouldScissor() {
        return !ConfigScreen.isMacScrollPatch();
    }

    protected boolean continueEvents() {
        return true;
    }

    protected void updateMousePos(double mouseX, double mouseY) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateMousePos(mouseX, mouseY);
        double maxScroll = -Math.min(this.scroll - this.height, this.getMaxScroll() - this.height);
        double scrollArea = (double)this.height / maxScroll;
        if (scrollArea < 1.0 && mouseX >= (double)(this.x + this.width + this.renderPadding - 8) && mouseX <= (double)(this.x + this.width + this.renderPadding) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height)) {
            return true;
        }
        boolean success = false;
        for (PositionedPanelElement<T> pos : this.getPanelElementsSafe()) {
            if (!((class_364)pos.element()).method_25402(mouseX - (double)pos.x() - (double)this.x, mouseY - (double)pos.y() - (double)this.y - (double)this.scroll, button)) continue;
            success = true;
            if (this.continueEvents()) continue;
            break;
        }
        return success;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.updateMousePos(mouseX, mouseY);
        boolean success = false;
        for (PositionedPanelElement<T> pos : this.getPanelElementsSafe()) {
            if (!((class_364)pos.element()).method_25406(mouseX - (double)pos.x() - (double)this.x, mouseY - (double)pos.y() - (double)this.y - (double)this.scroll, button)) continue;
            success = true;
            if (this.continueEvents()) continue;
            break;
        }
        return success;
    }

    public void method_16014(double mouseX, double mouseY) {
        this.updateMousePos(mouseX, mouseY);
        for (PositionedPanelElement<T> pos : this.getPanelElementsSafe()) {
            ((class_364)pos.element()).method_16014(mouseX - (double)pos.x() - (double)this.x, mouseY - (double)pos.y() - (double)this.y - (double)this.scroll);
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.updateMousePos(mouseX, mouseY);
        boolean success = false;
        for (PositionedPanelElement<T> pos : this.getPanelElementsSafe()) {
            if (!((class_364)pos.element()).method_25403(mouseX - (double)pos.x() - (double)this.x, mouseY - (double)pos.y() - (double)this.y - (double)this.scroll, button, deltaX, deltaY)) continue;
            success = true;
            if (this.continueEvents()) continue;
            break;
        }
        return success;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.updateMousePos(mouseX, mouseY);
        boolean success = false;
        for (PositionedPanelElement<T> pos : this.getPanelElementsSafe()) {
            if (!((class_364)pos.element()).method_25401(mouseX - (double)pos.x() - (double)this.x, mouseY - (double)pos.y() - (double)this.y, amount)) continue;
            success = true;
            if (this.continueEvents()) continue;
            break;
        }
        if (!success && this.scrollable) {
            success = this.scroll(amount * 5.0 * ConfigScreen.getScrollSpeed());
        }
        return success;
    }

    protected boolean scroll(double amount) {
        int maxScroll = this.getMaxScroll();
        if (amount < 0.0 && this.scroll > maxScroll) {
            this.scroll = (int)((double)this.scroll + amount);
            if (this.scroll < maxScroll) {
                this.scroll = maxScroll;
            }
            return true;
        }
        if (amount > 0.0 && this.scroll < 0) {
            this.scroll = (int)((double)this.scroll + amount);
            if (this.scroll > 0) {
                this.scroll = 0;
            }
            return true;
        }
        return false;
    }

    public int getMaxScroll() {
        return Math.min(0, this.height - this.getHighestY());
    }

    protected int getHighestY() {
        return StreamSupport.stream(this.getPanelElements().spliterator(), false).mapToInt(pos -> pos.y() + this.getPanelElementHeight(pos.element())).max().orElse(0);
    }

    protected int getPanelElementHeight(T element) {
        return 0;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean success = false;
        for (PositionedPanelElement<T> pos : this.getPanelElementsSafe()) {
            if (!((class_364)pos.element()).method_25404(keyCode, scanCode, modifiers)) continue;
            success = true;
            if (this.continueEvents()) continue;
            break;
        }
        return success;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        boolean success = false;
        for (PositionedPanelElement<T> pos : this.getPanelElementsSafe()) {
            if (!((class_364)pos.element()).method_16803(keyCode, scanCode, modifiers)) continue;
            success = true;
            if (this.continueEvents()) continue;
            break;
        }
        return success;
    }

    public boolean method_25400(char chr, int modifiers) {
        boolean success = false;
        for (PositionedPanelElement<T> pos : this.getPanelElementsSafe()) {
            if (!((class_364)pos.element()).method_25400(chr, modifiers)) continue;
            success = true;
            if (this.continueEvents()) continue;
            break;
        }
        return success;
    }

    public record PositionedPanelElement<T extends class_4068 & class_364>(T element, int x, int y) {
    }
}

