/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class Enchants {
    public static boolean checkingCap;
    public static boolean cappedAt255;
    private final class_1799 item;
    private final class_2499 enchants;

    public static void checkCap() {
        try {
            checkingCap = true;
            Enchants enchants = new Enchants(new class_1799((class_1935)class_1802.field_20391));
            enchants.addEnchant(class_1893.field_9118, Short.MAX_VALUE);
            ArrayList lines = new ArrayList();
            class_1799.method_17870(lines, (class_2499)enchants.enchants);
            cappedAt255 = lines.stream().map(class_2561::getString).anyMatch(line -> line.contains("255"));
        }
        finally {
            checkingCap = false;
        }
    }

    public static int applyCap(int level) {
        return class_3532.method_15340((int)level, (int)0, (int)(cappedAt255 ? 255 : Integer.MAX_VALUE));
    }

    private static String getEnchantKey(class_1799 item) {
        return item.method_31574(class_1802.field_8598) ? "StoredEnchantments" : "Enchantments";
    }

    public Enchants(class_1799 item) {
        this.item = item;
        this.enchants = new class_2499();
        if (item.method_7985()) {
            this.enchants.addAll((Collection)item.method_7969().method_10554(Enchants.getEnchantKey(item), 10));
        }
    }

    private void save() {
        if (this.enchants.isEmpty()) {
            this.item.method_7948().method_10551(Enchants.getEnchantKey(this.item));
        } else {
            this.item.method_7948().method_10566(Enchants.getEnchantKey(this.item), (class_2520)this.enchants.method_10612());
        }
    }

    public int size() {
        return this.enchants.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public List<EnchantWithLevel> getEnchants() {
        return this.enchants.stream().filter(nbt -> nbt instanceof class_2487).map(nbt -> (class_2487)nbt).map(nbt -> new EnchantWithLevel(MVRegistry.ENCHANTMENT.getOrEmpty(class_2960.method_12829((String)nbt.method_10558("id"))).orElse(null), nbt.method_10550("lvl"))).filter(enchant -> enchant.enchant() != null).collect(Collectors.toList());
    }

    public int getLevel(class_1887 enchant) {
        return this.getEnchants().stream().filter(test -> test.enchant() == enchant).map(EnchantWithLevel::level).reduce(0, (a, b) -> a + b);
    }

    public void addEnchant(class_1887 enchant, int level) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("id", MVRegistry.ENCHANTMENT.getId(enchant).toString());
        nbt.method_10575("lvl", (short)level);
        this.enchants.add((Object)nbt);
        this.save();
    }

    public void addEnchant(EnchantWithLevel enchant) {
        this.addEnchant(enchant.enchant(), enchant.level());
    }

    public void addEnchants(Collection<EnchantWithLevel> enchants) {
        for (EnchantWithLevel enchant : enchants) {
            this.addEnchant(enchant);
        }
    }

    public boolean removeEnchant(class_1887 enchant) {
        String key = MVRegistry.ENCHANTMENT.getId(enchant).toString();
        boolean output = this.enchants.removeIf(test -> {
            class_2487 nbt;
            return !(test instanceof class_2487) || (nbt = (class_2487)test).method_10558("id").equals(key);
        });
        this.save();
        return output;
    }

    public boolean removeEnchants(Collection<class_1887> enchants) {
        boolean output = false;
        for (class_1887 enchant : enchants) {
            output |= this.removeEnchant(enchant);
        }
        return output;
    }

    public boolean removeDuplicates() {
        HashMap<class_1887, Integer> foundEnchants = new HashMap<class_1887, Integer>();
        boolean anyRemoved = false;
        Iterator i = this.enchants.iterator();
        while (i.hasNext()) {
            Integer maxLevel;
            class_2487 nbt;
            Optional<class_1887> enchant;
            Object e = i.next();
            if (!(e instanceof class_2487) || !(enchant = MVRegistry.ENCHANTMENT.getOrEmpty(class_2960.method_12829((String)(nbt = (class_2487)e).method_10558("id")))).isPresent()) continue;
            int level = nbt.method_10550("lvl");
            foundEnchants.put(enchant.get(), Math.max(level, (maxLevel = (Integer)foundEnchants.get(enchant.get())) == null ? 0 : maxLevel));
            if (maxLevel == null) continue;
            i.remove();
            anyRemoved = true;
        }
        if (anyRemoved) {
            for (class_2520 element : this.enchants) {
                class_2487 nbt;
                Optional<class_1887> enchant;
                if (!(element instanceof class_2487) || !(enchant = MVRegistry.ENCHANTMENT.getOrEmpty(class_2960.method_12829((String)(nbt = (class_2487)element).method_10558("id")))).isPresent()) continue;
                nbt.method_10575("lvl", (short)((Integer)foundEnchants.get(enchant.get())).intValue());
            }
        }
        this.save();
        return anyRemoved;
    }

    public void setEnchant(class_1887 enchant, int level, boolean onlyUpgrade) {
        String key = MVRegistry.ENCHANTMENT.getId(enchant).toString();
        boolean anySet = false;
        boolean anyFound = false;
        for (class_2520 element : this.enchants) {
            class_2487 nbt;
            if (!(element instanceof class_2487) || !(nbt = (class_2487)element).method_10558("id").equals(key)) continue;
            if (!onlyUpgrade || nbt.method_10550("lvl") < level) {
                nbt.method_10575("lvl", (short)level);
                anySet = true;
            }
            anyFound = true;
        }
        if (anySet) {
            this.save();
        } else if (!anyFound) {
            this.addEnchant(enchant, level);
        }
    }

    public void setEnchant(EnchantWithLevel enchant, boolean onlyUpgrade) {
        this.setEnchant(enchant.enchant(), enchant.level(), onlyUpgrade);
    }

    public void setEnchants(Collection<EnchantWithLevel> enchants, boolean onlyUpgrade) {
        for (EnchantWithLevel enchant : enchants) {
            this.setEnchant(enchant, onlyUpgrade);
        }
    }

    public void replaceEnchants(Collection<EnchantWithLevel> enchants) {
        this.enchants.clear();
        if (enchants.isEmpty()) {
            this.save();
        } else {
            this.addEnchants(enchants);
        }
    }

    public void clearEnchants() {
        this.enchants.clear();
        this.save();
    }

    public record EnchantWithLevel(class_1887 enchant, int level) {
    }
}

