/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ItemChest {
    private final class_1799 item;
    private final class_1277 inv;

    public static <T> class_1799 writeDatabase(class_1799 container, List<T> data, Function<T, class_1799> stackGenerator, List<String> path) {
        ItemChest chest = new ItemChest(container);
        if (data.size() <= 27) {
            for (T item : data) {
                chest.addStack(stackGenerator.apply(item));
            }
        } else {
            int sectionSize = 27;
            while (data.size() / sectionSize > 27) {
                sectionSize *= 27;
            }
            for (int i = 0; i < 27 && i * sectionSize < data.size(); ++i) {
                class_1799 section = new class_1799((class_1935)class_1802.field_8545);
                path.add("" + i);
                section.method_7977(TextInst.of(TextInst.translatable("nbteditor.hdb.section", new Object[0]).getString() + ": " + String.join((CharSequence)".", path)));
                ItemChest.writeDatabase(section, data.subList(i * sectionSize, Math.min(data.size(), (i + 1) * sectionSize)), stackGenerator, path);
                path.remove(path.size() - 1);
                chest.addStack(section);
            }
        }
        return container;
    }

    public static <T> class_1799 writeDatabase(class_1799 container, List<T> data, Function<T, class_1799> stackGenerater) {
        return ItemChest.writeDatabase(container, data, stackGenerater, new ArrayList<String>());
    }

    public ItemChest(class_1799 item) {
        class_2499 items;
        class_2487 blockEntityTag;
        class_2487 nbt;
        this.item = item;
        this.inv = new class_1277(27);
        if (item.method_7985() && (nbt = item.method_7969()).method_10573("BlockEntityTag", 10) && (blockEntityTag = nbt.method_10562("BlockEntityTag")).method_10573("Items", 9) && !(items = blockEntityTag.method_10554("Items", 10)).isEmpty()) {
            for (class_2520 containedItemElement : items) {
                class_2487 containedItem = (class_2487)containedItemElement;
                try {
                    this.inv.method_5447((int)containedItem.method_10571("Slot"), class_1799.method_7915((class_2487)containedItem));
                }
                catch (Exception e) {
                    NBTEditor.LOGGER.error("Error while reading a container", (Throwable)e);
                }
            }
        }
    }

    public class_1799 getItem() {
        return this.item;
    }

    public boolean addStack(class_1799 item) {
        if (this.inv.method_5491(item) == class_1799.field_8037) {
            this.save();
            return true;
        }
        return false;
    }

    public boolean addStack(ItemChest item) {
        return this.addStack(item.getItem());
    }

    public void setStack(int slot, class_1799 item) {
        this.inv.method_5447(slot, item);
        this.save();
    }

    public void setStack(int slot, ItemChest item) {
        this.setStack(slot, item.getItem());
    }

    public void setAll(class_1799[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.inv.method_5447(i, items[i]);
        }
        this.save();
    }

    public class_1799 getStack(int slot) {
        return this.inv.method_5438(slot);
    }

    public class_1799[] getAll() {
        class_1799[] output = new class_1799[this.inv.method_5439()];
        for (int i = 0; i < output.length; ++i) {
            output[i] = this.inv.method_5438(i);
        }
        return output;
    }

    private void save() {
        class_2487 nbt = this.item.method_7948();
        if (!nbt.method_10573("BlockEntityTag", 10)) {
            nbt.method_10566("BlockEntityTag", (class_2520)new class_2487());
        }
        class_2487 blockEntityTag = nbt.method_10562("BlockEntityTag");
        class_2499 items = blockEntityTag.method_10554("Items", 10);
        blockEntityTag.method_10566("Items", (class_2520)items);
        items.clear();
        for (int i = 0; i < this.inv.method_5439(); ++i) {
            class_1799 item = this.inv.method_5438(i);
            if (item == null || item.method_7960()) continue;
            class_2487 itemNbt = new class_2487();
            itemNbt.method_10567("Slot", (byte)i);
            item.method_7953(itemNbt);
            items.add((Object)itemNbt);
        }
    }
}

