/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.TextUtil;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class Lore {
    private final class_1799 item;
    private final class_2499 lore;

    public Lore(class_1799 item) {
        this.item = item;
        this.lore = new class_2499();
        if (item.method_7985() && item.method_7969().method_10573("display", 10)) {
            this.lore.addAll((Collection)item.method_7969().method_10562("display").method_10554("Lore", 8));
        }
    }

    public class_1799 getItem() {
        return this.item;
    }

    private void save() {
        if (this.lore.isEmpty()) {
            this.item.method_7911("display").method_10551("Lore");
        } else {
            this.item.method_7911("display").method_10566("Lore", (class_2520)this.lore.method_10612());
        }
    }

    public int size() {
        return this.lore.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public List<class_2561> getLore() {
        return this.lore.stream().map(element -> class_2561.class_2562.method_10877((String)((class_2519)element).method_10714())).collect(Collectors.toList());
    }

    public class_2561 getLine(int pos) {
        if (pos < 0) {
            pos = this.lore.size() + pos;
        }
        return class_2561.class_2562.method_10877((String)((class_2519)this.lore.method_10534(pos)).method_10714());
    }

    public void addLine(class_2561 text, int pos) {
        class_2519 line = class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)text));
        if (pos < 0) {
            this.lore.method_10531(this.lore.size() + pos + 1, (class_2520)line);
        } else {
            this.lore.method_10531(pos, (class_2520)line);
        }
        this.save();
    }

    public void addLine(class_2561 text) {
        this.addLine(text, -1);
    }

    public void removeLine(int pos) {
        if (pos < 0) {
            this.lore.method_10536(this.lore.size() + pos);
        } else {
            this.lore.method_10536(pos);
        }
        this.save();
    }

    public void setLine(class_2561 text, int pos) {
        class_2519 line = class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)text));
        if (pos < 0) {
            this.lore.method_10606(this.lore.size() + pos, (class_2520)line);
        } else {
            this.lore.method_10606(pos, (class_2520)line);
        }
        this.save();
    }

    public void setAllLines(Collection<class_2561> lines) {
        this.lore.clear();
        if (lines.isEmpty()) {
            this.save();
        } else {
            lines.forEach(this::addLine);
        }
    }

    public void clearLore() {
        this.lore.clear();
        this.save();
    }

    public void addImage(BufferedImage img, int width, int height, int pos) {
        if (pos < 0) {
            pos = this.lore.size() + pos + 1;
        }
        img = MainUtil.scaleImage(img, width, height);
        for (int line = 0; line < height; ++line) {
            EditableText lineText = TextInst.literal("").styled(style -> style.method_10978(Boolean.valueOf(false)));
            for (int i = 0; i < width; ++i) {
                int color = img.getRGB(i, line) & 0xFFFFFF;
                lineText.append(TextInst.literal("\u2588").styled(style -> style.method_36139(color)));
            }
            this.addLine(lineText, pos + line);
        }
    }

    public void addImage(BufferedImage img, int width, int height) {
        this.addImage(img, width, height, -1);
    }

    public static interface LoreConsumer {
        public static LoreConsumer createAppend(class_1799 item) {
            final Lore lore = new Lore(item);
            return new LoreConsumer(){

                @Override
                public Lore getLore() {
                    return lore;
                }

                @Override
                public int getPos() {
                    return -1;
                }

                @Override
                public void onLoreEdit(Lore lore2) {
                }
            };
        }

        public static LoreConsumer createReceiveItem(final class_1799 item) {
            return new LoreConsumer(){

                @Override
                public Lore getLore() {
                    return new Lore(item);
                }

                @Override
                public int getPos() {
                    return -1;
                }

                @Override
                public void onLoreEdit(Lore lore) {
                    MainUtil.getWithMessage(item);
                }
            };
        }

        public static LoreConsumer createAppendPage(class_2561 page, final Consumer<class_2561> newPage) {
            final Lore lore = new Lore(new class_1799((class_1935)class_1802.field_8529));
            lore.setAllLines(TextUtil.splitText(page));
            return new LoreConsumer(){

                @Override
                public Lore getLore() {
                    return lore;
                }

                @Override
                public int getPos() {
                    return -1;
                }

                @Override
                public void onLoreEdit(Lore lore2) {
                    newPage.accept(TextUtil.joinLines(lore2.getLore()));
                }
            };
        }

        public Lore getLore();

        public int getPos();

        public void onLoreEdit(Lore var1);
    }
}

