/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.google.gson.JsonParseException;
import com.luneruniverse.minecraft.mod.nbteditor.async.UpdateCheckerThread;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.zip.ZipException;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2873;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class MainUtil {
    public static final class_310 client = class_310.method_1551();
    private static final class_2960 LOGO = new class_2960("nbteditor", "textures/logo.png");
    private static final class_2960 LOGO_UPDATE_AVAILABLE = new class_2960("nbteditor", "textures/logo_update_available.png");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);

    public static void saveItem(class_1268 hand, class_1799 item) {
        MainUtil.client.field_1724.method_6122(hand, item.method_7972());
        if (MainUtil.client.field_1761.method_2920().method_8386()) {
            client.method_1562().method_2883((class_2596)new class_2873(hand == class_1268.field_5810 ? 45 : MainUtil.client.field_1724.method_31548().field_7545 + 36, item));
        }
    }

    public static void saveItem(class_1304 equipment, class_1799 item) {
        if (equipment == class_1304.field_6173) {
            MainUtil.saveItem(class_1268.field_5808, item);
        } else if (equipment == class_1304.field_6171) {
            MainUtil.saveItem(class_1268.field_5810, item);
        } else {
            MainUtil.client.field_1724.method_31548().field_7548.set(equipment.method_5927(), (Object)item.method_7972());
            MainUtil.client.field_1761.method_2909(item, 8 - equipment.method_5927());
        }
    }

    public static void saveItem(int slot, class_1799 item) {
        MainUtil.client.field_1724.method_31548().method_5447(slot == 45 ? 40 : slot, item.method_7972());
        MainUtil.client.field_1761.method_2909(item, slot < 9 ? slot + 36 : slot);
    }

    public static void saveItemInvSlot(int slot, class_1799 item) {
        MainUtil.saveItem(slot == 45 ? 45 : (slot >= 36 ? slot - 36 : slot), item);
    }

    public static void get(class_1799 item, boolean dropIfNoSpace) {
        class_1661 inv = MainUtil.client.field_1724.method_31548();
        int slot = inv.method_7390(item = item.method_7972());
        if (slot == -1) {
            slot = inv.method_7376();
        }
        if (slot == -1) {
            if (dropIfNoSpace) {
                if (item.method_7947() > item.method_7914()) {
                    item.method_7939(item.method_7914());
                }
                MainUtil.client.field_1761.method_2915(item);
            }
        } else {
            item.method_7939(item.method_7947() + inv.method_5438(slot).method_7947());
            int overflow = 0;
            if (item.method_7947() > item.method_7914()) {
                overflow = item.method_7947() - item.method_7914();
                item.method_7939(item.method_7914());
            }
            MainUtil.saveItem(slot, item);
            if (overflow != 0) {
                item.method_7939(overflow);
                MainUtil.get(item, false);
            }
        }
    }

    public static void getWithMessage(class_1799 item) {
        MainUtil.get(item, true);
        MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.get.item", new Object[0]).append(item.method_7954()), false);
    }

    public static void renderLogo(class_4587 matrices) {
        MVDrawableHelper.drawTexture(matrices, UpdateCheckerThread.UPDATE_AVAILABLE ? LOGO_UPDATE_AVAILABLE : LOGO, 16, 16, 0.0f, 0.0f, 32, 32, 32, 32);
    }

    public static void drawWrappingString(class_4587 matrices, class_327 renderer, String text, int x, int y, int maxWidth, int color, boolean centerHorizontal, boolean centerVertical) {
        maxWidth = Math.max(maxWidth, renderer.method_1727("ww"));
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<Integer> spaces = new ArrayList<Integer>();
        StringBuilder currentPart = new StringBuilder();
        boolean wasUpperCase = false;
        for (char c : text.toCharArray()) {
            if (c == ' ') {
                wasUpperCase = false;
                parts.add(currentPart.toString());
                currentPart.setLength(0);
                spaces.add(parts.size());
                continue;
            }
            boolean upperCase = Character.isUpperCase(c);
            if (upperCase != wasUpperCase && !currentPart.isEmpty()) {
                if (wasUpperCase) {
                    parts.add(currentPart.substring(0, currentPart.length() - 1));
                    currentPart.delete(0, currentPart.length() - 1);
                } else {
                    parts.add(currentPart.toString());
                    currentPart.setLength(0);
                }
            }
            wasUpperCase = upperCase;
            currentPart.append(c);
        }
        if (!currentPart.isEmpty()) {
            parts.add(currentPart.toString());
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        Object line = "";
        int i = 0;
        for (String part : parts) {
            String partAddition = (!((String)line).isEmpty() && spaces.contains(i) ? " " : "") + part;
            if (renderer.method_1727((String)line + partAddition) > maxWidth) {
                if (!((String)line).isEmpty()) {
                    lines.add(line);
                    line = "";
                }
                if (renderer.method_1727(part) > maxWidth) {
                    int numChars;
                    do {
                        numChars = 1;
                        while (renderer.method_1727(part.substring(0, numChars)) < maxWidth) {
                            ++numChars;
                        }
                        lines.add(part.substring(0, --numChars));
                    } while (renderer.method_1727(part = part.substring(numChars)) >= maxWidth);
                    line = part;
                } else {
                    line = part;
                }
            } else {
                line = (String)line + partAddition;
            }
            ++i;
        }
        if (!((String)line).isEmpty()) {
            lines.add(line);
        }
        for (i = 0; i < lines.size(); ++i) {
            int n;
            line = (String)lines.get(i);
            Objects.requireNonNull(renderer);
            if (centerVertical) {
                Objects.requireNonNull(renderer);
                n = -9 * lines.size() / 2;
            } else {
                n = 0;
            }
            int offsetY = i * 9 + n;
            if (centerHorizontal) {
                MVDrawableHelper.drawCenteredTextWithShadow(matrices, renderer, TextInst.of((String)line), x, y + offsetY, color);
                continue;
            }
            MVDrawableHelper.drawTextWithShadow(matrices, renderer, TextInst.of((String)line), x, y + offsetY, color);
        }
    }

    public static String colorize(String text) {
        StringBuilder output = new StringBuilder();
        boolean colorCode = false;
        for (char c : text.toCharArray()) {
            if (c == '&') {
                colorCode = true;
                continue;
            }
            if (colorCode) {
                colorCode = false;
                if (("" + c).replaceAll("[0-9a-fA-Fk-oK-OrR]", "").isEmpty()) {
                    output.append('\u00a7');
                } else {
                    output.append('&');
                }
            }
            output.append(c);
        }
        if (colorCode) {
            output.append('&');
        }
        return output.toString();
    }

    public static String stripColor(String text) {
        return text.replaceAll("\\xA7[0-9a-fA-Fk-oK-OrR]", "");
    }

    public static class_2561 getItemNameSafely(class_1799 item) {
        class_2487 nbt = item.method_7941("display");
        if (nbt != null && nbt.method_10573("Name", 8)) {
            try {
                class_5250 text = class_2561.class_2562.method_10877((String)nbt.method_10558("Name"));
                if (text != null) {
                    return text;
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return item.method_7909().method_7864(item);
    }

    public static class_1767 getDyeColor(class_124 color) {
        switch (color) {
            case field_1075: {
                return class_1767.field_7951;
            }
            case field_1074: {
                return class_1767.field_7963;
            }
            case field_1078: {
                return class_1767.field_7966;
            }
            case field_1062: {
                return class_1767.field_7955;
            }
            case field_1058: {
                return class_1767.field_7966;
            }
            case field_1063: {
                return class_1767.field_7944;
            }
            case field_1077: {
                return class_1767.field_7942;
            }
            case field_1064: {
                return class_1767.field_7945;
            }
            case field_1079: {
                return class_1767.field_7964;
            }
            case field_1065: {
                return class_1767.field_7946;
            }
            case field_1080: {
                return class_1767.field_7967;
            }
            case field_1060: {
                return class_1767.field_7961;
            }
            case field_1076: {
                return class_1767.field_7954;
            }
            case field_1061: {
                return class_1767.field_7964;
            }
            case field_1068: {
                return class_1767.field_7952;
            }
            case field_1054: {
                return class_1767.field_7947;
            }
        }
        return class_1767.field_7957;
    }

    public static class_1799 copyAirable(class_1799 item) {
        class_1799 output = new class_1799((class_1935)item.method_7909(), item.method_7947());
        output.method_7912(item.method_7965());
        if (item.method_7969() != null) {
            output.method_7980(item.method_7969().method_10553());
        }
        return output;
    }

    public static class_1799 setType(class_1792 type, class_1799 item, int count) {
        class_2487 fullData = new class_2487();
        item.method_7953(fullData);
        fullData.method_10582("id", MVRegistry.ITEM.getId(type).toString());
        fullData.method_10569("Count", count);
        return class_1799.method_7915((class_2487)fullData);
    }

    public static class_1799 setType(class_1792 type, class_1799 item) {
        return MainUtil.setType(type, item, item.method_7947());
    }

    public static <T> Event<T> newEvent(Class<T> clazz) {
        return EventFactory.createArrayBacked(clazz, listeners -> Proxy.newProxyInstance(MainUtil.class.getClassLoader(), new Class[]{clazz}, (obj, method, args) -> {
            for (Object listener : listeners) {
                class_1269 result = (class_1269)method.invoke(listener, args);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            return class_1269.field_5811;
        }));
    }

    public static class_2487 readNBT(InputStream in) throws IOException {
        class_2487 nbt;
        byte[] data = in.readAllBytes();
        DataInputStream resetableIn = new DataInputStream(new ByteArrayInputStream(data));
        try {
            nbt = class_2507.method_10629((InputStream)resetableIn);
        }
        catch (ZipException e) {
            resetableIn.reset();
            nbt = class_2507.method_10627((DataInput)resetableIn);
        }
        return nbt;
    }

    public static String getFormattedCurrentTime() {
        return DATE_TIME_FORMATTER.format(ZonedDateTime.now());
    }

    public static boolean equals(double a, double b, double epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static boolean equals(double a, double b) {
        return MainUtil.equals(a, b, 1.0E-5);
    }

    public static BufferedImage scaleImage(BufferedImage img, int width, int height) {
        Image temp = img.getScaledInstance(width, height, 4);
        BufferedImage output = new BufferedImage(width, height, 2);
        Graphics2D g = output.createGraphics();
        g.drawImage(temp, 0, 0, null);
        g.dispose();
        return output;
    }

    public static int[] getMousePos() {
        double scale = (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
        int x = (int)(MainUtil.client.field_1729.method_1603() * scale);
        int y = (int)(MainUtil.client.field_1729.method_1604() * scale);
        return new int[]{x, y};
    }

    public static void mapMatrices(class_4587 matrices, int fromX, int fromY, int fromWidth, int fromHeight, int toX, int toY, int toWidth, int toHeight) {
        matrices.method_22904((double)toX, (double)toY, 0.0);
        matrices.method_22905((float)toWidth / (float)fromWidth, (float)toHeight / (float)fromHeight, 1.0f);
        matrices.method_22904((double)(-fromX), (double)(-fromY), 0.0);
    }

    public static Predicate<String> intPredicate(Supplier<Integer> min, Supplier<Integer> max, boolean allowEmpty) {
        return str -> {
            if (str.isEmpty()) {
                return allowEmpty;
            }
            try {
                int value = Integer.parseInt(str);
                return !(min != null && (Integer)min.get() > value || max != null && value > (Integer)max.get());
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
    }

    public static Predicate<String> intPredicate(Integer min, Integer max, boolean allowEmpty) {
        return MainUtil.intPredicate(() -> min, () -> max, allowEmpty);
    }

    public static Predicate<String> intPredicate() {
        return MainUtil.intPredicate((Supplier<Integer>)null, null, true);
    }

    public static Integer parseOptionalInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

