/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2561;
import net.minecraft.class_4614;

public class NbtFormatter {
    public static Impl FORMATTER = NbtFormatter::formatElement;
    private static final SimpleCommandExceptionType TRAILING_DATA = new SimpleCommandExceptionType((Message)TextInst.translatable("argument.nbt.trailing", new Object[0]));
    private static final SimpleCommandExceptionType EXPECTED_KEY = new SimpleCommandExceptionType((Message)TextInst.translatable("argument.nbt.expected.key", new Object[0]));
    private static final SimpleCommandExceptionType EXPECTED_VALUE = new SimpleCommandExceptionType((Message)TextInst.translatable("argument.nbt.expected.value", new Object[0]));
    private static final DynamicCommandExceptionType ARRAY_INVALID = new DynamicCommandExceptionType(type -> TextInst.translatable("argument.nbt.array.invalid", type));
    private static final Pattern DOUBLE_PATTERN_IMPLICIT = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private static final class_124 NAME_COLOR = class_124.field_1075;
    private static final class_124 STRING_COLOR = class_124.field_1060;
    private static final class_124 NUMBER_COLOR = class_124.field_1065;
    private static final class_124 TYPE_SUFFIX_COLOR = class_124.field_1061;
    public static final Map<String, Number> SPECIAL_NUMS = Map.of("NaNd", Double.NaN, "Infinityd", Double.POSITIVE_INFINITY, "-Infinityd", Double.NEGATIVE_INFINITY, "NaNf", Float.valueOf(Float.NaN), "Infinityf", Float.valueOf(Float.POSITIVE_INFINITY), "-Infinityf", Float.valueOf(Float.NEGATIVE_INFINITY));
    private StringReader reader;

    public static class_2561 formatElement(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        MixinLink.parseSpecialElement(reader);
        reader.setCursor(cursor);
        NbtFormatter formatter = new NbtFormatter(reader);
        EditableText output = formatter.parseElement();
        output.append(formatter.skipWhitespace());
        if (reader.canRead()) {
            throw TRAILING_DATA.createWithContext((ImmutableStringReader)reader);
        }
        return output;
    }

    public static class_2561 formatElement(String str) throws CommandSyntaxException {
        return NbtFormatter.formatElement(new StringReader(str));
    }

    private NbtFormatter(StringReader reader) {
        this.reader = reader;
    }

    private EditableText skipWhitespace() {
        StringBuilder output = new StringBuilder();
        while (this.reader.canRead() && Character.isWhitespace(this.reader.peek())) {
            output.append(this.reader.read());
        }
        return TextInst.literal(output.toString());
    }

    private String readStringUntil(char terminator) throws CommandSyntaxException {
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        while (this.reader.canRead()) {
            char c = this.reader.read();
            if (escaped) {
                if (c == terminator || c == '\\') {
                    result.append(c);
                    escaped = false;
                    continue;
                }
                this.reader.setCursor(this.reader.getCursor() - 1);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidEscape().createWithContext((ImmutableStringReader)this.reader, (Object)String.valueOf(c));
            }
            if (c == '\\') {
                escaped = true;
                result.append(c);
                continue;
            }
            if (c == terminator) {
                return result.toString();
            }
            result.append(c);
        }
        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedEndOfQuote().createWithContext((ImmutableStringReader)this.reader);
    }

    private String readString() throws CommandSyntaxException {
        if (!this.reader.canRead()) {
            return "";
        }
        char next = this.reader.peek();
        if (StringReader.isQuotedStringStart((char)next)) {
            this.reader.skip();
            return next + this.readStringUntil(next) + next;
        }
        return this.reader.readUnquotedString();
    }

    private EditableText readString(class_124 color) throws CommandSyntaxException {
        EditableText output = TextInst.literal("");
        output.append(this.skipWhitespace());
        if (!this.reader.canRead()) {
            throw EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
        }
        String str = this.readString();
        if (str.isEmpty()) {
            return null;
        }
        output.append(TextInst.literal(str).formatted(color));
        return output;
    }

    private EditableText readQuotedString() throws CommandSyntaxException {
        EditableText output = TextInst.literal("");
        if (!this.reader.canRead()) {
            return output;
        }
        char next = this.reader.peek();
        if (!StringReader.isQuotedStringStart((char)next)) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedStartOfQuote().createWithContext((ImmutableStringReader)this.reader);
        }
        this.reader.skip();
        output.append(TextInst.literal(this.readStringUntil(next)));
        return output;
    }

    private Map.Entry<Boolean, EditableText> readComma() {
        EditableText output = TextInst.literal("");
        output.append(this.skipWhitespace());
        if (this.reader.canRead() && this.reader.peek() == ',') {
            output.append(TextInst.literal("" + this.reader.read()));
            output.append(this.skipWhitespace());
            return Map.entry(true, output);
        }
        return Map.entry(false, output);
    }

    private EditableText readArray(class_4614<?> arrayTypeReader, class_4614<?> typeReader) throws CommandSyntaxException {
        EditableText output = TextInst.literal("");
        while (this.reader.peek() != ']') {
            output.append(this.parseElement());
            Map.Entry<Boolean, EditableText> comma = this.readComma();
            output.append(comma.getValue());
            if (!comma.getKey().booleanValue()) break;
            if (this.reader.canRead()) continue;
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        output.append(this.expect(']'));
        return output;
    }

    private EditableText parseElement() throws CommandSyntaxException {
        EditableText output = TextInst.literal("");
        output.append(this.skipWhitespace());
        if (!this.reader.canRead()) {
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        char c = this.reader.peek();
        if (c == '{') {
            output.append(this.parseCompound());
        } else if (c == '[') {
            output.append(this.parseArray());
        } else {
            output.append(this.parseElementPrimitive());
        }
        return output;
    }

    private EditableText parseCompound() throws CommandSyntaxException {
        EditableText output = TextInst.literal("");
        output.append(this.expect('{'));
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != '}') {
            int i = this.reader.getCursor();
            EditableText string = this.readString(NAME_COLOR);
            if (string == null) {
                this.reader.setCursor(i);
                throw EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
            }
            output.append(string);
            output.append(this.expect(':'));
            output.append(this.parseElement());
            Map.Entry<Boolean, EditableText> comma = this.readComma();
            output.append(comma.getValue());
            if (!comma.getKey().booleanValue()) break;
            if (this.reader.canRead()) continue;
            throw EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
        }
        output.append(this.expect('}'));
        return output;
    }

    private EditableText parseArray() throws CommandSyntaxException {
        if (this.reader.canRead(3) && !StringReader.isQuotedStringStart((char)this.reader.peek(1)) && this.reader.peek(2) == ';') {
            return this.parseElementPrimitiveArray();
        }
        return this.parseList();
    }

    private EditableText parseElementPrimitiveArray() throws CommandSyntaxException {
        EditableText output = TextInst.literal("");
        output.append(this.expect('['));
        int i = this.reader.getCursor();
        char c = this.reader.read();
        output.append(TextInst.literal("" + c).formatted(TYPE_SUFFIX_COLOR));
        output.append(TextInst.literal("" + this.reader.read()));
        output.append(this.skipWhitespace());
        if (!this.reader.canRead()) {
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        if (c == 'B') {
            output.append(this.readArray(class_2479.field_21024, class_2481.field_21025));
            return output;
        }
        if (c == 'L') {
            output.append(this.readArray(class_2501.field_21040, class_2503.field_21041));
            return output;
        }
        if (c == 'I') {
            output.append(this.readArray(class_2495.field_21036, class_2497.field_21037));
            return output;
        }
        this.reader.setCursor(i);
        throw ARRAY_INVALID.createWithContext((ImmutableStringReader)this.reader, (Object)String.valueOf(c));
    }

    private EditableText parseList() throws CommandSyntaxException {
        EditableText output = TextInst.literal("");
        output.append(this.expect('['));
        output.append(this.skipWhitespace());
        if (!this.reader.canRead()) {
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        while (this.reader.peek() != ']') {
            EditableText nbtElement = this.parseElement();
            output.append(nbtElement);
            Map.Entry<Boolean, EditableText> comma = this.readComma();
            output.append(comma.getValue());
            if (!comma.getKey().booleanValue()) break;
            if (this.reader.canRead()) continue;
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        output.append(this.expect(']'));
        return output;
    }

    private EditableText parseElementPrimitive() throws CommandSyntaxException {
        EditableText output = TextInst.literal("");
        output.append(this.skipWhitespace());
        int i = this.reader.getCursor();
        char quote = this.reader.peek();
        if (StringReader.isQuotedStringStart((char)quote)) {
            output.append(TextInst.literal("" + quote).formatted(STRING_COLOR)).append(this.readQuotedString().formatted(STRING_COLOR)).append(TextInst.literal("" + quote).formatted(STRING_COLOR));
            return output;
        }
        String string = this.reader.readUnquotedString();
        if (string.isEmpty()) {
            this.reader.setCursor(i);
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        return this.parsePrimitive(string);
    }

    private EditableText parsePrimitive(String input) {
        try {
            EditableText numberInput;
            EditableText editableText = numberInput = input.isEmpty() ? TextInst.literal("") : TextInst.literal(input.substring(0, input.length() - 1)).formatted(NUMBER_COLOR).append(TextInst.literal(input.substring(input.length() - 1)).formatted(TYPE_SUFFIX_COLOR));
            if (FLOAT_PATTERN.matcher(input).matches()) {
                return numberInput;
            }
            if (BYTE_PATTERN.matcher(input).matches()) {
                return numberInput;
            }
            if (LONG_PATTERN.matcher(input).matches()) {
                return numberInput;
            }
            if (SHORT_PATTERN.matcher(input).matches()) {
                return numberInput;
            }
            if (INT_PATTERN.matcher(input).matches()) {
                return TextInst.literal(input).formatted(NUMBER_COLOR);
            }
            if (DOUBLE_PATTERN.matcher(input).matches()) {
                return numberInput;
            }
            if (DOUBLE_PATTERN_IMPLICIT.matcher(input).matches()) {
                return TextInst.literal(input).formatted(NUMBER_COLOR);
            }
            if ("true".equalsIgnoreCase(input)) {
                return TextInst.literal(input).formatted(NUMBER_COLOR);
            }
            if ("false".equalsIgnoreCase(input)) {
                return TextInst.literal(input).formatted(NUMBER_COLOR);
            }
            if (ConfigScreen.isSpecialNumbers() && SPECIAL_NUMS.containsKey(input)) {
                return numberInput;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return TextInst.literal(input).formatted(STRING_COLOR);
    }

    private EditableText expect(char c) throws CommandSyntaxException {
        EditableText output = TextInst.literal("");
        output.append(this.skipWhitespace());
        this.reader.expect(c);
        output.append(TextInst.literal("" + c));
        return output;
    }

    @FunctionalInterface
    public static interface Impl {
        public class_2561 format(String var1) throws CommandSyntaxException;

        default public FormatterResult formatSafely(String str) {
            try {
                return new FormatterResult(this.format(str), true);
            }
            catch (Exception e) {
                return new FormatterResult(TextInst.literal(str).formatted(class_124.field_1061), false);
            }
        }
    }

    public record FormatterResult(class_2561 text, boolean isSuccess) {
    }
}

