/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OrderedMap<K, V>
implements Map<K, V> {
    private final List<Map.Entry<K, V>> internalMap = new ArrayList<Map.Entry<K, V>>();
    private Comparator<K> sorter;

    public OrderedMap(Comparator<K> sorter) {
        this.sorter = sorter;
    }

    public OrderedMap() {
        this(null);
    }

    public void sort(Comparator<K> sorter) {
        if (sorter == null) {
            return;
        }
        this.sorter = null;
        this.sortUnchecked(sorter);
    }

    private void sortUnchecked(Comparator<K> sorter) {
        if (sorter != null) {
            this.internalMap.sort((a, b) -> sorter.compare(a.getKey(), b.getKey()));
        }
    }

    public void setSorter(Comparator<K> sorter) {
        this.sorter = sorter;
        this.sort(sorter);
    }

    public Comparator<K> getSorter() {
        return this.sorter;
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.stream().anyMatch(entry -> entry.getKey().equals(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.stream().anyMatch(entry -> entry.getValue().equals(value));
    }

    @Override
    public V get(Object key) {
        return this.internalMap.stream().filter(entry -> entry.getKey().equals(key)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    @Override
    public V put(K key, V value) {
        V output = this.unsortedPut(key, value);
        this.sortUnchecked(this.sorter);
        return output;
    }

    private V unsortedPut(final K key, final V value) {
        return (V)this.internalMap.stream().filter(entry -> entry.getKey().equals(key)).findFirst().map(entry -> entry.setValue(value)).orElseGet(() -> {
            this.internalMap.add(new Map.Entry<K, V>(){
                private V entryValue;
                {
                    this.entryValue = value;
                }

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return this.entryValue;
                }

                @Override
                public V setValue(V value2) {
                    Object prev = this.entryValue;
                    this.entryValue = value2;
                    return prev;
                }
            });
            return null;
        });
    }

    @Override
    public V remove(Object key) {
        Iterator<Map.Entry<K, V>> i = this.internalMap.iterator();
        while (i.hasNext()) {
            Map.Entry<K, V> entry = i.next();
            if (!entry.getKey().equals(key)) continue;
            i.remove();
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::unsortedPut);
        this.sortUnchecked(this.sorter);
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return new SetView(this.internalMap.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
    }

    @Override
    public Collection<V> values() {
        return new CollectionView(this.internalMap.stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SetView<Map.Entry<K, V>>(new ArrayList<Map.Entry<K, V>>(this.internalMap));
    }

    private class SetView<T>
    extends CollectionView<T>
    implements Set<T> {
        public SetView(List<T> data) {
            super(data);
        }
    }

    private class CollectionView<T>
    implements Collection<T> {
        private final List<T> data;

        public CollectionView(List<T> data) {
            this.data = data;
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.data.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < CollectionView.this.data.size();
                }

                @Override
                public T next() {
                    return CollectionView.this.data.get(this.index++);
                }

                @Override
                public void remove() {
                    CollectionView.this.remove(CollectionView.this.data.get(--this.index));
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.data.toArray();
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            return this.data.toArray(a);
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            int i = this.data.indexOf(o);
            if (i == -1) {
                return false;
            }
            this.data.remove(i);
            OrderedMap.this.internalMap.remove(i);
            return true;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.data.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean changed = false;
            for (Object obj : c) {
                if (!this.remove(obj)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean changed = false;
            for (T entry : this.data) {
                if (c.contains(entry)) continue;
                this.remove(entry);
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            this.data.clear();
            OrderedMap.this.internalMap.clear();
        }
    }
}

