/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;

public class SaveQueue {
    private final String name;
    private final Consumer<Object> onSave;
    private volatile boolean saving;
    private volatile boolean queuedSave;
    private volatile Thread saveThread;
    private final Queue<Optional<Object>> infos;
    private final Queue<Optional<Runnable>> onFinished;
    private final boolean waitToCallFinish;

    public <T> SaveQueue(String name, Consumer<T> onSave, boolean waitToCallFinish) {
        this.name = name;
        this.onSave = info -> onSave.accept(info);
        this.infos = new ConcurrentLinkedQueue<Optional<Object>>();
        this.onFinished = new ConcurrentLinkedQueue<Optional<Runnable>>();
        this.waitToCallFinish = waitToCallFinish;
    }

    public SaveQueue(String name, Runnable onSave, boolean waitToCallFinish) {
        this(name, (T info) -> onSave.run(), waitToCallFinish);
    }

    public void save(Runnable onFinished, Object info) {
        this.infos.add(Optional.ofNullable(info));
        this.onFinished.add(Optional.ofNullable(onFinished));
        if (this.saving) {
            this.queuedSave = true;
            this.saveThread.interrupt();
        } else {
            this.saving = true;
            this.saveThread = new Thread(() -> {
                try {
                    this.onSave.accept(this.infos.remove().orElse(null));
                }
                catch (RuntimeException e) {
                    NBTEditor.LOGGER.error("Error while calling save queue", (Throwable)e);
                }
                SaveQueue saveQueue = this;
                synchronized (saveQueue) {
                    int maxSize;
                    int n = maxSize = this.queuedSave ? 1 : 0;
                    if (!this.queuedSave || !this.waitToCallFinish) {
                        while (this.onFinished.size() > maxSize) {
                            this.onFinished.remove().ifPresent(Runnable::run);
                        }
                    }
                    while (this.infos.size() > maxSize) {
                        this.infos.remove();
                    }
                    if (this.queuedSave) {
                        this.queuedSave = false;
                        this.saveThread.run();
                    }
                    this.saving = false;
                }
            }, "SaveQueue:" + this.name);
            this.saveThread.start();
        }
    }

    public void save(Runnable onFinished) {
        this.save(onFinished, null);
    }

    public void save(Object info) {
        this.save(null, info);
    }

    public void save() {
        this.save(null, null);
    }
}

