/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.commands.arguments.FancyTextArgumentType;
import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.FancyConfirmScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;
import net.minecraft.class_5251;
import net.minecraft.class_5348;

public class TextUtil {
    public static EditableText getLongTranslatableText(String key) {
        EditableText line;
        String str;
        EditableText output = TextInst.translatable(key + "_1", new Object[0]);
        for (int i = 2; !(str = (line = TextInst.translatable(key + "_" + i, new Object[0])).getString()).equals(key + "_" + i) && i <= 50; ++i) {
            if (str.startsWith("[LINK] ")) {
                String url = str.substring("[LINK] ".length());
                line = TextInst.literal(url).styled(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, url)).method_30938(Boolean.valueOf(true)).method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1065));
            }
            if (str.startsWith("[FORMAT] ")) {
                String toFormat = str.substring("[FORMAT] ".length());
                line = TextUtil.parseFormattedText(toFormat);
            }
            output.append("\n").append(line);
        }
        return output;
    }

    public static class_2561 parseFormattedText(String text) {
        try {
            return FancyTextArgumentType.fancyText(false).parse(new StringReader(text));
        }
        catch (CommandSyntaxException e) {
            return TextInst.literal(text);
        }
    }

    public static class_2561 parseTranslatableFormatted(String key) {
        return TextUtil.parseFormattedText(TextInst.translatable(key, new Object[0]).getString());
    }

    public static class_2561 substring(class_2561 text, final int start, final int end) {
        final EditableText output = TextInst.literal("");
        text.method_27658((class_5348.class_5246)new class_5348.class_5246<Boolean>(){
            private int i;

            public Optional<Boolean> accept(class_2583 style, String str) {
                if (this.i + str.length() <= start) {
                    this.i += str.length();
                    return Optional.empty();
                }
                if (this.i >= start) {
                    if (end >= 0 && this.i + str.length() > end) {
                        return this.accept(style, str.substring(0, end - this.i));
                    }
                    output.append(TextInst.literal(str).fillStyle(style));
                    this.i += str.length();
                    if (end >= 0 && this.i == end) {
                        return Optional.of(true);
                    }
                    return Optional.empty();
                }
                str = str.substring(start - this.i);
                this.i = start;
                this.accept(style, str);
                return Optional.empty();
            }
        }, class_2583.field_24360);
        return output;
    }

    public static class_2561 substring(class_2561 text, int start) {
        return TextUtil.substring(text, start, -1);
    }

    public static class_2561 deleteCharAt(class_2561 text, int index) {
        EditableText output = TextInst.literal("");
        AtomicInteger pos = new AtomicInteger(0);
        text.method_27658((style, str) -> {
            int strLen = str.length();
            if (pos.getPlain() <= index && index < pos.getPlain() + strLen) {
                str = new StringBuilder(str).deleteCharAt(index - pos.getPlain()).toString();
            }
            if (!str.isEmpty()) {
                output.append(TextInst.literal(str).setStyle(style));
            }
            pos.setPlain(pos.getPlain() + strLen);
            return Optional.empty();
        }, class_2583.field_24360);
        return output;
    }

    public static class_2561 joinLines(List<class_2561> lines) {
        EditableText output = TextInst.literal("");
        for (int i = 0; i < lines.size(); ++i) {
            if (i > 0) {
                output.append("\n");
            }
            output.append(lines.get(i));
        }
        return output;
    }

    public static List<class_2561> splitText(class_2561 text) {
        int i;
        ArrayList<class_2561> output = new ArrayList<class_2561>();
        while ((i = text.getString().indexOf(10)) != -1) {
            output.add(TextUtil.substring(text, 0, i));
            text = TextUtil.substring(text, i + 1);
        }
        output.add(text);
        return output;
    }

    public static class_2561 stripInvalidChars(class_2561 text, boolean allowLineBreaks) {
        EditableText output = TextInst.literal("");
        text.method_27658((style, str) -> {
            output.append(TextInst.literal(MVMisc.stripInvalidChars(str, allowLineBreaks)).setStyle(style));
            return Optional.empty();
        }, class_2583.field_24360);
        return output;
    }

    public static class_2561 attachFileTextOptions(EditableText link, File file) {
        return link.append(" ").append(TextInst.translatable("nbteditor.file_options.show", new Object[0]).styled(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, file.getAbsoluteFile().getParentFile().getAbsolutePath())))).append(" ").append(TextInst.translatable("nbteditor.file_options.delete", new Object[0]).styled(style -> MixinLink.withRunClickEvent(style, () -> MainUtil.client.method_1507((class_437)new FancyConfirmScreen(confirmed -> {
            if (confirmed) {
                if (file.exists()) {
                    try {
                        Files.deleteIfExists(file.toPath());
                        MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.file_options.delete.success", "\u00a76" + file.getName()), false);
                    }
                    catch (IOException e) {
                        NBTEditor.LOGGER.error("Error deleting file", (Throwable)e);
                        MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.file_options.delete.error", "\u00a76" + file.getName()), false);
                    }
                } else {
                    MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.file_options.delete.missing", "\u00a76" + file.getName()), false);
                }
            }
            MainUtil.client.method_1507(null);
        }, TextInst.translatable("nbteditor.file_options.delete.title", file.getName()), TextInst.translatable("nbteditor.file_options.delete.desc", file.getName()))))));
    }

    public static boolean isTextFormatted(class_2561 text, boolean allowNonNull) {
        return TextUtil.isTextFormatted(class_2561.class_2562.method_10868((class_2561)text).getAsJsonObject(), allowNonNull);
    }

    private static boolean isTextFormatted(JsonObject data, boolean allowNonNull) {
        if (data.has("extra")) {
            for (JsonElement part : data.get("extra").getAsJsonArray()) {
                if (!TextUtil.isTextFormatted(part.getAsJsonObject(), allowNonNull)) continue;
                return true;
            }
        }
        if (!allowNonNull) {
            return data.keySet().stream().anyMatch(key -> !key.equals("text") && !key.equals("extra"));
        }
        if (data.has("bold") && data.get("bold").getAsBoolean()) {
            return true;
        }
        if (data.has("italic") && data.get("italic").getAsBoolean()) {
            return true;
        }
        if (data.has("underlined") && data.get("underlined").getAsBoolean()) {
            return true;
        }
        if (data.has("strikethrough") && data.get("strikethrough").getAsBoolean()) {
            return true;
        }
        if (data.has("obfuscated") && data.get("obfuscated").getAsBoolean()) {
            return true;
        }
        if (data.has("color") && !data.get("color").getAsString().equals("white")) {
            return true;
        }
        if (data.has("insertion") && data.get("insertion").getAsBoolean()) {
            return true;
        }
        if (data.has("clickEvent")) {
            return true;
        }
        if (data.has("hoverEvent")) {
            return true;
        }
        return data.has("font") && !data.get("font").getAsString().equals(class_2583.field_24359.toString());
    }

    public static boolean styleEqualsExact(class_2583 a, class_2583 b) {
        return Objects.equals(a.method_10973(), b.method_10973()) && a.field_11856 == b.field_11856 && a.field_11852 == b.field_11852 && a.field_11851 == b.field_11851 && a.field_11857 == b.field_11857 && a.field_11861 == b.field_11861 && Objects.equals(a.method_10970(), b.method_10970()) && Objects.equals(a.method_10969(), b.method_10969()) && Objects.equals(a.method_10955(), b.method_10955()) && Objects.equals(a.method_27708(), b.method_27708());
    }

    public static boolean hasFormatting(class_2583 style, class_124 formatting) {
        return TextUtil.styleEqualsExact(style, style.method_27706(formatting));
    }

    public static class_2583 removeFormatting(class_2583 style, class_124 formatting, boolean force) {
        if (formatting == class_124.field_1070) {
            return style;
        }
        if (formatting.method_543()) {
            return style.method_10977((class_124)(force ? class_124.field_1068 : null));
        }
        Boolean newValue = force ? Boolean.valueOf(false) : null;
        return switch (formatting) {
            case class_124.field_1067 -> style.method_10982(newValue);
            case class_124.field_1056 -> style.method_10978(newValue);
            case class_124.field_1073 -> style.method_30938(newValue);
            case class_124.field_1055 -> style.method_36140(newValue);
            case class_124.field_1051 -> style.method_36141(newValue);
            default -> throw new IllegalArgumentException("Unknown formatting: " + formatting);
        };
    }

    public static class_2583 forceReset(class_2583 base) {
        return class_2583.field_24360.method_10977(base.method_10973() == null || base.method_10973().equals((Object)class_5251.method_27718((class_124)class_124.field_1068)) ? null : class_124.field_1068).method_10982(base.field_11856 == null || base.field_11856 == false ? null : Boolean.valueOf(false)).method_10978(base.field_11852 == null || base.field_11852 == false ? null : Boolean.valueOf(false)).method_30938(base.field_11851 == null || base.field_11851 == false ? null : Boolean.valueOf(false)).method_36140(base.field_11857 == null || base.field_11857 == false ? null : Boolean.valueOf(false)).method_36141(base.field_11861 == null || base.field_11861 == false ? null : Boolean.valueOf(false));
    }

    public static int lastIndexOf(class_2561 text, int ch) {
        AtomicInteger output = new AtomicInteger(-1);
        AtomicInteger pos = new AtomicInteger(0);
        text.method_27657(str -> {
            int i = str.lastIndexOf(ch);
            if (i != -1) {
                output.setPlain(pos.getPlain() + i);
            }
            pos.setPlain(pos.getPlain() + str.length());
            return Optional.empty();
        });
        return output.getPlain();
    }
}

