/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.ported;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_640;
import tsp.headdb.ported.Category;
import tsp.headdb.ported.Head;
import tsp.headdb.ported.HeadDatabase;
import tsp.headdb.ported.LocalHead;
import tsp.headdb.ported.Utils;
import tsp.headdb.ported.inventory.InventoryUtils;

public final class HeadAPI {
    private static final HeadDatabase database = new HeadDatabase();
    private static final File FAVORITES_FILE = new File(NBTEditorClient.SETTINGS_FOLDER, "headdb_favorites.txt");
    private static final List<String> FAVORITES = new ArrayList<String>();

    private HeadAPI() {
    }

    public static HeadDatabase getDatabase() {
        return database;
    }

    public static void openDatabase() {
        InventoryUtils.openDatabase();
    }

    public static void openCategoryDatabase(Category category) {
        InventoryUtils.openCategoryDatabase(category);
    }

    public static void openSearchDatabase(String search) {
        InventoryUtils.openSearchDatabase(search);
    }

    public static void openTagSearchDatabase(String tag) {
        InventoryUtils.openTagSearchDatabase(tag);
    }

    public static boolean checkUpdated() {
        if (HeadAPI.getDatabase().isLastUpdateOld()) {
            MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.hdb.unloaded_database", new Object[0]), false);
            return false;
        }
        return true;
    }

    public static Head getHeadByID(int id) {
        return database.getHeadByID(id);
    }

    public static Head getHeadByUniqueId(UUID uuid) {
        return database.getHeadByUniqueId(uuid);
    }

    public static List<Head> getHeadsByTag(String tag) {
        return database.getHeadsByTag(tag);
    }

    public static List<Head> getHeadsByName(String name) {
        return database.getHeadsByName(name);
    }

    public static List<Head> getHeadsByName(Category category, String name) {
        return database.getHeadsByName(category, name);
    }

    public static Head getHeadByValue(String value) {
        return database.getHeadByValue(value);
    }

    public static List<Head> getHeads(Category category) {
        return database.getHeads(category);
    }

    public static List<Head> getHeads() {
        return database.getHeads();
    }

    public static List<Category> getCategories() {
        return database.getCategories();
    }

    public static void addFavoriteHead(String texture) {
        if (FAVORITES.contains(texture)) {
            return;
        }
        FAVORITES.add(texture);
        HeadAPI.saveFavorites();
    }

    public static void removeFavoriteHead(String texture) {
        if (FAVORITES.remove(texture)) {
            HeadAPI.saveFavorites();
        }
    }

    public static void toggleFavoriteHead(Head head) {
        if (FAVORITES.contains(head.getValue())) {
            HeadAPI.removeFavoriteHead(head.getValue());
            Utils.sendMessage("Removed &e" + head.getName() + " &7from favorites.");
        } else {
            HeadAPI.addFavoriteHead(head.getValue());
            Utils.sendMessage("Added &e" + head.getName() + " &7to favorites.");
        }
    }

    public static void loadFavorites() throws IOException {
        FAVORITES.clear();
        if (!FAVORITES_FILE.exists()) {
            return;
        }
        String heads = new String(Files.readAllBytes(FAVORITES_FILE.toPath())).replace("\r", "");
        if (heads.startsWith("v2\n")) {
            JsonArray headsArray = (JsonArray)new Gson().fromJson(heads.substring("v2\n".length()), JsonArray.class);
            for (JsonElement head : headsArray) {
                FAVORITES.add(head.getAsString());
            }
        } else {
            for (String line : heads.split("\n")) {
                if (line.isEmpty()) continue;
                try {
                    FAVORITES.add("LEGACY: " + Integer.parseInt(line));
                }
                catch (NumberFormatException e) {
                    NBTEditor.LOGGER.error("Invalid legacy favorite", (Throwable)e);
                }
            }
        }
    }

    public static void resolveFavorites() {
        List<String> legacyFavorites = FAVORITES.stream().filter(entry -> entry.startsWith("LEGACY: ")).toList();
        for (String legacyFavorite : legacyFavorites) {
            FAVORITES.remove(legacyFavorite);
            Head head = HeadAPI.getHeadByID(Integer.parseInt(legacyFavorite.substring("LEGACY: ".length())));
            FAVORITES.add(head.getValue());
        }
        HeadAPI.saveFavorites();
    }

    private static void saveFavorites() {
        JsonArray output = new JsonArray();
        for (String favorite : FAVORITES) {
            output.add(favorite);
        }
        try {
            Files.write(FAVORITES_FILE.toPath(), ("v2\n" + output.toString()).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            NBTEditor.LOGGER.error("Error while saving HeadDB favorites", (Throwable)e);
        }
    }

    public static List<Head> getFavoriteHeads() {
        ArrayList<Head> heads = new ArrayList<Head>();
        for (String favorite : FAVORITES) {
            if (favorite.startsWith("LEGACY: ")) continue;
            heads.add(HeadAPI.getHeadByValue(favorite));
        }
        return heads;
    }

    public static List<LocalHead> getLocalHeads() {
        ArrayList<LocalHead> heads = new ArrayList<LocalHead>();
        for (class_640 player : MainUtil.client.method_1562().method_2880()) {
            heads.add(new LocalHead(player.method_2966().getId()).withName(player.method_2966().getName()));
        }
        return heads;
    }

    public static void updateDatabase() {
        database.update();
    }
}

