/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.ported.inventory;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientHandledScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.StringInputScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.Lore;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_437;
import tsp.headdb.ported.HeadAPI;
import tsp.headdb.ported.Utils;
import tsp.headdb.ported.inventory.Button;
import tsp.headdb.ported.inventory.ClickTypeMod;
import tsp.headdb.ported.inventory.InventoryClickEvent;
import tsp.headdb.ported.inventory.InventoryUtils;

public class PagedPane
extends ClientHandledScreen {
    private SortedMap<Integer, Page> pages = new TreeMap<Integer, Page>();
    private int currentIndex;
    private int pageSize;
    protected Button controlBack;
    protected Button controlNext;
    protected Button controlMain;
    private boolean shiftKey;

    public PagedPane(int pageSize, int rows, String title) {
        super(PagedPane.createGenericScreenHandler(rows), MainUtil.client.field_1724.method_31548(), TextInst.of(MainUtil.colorize(title)));
        this.pageSize = pageSize;
        this.pages.put(0, new Page(pageSize));
    }

    public void addButton(Button button) {
        for (Map.Entry<Integer, Page> entry : this.pages.entrySet()) {
            if (!entry.getValue().addButton(button)) continue;
            if (entry.getKey() == this.currentIndex) {
                this.reRender();
            }
            return;
        }
        Page page = new Page(this.pageSize);
        page.addButton(button);
        this.pages.put(this.pages.lastKey() + 1, page);
        this.reRender();
    }

    public void removeButton(Button button) {
        Iterator<Map.Entry<Integer, Page>> iterator = this.pages.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Page> entry = iterator.next();
            if (!entry.getValue().removeButton(button)) continue;
            if (entry.getValue().isEmpty()) {
                if (this.pages.size() > 1) {
                    iterator.remove();
                }
                if (this.currentIndex >= this.pages.size()) {
                    --this.currentIndex;
                }
            }
            if (entry.getKey() >= this.currentIndex) {
                this.reRender();
            }
            return;
        }
    }

    public int getPageAmount() {
        return this.pages.size();
    }

    public int getCurrentPage() {
        return this.currentIndex + 1;
    }

    public void selectPage(int index) {
        if (index < 0 || index >= this.getPageAmount()) {
            throw new IllegalArgumentException("Index out of bounds s: " + index + " [0 " + this.getPageAmount() + ")");
        }
        if (index == this.currentIndex) {
            return;
        }
        this.currentIndex = index;
        this.reRender();
    }

    public void reRender() {
        ((class_1707)this.field_2797).method_7629().method_5448();
        ((Page)this.pages.get(this.currentIndex)).render(((class_1707)this.field_2797).method_7629());
        this.controlBack = null;
        this.controlNext = null;
        this.controlMain = null;
        this.createControls(((class_1707)this.field_2797).method_7629());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344) {
            this.shiftKey = true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344) {
            this.shiftKey = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (slot == null) {
            return;
        }
        slotId = slot.field_7874;
        InventoryClickEvent event = new InventoryClickEvent(slot, slotId, button, actionType, ClickTypeMod.get(button == 1, this.shiftKey));
        if (event.getSlotId() == this.getInventory().method_5439() - 8) {
            if (this.controlBack != null) {
                this.controlBack.onClick(event);
            }
            return;
        }
        if (event.getSlotId() == this.getInventory().method_5439() - 2) {
            if (this.controlNext != null) {
                this.controlNext.onClick(event);
            }
            return;
        }
        if (event.getSlotId() == this.getInventory().method_5439() - 5) {
            if (this.controlMain != null) {
                this.controlMain.onClick(event);
            }
            return;
        }
        ((Page)this.pages.get(this.currentIndex)).handleClick(event);
    }

    public class_1263 getInventory() {
        return ((class_1707)this.field_2797).method_7629();
    }

    protected void createControls(class_1263 inventory) {
        class_1799 itemStack;
        String lore;
        String name;
        this.fillRow(inventory.method_5439() / 9 - 2, new class_1799((class_1935)class_1802.field_8157), inventory);
        if (this.getCurrentPage() > 1) {
            name = String.format(Locale.ROOT, "&3&lPage &a&l%d &7/ &c&l%d", this.getCurrentPage() - 1, this.getPageAmount());
            lore = String.format(Locale.ROOT, "&7Previous: &c%d", this.getCurrentPage() - 1);
            itemStack = this.setMeta(HeadAPI.getHeadByValue("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODY1MmUyYjkzNmNhODAyNmJkMjg2NTFkN2M5ZjI4MTlkMmU5MjM2OTc3MzRkMThkZmRiMTM1NTBmOGZkYWQ1ZiJ9fX0=").getItemStack(), name, lore);
            this.controlBack = new Button(itemStack, event -> this.selectPage(this.currentIndex - 1));
            inventory.method_5447(inventory.method_5439() - 8, itemStack);
        }
        if (this.getCurrentPage() < this.getPageAmount()) {
            name = String.format(Locale.ROOT, "&3&lPage &a&l%d &7/ &c&l%d", this.getCurrentPage() + 1, this.getPageAmount());
            lore = String.format(Locale.ROOT, "&7Next: &c%d", this.getCurrentPage() + 1);
            itemStack = this.setMeta(HeadAPI.getHeadByValue("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMmEzYjhmNjgxZGFhZDhiZjQzNmNhZThkYTNmZTgxMzFmNjJhMTYyYWI4MWFmNjM5YzNlMDY0NGFhNmFiYWMyZiJ9fX0=").getItemStack(), name, lore);
            this.controlNext = new Button(itemStack, event -> this.selectPage(this.getCurrentPage()));
            inventory.method_5447(inventory.method_5439() - 2, itemStack);
        }
        name = String.format(Locale.ROOT, "&3&lPage &a&l%d &7/ &c&l%d", this.getCurrentPage(), this.getPageAmount());
        class_1799 itemStack2 = this.setMeta(HeadAPI.getHeadByValue("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2Q5MWY1MTI2NmVkZGM2MjA3ZjEyYWU4ZDdhNDljNWRiMDQxNWFkYTA0ZGFiOTJiYjc2ODZhZmRiMTdmNGQ0ZSJ9fX0=").getItemStack(), name, "&7Left-Click to go to the &cMain Menu", "&7Right-Click to go to a &6Specific Page");
        this.controlMain = new Button(itemStack2, event -> {
            if (event.getClickType() == ClickTypeMod.RIGHT) {
                new StringInputScreen((class_437)this, text -> {
                    int i = Integer.parseInt(text);
                    this.selectPage(i - 1);
                }, text -> {
                    try {
                        return Integer.parseInt(text) <= this.getPageAmount();
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }).show("Page number...");
            } else {
                InventoryUtils.openDatabase();
            }
        });
        inventory.method_5447(inventory.method_5439() - 5, itemStack2);
    }

    private void fillRow(int rowIndex, class_1799 itemStack, class_1263 inventory) {
        int yMod = rowIndex * 9;
        for (int i = 0; i < 9; ++i) {
            int slot = yMod + i;
            inventory.method_5447(slot, this.setMeta(itemStack, "", new String[0]));
        }
    }

    protected class_1799 setMeta(class_1799 itemStack, String name, String ... lore) {
        itemStack.method_7977(TextInst.of(Utils.colorize(name)));
        Lore loreObj = new Lore(itemStack);
        loreObj.setAllLines(Arrays.stream(lore).map(MainUtil::colorize).map(TextInst::of).collect(Collectors.toList()));
        return itemStack;
    }

    public void open() {
        this.reRender();
        MainUtil.client.method_1507((class_437)this);
    }

    private static class Page {
        private List<Button> buttons = new ArrayList<Button>();
        private int maxSize;

        Page(int maxSize) {
            this.maxSize = maxSize;
        }

        void handleClick(InventoryClickEvent event) {
            if (event.getSlotId() > event.getSlot().field_7871.method_5439()) {
                return;
            }
            if (event.getSlotId() >= this.buttons.size()) {
                return;
            }
            Button button = this.buttons.get(event.getSlotId());
            button.onClick(event);
        }

        boolean hasSpace() {
            return this.buttons.size() < this.maxSize * 9;
        }

        boolean addButton(Button button) {
            if (!this.hasSpace()) {
                return false;
            }
            this.buttons.add(button);
            return true;
        }

        boolean removeButton(Button button) {
            return this.buttons.remove(button);
        }

        void render(class_1263 inventory) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                Button button = this.buttons.get(i);
                inventory.method_5447(i, button.getItemStack());
            }
        }

        boolean isEmpty() {
            return this.buttons.isEmpty();
        }
    }
}

