/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.api.server.chat;

import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.chat.MinecraftTranslatableText;
import su.plo.lib.api.chat.TranslatableTextConverter;
import su.plo.lib.api.server.command.MinecraftCommandSource;
import su.plo.voice.api.server.config.ServerLanguages;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lsu/plo/lib/api/server/chat/ServerTextConverter;", "T", "Lsu/plo/lib/api/chat/TranslatableTextConverter;", "languagesSupplier", "Ljava/util/function/Supplier;", "Lsu/plo/voice/api/server/config/ServerLanguages;", "(Ljava/util/function/Supplier;)V", "convert", "source", "Lsu/plo/lib/api/server/command/MinecraftCommandSource;", "text", "Lsu/plo/lib/api/chat/MinecraftTextComponent;", "(Lsu/plo/lib/api/server/command/MinecraftCommandSource;Lsu/plo/lib/api/chat/MinecraftTextComponent;)Ljava/lang/Object;", "convertToJson", "", "server-common"})
public abstract class ServerTextConverter<T>
extends TranslatableTextConverter<T> {
    @NotNull
    private final Supplier<ServerLanguages> languagesSupplier;

    public ServerTextConverter(@NotNull Supplier<ServerLanguages> languagesSupplier) {
        Intrinsics.checkNotNullParameter(languagesSupplier, "languagesSupplier");
        this.languagesSupplier = languagesSupplier;
    }

    @NotNull
    public final String convertToJson(@NotNull MinecraftCommandSource source, @NotNull MinecraftTextComponent text) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(text, "text");
        ServerLanguages serverLanguages = this.languagesSupplier.get();
        if (serverLanguages == null) {
            String string = this.convertToJson(text);
            Intrinsics.checkNotNullExpressionValue(string, "convertToJson(text)");
            return string;
        }
        ServerLanguages languages = serverLanguages;
        Map<String, String> language = languages.getServerLanguage(source);
        Intrinsics.checkNotNullExpressionValue(language, "language");
        MinecraftTextComponent convertedText = this.translateInner(language, text);
        if (!(convertedText instanceof MinecraftTranslatableText)) {
            String string = this.convertToJson(text);
            Intrinsics.checkNotNullExpressionValue(string, "convertToJson(text)");
            return string;
        }
        if (!language.containsKey(((MinecraftTranslatableText)convertedText).getKey())) {
            String string = this.convertToJson(text);
            Intrinsics.checkNotNullExpressionValue(string, "convertToJson(text)");
            return string;
        }
        String string = this.convertToJson(this.translate(language, (MinecraftTranslatableText)convertedText));
        Intrinsics.checkNotNullExpressionValue(string, "convertToJson(translate(\u2026 convertedText\n        ))");
        return string;
    }

    public final T convert(@NotNull MinecraftCommandSource source, @NotNull MinecraftTextComponent text) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(text, "text");
        ServerLanguages serverLanguages = this.languagesSupplier.get();
        if (serverLanguages == null) {
            return this.convert(text);
        }
        ServerLanguages languages = serverLanguages;
        Map<String, String> language = languages.getServerLanguage(source);
        Intrinsics.checkNotNullExpressionValue(language, "language");
        MinecraftTextComponent convertedText = this.translateInner(language, text);
        if (!(convertedText instanceof MinecraftTranslatableText)) {
            return this.convert(text);
        }
        if (!language.containsKey(((MinecraftTranslatableText)convertedText).getKey())) {
            return this.convert(text);
        }
        return this.convert(this.translate(language, (MinecraftTranslatableText)convertedText));
    }
}

