/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.api.server.world;

import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.server.world.MinecraftServerWorld;
import su.plo.voice.proto.data.pos.Pos3d;

public class ServerPos3d {
    private MinecraftServerWorld world;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;

    public ServerPos3d(@NotNull MinecraftServerWorld world, double x, double y, double z) {
        this(world, x, y, z, 0.0f, 0.0f);
    }

    public ServerPos3d(@NotNull MinecraftServerWorld world, double x, double y, double z, float yaw, float pitch) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public double distanceSquared(@NotNull ServerPos3d o) {
        Preconditions.checkNotNull((Object)o.getWorld(), (Object)"Cannot measure distance to a null world");
        Preconditions.checkNotNull((Object)this.getWorld(), (Object)"Cannot measure distance to a null world");
        if (!o.getWorld().equals(this.world)) {
            throw new IllegalArgumentException("Cannot measure distance between worlds");
        }
        double xDiff = this.x - o.x;
        double yDiff = this.y - o.y;
        double zDiff = this.z - o.z;
        return xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
    }

    public Pos3d toPosition() {
        return new Pos3d(this.x, this.y, this.z);
    }

    public Pos3d getLookAngle() {
        Pos3d pos = new Pos3d();
        double rotX = this.getYaw();
        double rotY = this.getPitch();
        pos.setY(-Math.sin(Math.toRadians(rotY)));
        double xz = Math.cos(Math.toRadians(rotY));
        pos.setX(-xz * Math.sin(Math.toRadians(rotX)));
        pos.setZ(xz * Math.cos(Math.toRadians(rotX)));
        return pos;
    }

    public ServerPos3d() {
    }

    public MinecraftServerWorld getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setWorld(MinecraftServerWorld world) {
        this.world = world;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerPos3d)) {
            return false;
        }
        ServerPos3d other = (ServerPos3d)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        MinecraftServerWorld this$world = this.getWorld();
        MinecraftServerWorld other$world = other.getWorld();
        return !(this$world == null ? other$world != null : !this$world.equals(other$world));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerPos3d;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result2 = result2 * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result2 = result2 * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result2 = result2 * 59 + (int)($z >>> 32 ^ $z);
        result2 = result2 * 59 + Float.floatToIntBits(this.getYaw());
        result2 = result2 * 59 + Float.floatToIntBits(this.getPitch());
        MinecraftServerWorld $world = this.getWorld();
        result2 = result2 * 59 + ($world == null ? 43 : $world.hashCode());
        return result2;
    }

    public String toString() {
        return "ServerPos3d(world=" + this.getWorld() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }
}

