/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.components;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.MathLib;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UKeyboard;
import su.plo.voice.universal.UMatrixStack;

public abstract class AbstractSlider
extends GuiAbstractWidget {
    protected double value;
    protected boolean dragging;

    public AbstractSlider(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    protected int getYImage(boolean hovered) {
        return 0;
    }

    @Override
    public void renderButton(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        this.renderBackground(stack, mouseX, mouseY);
        this.renderTrack(stack, mouseX, mouseY);
        this.renderText(stack, mouseX, mouseY);
    }

    @Override
    protected void renderBackground(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        int width = this.getSliderWidth();
        UGraphics.bindTexture(0, WIDGETS_LOCATION);
        UGraphics.color4f(1.0f, 1.0f, 1.0f, this.alpha);
        UGraphics.enableBlend();
        RenderUtil.defaultBlendFunc();
        UGraphics.enableDepth();
        int textureV = this.getYImage(this.hovered);
        RenderUtil.blit(stack, this.x, this.y, 0, 46 + textureV * 20, width / 2, this.height);
        RenderUtil.blit(stack, this.x + width / 2, this.y, 200 - width / 2, 46 + textureV * 20, width / 2, this.height);
        UGraphics.color4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    protected boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.getSliderWidth() - 1) && mouseY < (double)(this.y + this.height);
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        if (this.isHovered(mouseX, mouseY)) {
            this.dragging = true;
            this.setValueFromMouse(mouseX);
        }
    }

    @Override
    public boolean keyPressed(int keyCode, @Nullable UKeyboard.Modifiers modifiers) {
        boolean rightPressed;
        boolean bl = rightPressed = keyCode == 263;
        if (rightPressed || keyCode == 262) {
            float delta = rightPressed ? -1.0f : 1.0f;
            this.setValue(this.value + (double)(delta / (float)(this.getSliderWidth() - 8)));
        }
        return false;
    }

    @Override
    public void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isHovered(mouseX, mouseY)) {
            this.setValueFromMouse(mouseX);
            this.dragging = true;
            super.onDrag(mouseX, mouseY, deltaX, deltaY);
        }
    }

    @Override
    public void onRelease(double mouseX, double mouseY) {
        if (this.dragging) {
            this.dragging = false;
            super.playDownSound();
        }
    }

    @Override
    protected void playDownSound() {
    }

    protected void renderTrack(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        UGraphics.bindTexture(0, WIDGETS_LOCATION);
        UGraphics.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        int k = (this.isHoveredOrFocused() ? 2 : 1) * 20;
        RenderUtil.blit(stack, this.x + (int)(this.value * (double)(this.getSliderWidth() - 8)), this.y, 0, 46 + k, 4, 20);
        RenderUtil.blit(stack, this.x + (int)(this.value * (double)(this.getSliderWidth() - 8)) + 4, this.y, 196, 46 + k, 4, 20);
    }

    @Override
    protected void renderText(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        int textColor = this.active ? COLOR_WHITE : COLOR_GRAY;
        RenderUtil.drawCenteredString(stack, this.getText(), this.x + this.getSliderWidth() / 2, this.y + this.height / 2 - UGraphics.getFontHeight() / 2, textColor | (int)Math.ceil(this.alpha * 255.0f) << 24);
    }

    protected int getSliderWidth() {
        return this.width;
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue((mouseX - (double)(this.x + 4)) / (double)(this.getSliderWidth() - 8));
    }

    private void setValue(double value) {
        double oldValue = this.value;
        this.value = MathLib.clamp(value, 0.0, 1.0);
        if (oldValue != this.value) {
            this.applyValue();
        }
        this.updateText();
    }

    protected abstract void updateText();

    protected abstract void applyValue();
}

