/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.widget;

import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.narration.NarrationOutput;
import su.plo.lib.mod.client.gui.widget.GuiNarrationWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetListener;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;
import su.plo.voice.universal.USound;

public abstract class GuiAbstractWidget
implements GuiWidget,
GuiNarrationWidget,
GuiWidgetListener {
    public static int COLOR_WHITE = 0xFFFFFF;
    public static int COLOR_GRAY = 0xA0A0A0;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected MinecraftTextComponent text;
    protected float alpha = 1.0f;
    protected boolean hovered;
    protected boolean active = true;
    protected boolean visible = true;
    private boolean focused;

    public static MinecraftTextComponent wrapDefaultNarrationMessage(MinecraftTextComponent component) {
        return MinecraftTextComponent.translatable("gui.narrate.button", component);
    }

    public GuiAbstractWidget(int x, int y, int width, int height) {
        this(x, y, width, height, MinecraftTextComponent.empty());
    }

    public GuiAbstractWidget(int x, int y, int width, int height, @NotNull MinecraftTextComponent text) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.text = text;
    }

    @Override
    public void render(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        this.hovered = this.isHovered(mouseX, mouseY);
        this.renderButton(stack, mouseX, mouseY, delta);
    }

    @Override
    public GuiNarrationWidget.NarrationPriority narrationPriority() {
        if (this.focused) {
            return GuiNarrationWidget.NarrationPriority.FOCUSED;
        }
        return this.hovered ? GuiNarrationWidget.NarrationPriority.HOVERED : GuiNarrationWidget.NarrationPriority.NONE;
    }

    @Override
    public void updateNarration(@NotNull NarrationOutput narrationOutput) {
        this.defaultButtonNarrationText(narrationOutput);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!(this.active && this.visible && this.isValidClickButton(button))) {
            return false;
        }
        if (this.isClicked(mouseX, mouseY)) {
            this.playDownSound();
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isValidClickButton(button)) {
            this.onDrag(mouseX, mouseY, deltaX, deltaY);
            return true;
        }
        return false;
    }

    @Override
    public boolean changeFocus(boolean lookForwards) {
        if (!this.active || !this.visible) {
            return false;
        }
        this.focused = !lookForwards;
        this.onFocusedChanged(lookForwards);
        return lookForwards;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.active && this.visible && this.isHovered(mouseX, mouseY);
    }

    public void renderButton(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        UGraphics.bindTexture(0, WIDGETS_LOCATION);
        UGraphics.color4f(1.0f, 1.0f, 1.0f, this.alpha);
        UGraphics.enableBlend();
        RenderUtil.defaultBlendFunc();
        UGraphics.enableDepth();
        int textureV = this.getYImage(this.hovered);
        RenderUtil.blit(stack, this.x, this.y, 0, 46 + textureV * 20, this.width / 2, this.height);
        RenderUtil.blit(stack, this.x + this.width / 2, this.y, 200 - this.width / 2, 46 + textureV * 20, this.width / 2, this.height);
        this.renderBackground(stack, mouseX, mouseY);
        this.renderText(stack, mouseX, mouseY);
    }

    public void renderToolTip(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
    }

    public void onClick(double mouseX, double mouseY) {
    }

    public void onRelease(double mouseX, double mouseY) {
    }

    public void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
    }

    public MinecraftTextComponent getText() {
        return this.text;
    }

    public boolean isHoveredOrFocused() {
        return this.hovered || this.focused;
    }

    protected void renderBackground(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
    }

    protected void renderText(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        int textColor = this.active ? COLOR_WHITE : COLOR_GRAY;
        RenderUtil.drawCenteredString(stack, this.getText(), this.x + this.width / 2, this.y + (this.height - 8) / 2, textColor | (int)Math.ceil(this.alpha * 255.0f) << 24);
    }

    protected void playDownSound() {
        USound.INSTANCE.playButtonPress();
    }

    protected void onFocusedChanged(boolean focused) {
    }

    protected void defaultButtonNarrationText(NarrationOutput narrationElementOutput) {
        narrationElementOutput.add(NarrationOutput.Type.TITLE, this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narrationElementOutput.add(NarrationOutput.Type.USAGE, MinecraftTextComponent.translatable("narration.button.usage.focused", new Object[0]));
            } else {
                narrationElementOutput.add(NarrationOutput.Type.USAGE, MinecraftTextComponent.translatable("narration.button.usage.hovered", new Object[0]));
            }
        }
    }

    protected MinecraftTextComponent createNarrationMessage() {
        return GuiAbstractWidget.wrapDefaultNarrationMessage(this.getText());
    }

    protected int getYImage(boolean hovered) {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (hovered) {
            i = 2;
        }
        return i;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    protected boolean isClicked(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY);
    }

    protected boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setText(MinecraftTextComponent text) {
        this.text = text;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }
}

