/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.server.entity;

import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_3222;
import net.minecraft.class_5894;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.server.MinecraftServerLib;
import su.plo.lib.api.server.chat.ServerTextConverter;
import su.plo.lib.api.server.entity.MinecraftServerEntity;
import su.plo.lib.api.server.entity.MinecraftServerPlayerEntity;
import su.plo.lib.api.server.permission.PermissionTristate;
import su.plo.lib.api.server.world.MinecraftServerWorld;
import su.plo.lib.api.server.world.ServerPos3d;
import su.plo.lib.mod.client.texture.ResourceCache;
import su.plo.lib.mod.entity.ModPlayer;
import su.plo.lib.mod.server.utils.ServerPlayerKt;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.server.player.PermissionSupplier;

public final class ModServerPlayer
extends ModPlayer<class_3222>
implements MinecraftServerPlayerEntity {
    private final MinecraftServerLib minecraftServer;
    private final ServerTextConverter<class_2561> textConverter;
    private final PermissionSupplier permissions;
    private final ResourceCache resources;
    private final Set<String> registeredChannels = Sets.newCopyOnWriteArraySet();
    private String language = "en_us";
    private MinecraftServerEntity spectatorTarget;

    public ModServerPlayer(@NotNull MinecraftServerLib minecraftServer, @NotNull ServerTextConverter<class_2561> textConverter, @NotNull PermissionSupplier permissions, @NotNull ResourceCache resources, @NotNull class_3222 player) {
        super(player);
        this.minecraftServer = minecraftServer;
        this.textConverter = textConverter;
        this.permissions = permissions;
        this.resources = resources;
    }

    @Override
    @NotNull
    public ServerPos3d getServerPosition() {
        return new ServerPos3d(this.minecraftServer.getWorld(ServerPlayerKt.serverLevel((class_3222)this.instance)), ((class_3222)this.instance).method_19538().method_10216(), ((class_3222)this.instance).method_19538().method_10214(), ((class_3222)this.instance).method_19538().method_10215(), ((class_3222)this.instance).method_36455(), ((class_3222)this.instance).method_36454());
    }

    @Override
    @NotNull
    public ServerPos3d getServerPosition(@NotNull ServerPos3d position) {
        position.setWorld(this.minecraftServer.getWorld(ServerPlayerKt.serverLevel((class_3222)this.instance)));
        position.setX(((class_3222)this.instance).method_19538().method_10216());
        position.setY(((class_3222)this.instance).method_19538().method_10214());
        position.setZ(((class_3222)this.instance).method_19538().method_10215());
        position.setYaw(((class_3222)this.instance).method_36455());
        position.setPitch(((class_3222)this.instance).method_36454());
        return position;
    }

    @Override
    @NotNull
    public MinecraftServerWorld getWorld() {
        return this.minecraftServer.getWorld(ServerPlayerKt.serverLevel((class_3222)this.instance));
    }

    @Override
    public boolean isOnline() {
        return !((class_3222)this.instance).method_14239();
    }

    @Override
    @NotNull
    public MinecraftGameProfile getGameProfile() {
        return this.minecraftServer.getGameProfile(((class_3222)this.instance).method_5667()).orElseThrow(() -> new IllegalStateException("Game profile not found"));
    }

    @Override
    public void sendPacket(@NotNull String channel, byte[] data) {
        ((class_3222)this.instance).field_13987.method_14364((class_2596)new class_2658(this.resources.getLocation(channel), new class_2540(Unpooled.wrappedBuffer((byte[])data))));
    }

    @Override
    public void kick(@NotNull MinecraftTextComponent reason) {
        ((class_3222)this.instance).field_13987.method_14367(this.textConverter.convert(this, reason));
    }

    @Override
    public void sendMessage(@NotNull MinecraftTextComponent text) {
        ((class_3222)this.instance).method_43496(this.textConverter.convert(this, text));
    }

    @Override
    public void sendActionBar(@NotNull MinecraftTextComponent text) {
        ((class_3222)this.instance).field_13987.method_14364((class_2596)new class_5894(this.textConverter.convert(this, text)));
    }

    @Override
    public boolean canSee(@NotNull MinecraftServerPlayerEntity player) {
        class_3222 serverPlayer = (class_3222)player.getInstance();
        if (serverPlayer.method_7325()) {
            return ((class_3222)this.instance).method_7325();
        }
        return true;
    }

    @Override
    public Collection<String> getRegisteredChannels() {
        return this.registeredChannels;
    }

    @Override
    public Optional<MinecraftServerEntity> getSpectatorTarget() {
        if (((class_3222)this.instance).method_14242() == this.instance) {
            this.spectatorTarget = null;
        } else if (this.spectatorTarget == null || !((class_3222)this.instance).method_14242().equals(this.spectatorTarget.getInstance())) {
            this.spectatorTarget = this.minecraftServer.getEntity(((class_3222)this.instance).method_14242());
        }
        return Optional.ofNullable(this.spectatorTarget);
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        return this.permissions.hasPermission(this.instance, permission);
    }

    @Override
    @NotNull
    public PermissionTristate getPermission(@NotNull String permission) {
        return this.permissions.getPermission(this.instance, permission);
    }

    public void addChannel(@NotNull String channel) {
        this.registeredChannels.add(channel);
    }

    public void removeChannel(@NotNull String channel) {
        this.registeredChannels.remove(channel);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

