/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice;

import com.google.inject.Module;
import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.addon.VoiceAddonManager;
import su.plo.voice.api.PlasmoVoice;
import su.plo.voice.api.addon.AddonManager;
import su.plo.voice.api.audio.codec.CodecManager;
import su.plo.voice.api.encryption.EncryptionManager;
import su.plo.voice.api.event.EventBus;
import su.plo.voice.api.logging.DebugLogger;
import su.plo.voice.client.audio.codec.VoiceCodecManager;
import su.plo.voice.client.audio.codec.opus.OpusCodecSupplier;
import su.plo.voice.encryption.VoiceEncryptionManager;
import su.plo.voice.encryption.aes.AesEncryptionSupplier;
import su.plo.voice.event.VoiceEventBus;
import su.plo.voice.util.version.ModrinthLoader;

public abstract class BaseVoice
implements PlasmoVoice {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"PlasmoVoice");
    public static final DebugLogger DEBUG_LOGGER = new DebugLogger(LOGGER);
    protected final ModrinthLoader loader;
    protected final EventBus eventBus = new VoiceEventBus(this);
    protected final EncryptionManager encryption = new VoiceEncryptionManager();
    protected final CodecManager codecs = new VoiceCodecManager();
    protected final VoiceAddonManager addons;
    protected ScheduledExecutorService backgroundExecutor;

    protected BaseVoice(@NotNull ModrinthLoader loader) {
        this.loader = loader;
        this.addons = new VoiceAddonManager(this);
        this.encryption.register(new AesEncryptionSupplier());
        this.codecs.register(new OpusCodecSupplier());
    }

    protected void onInitialize() {
        this.backgroundExecutor = Executors.newSingleThreadScheduledExecutor();
        this.eventBus.register(this, this);
    }

    protected void onShutdown() {
        this.backgroundExecutor.shutdown();
        this.addons.clear();
    }

    @Override
    @NotNull
    public AddonManager getAddonManager() {
        return this.addons;
    }

    @Override
    @NotNull
    public EncryptionManager getEncryptionManager() {
        return this.encryption;
    }

    @Override
    @NotNull
    public CodecManager getCodecManager() {
        return this.codecs;
    }

    @Override
    @NotNull
    public EventBus getEventBus() {
        return this.eventBus;
    }

    public InputStream getResource(String name) {
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }

    public abstract Module createInjectModule();

    @Override
    public ScheduledExecutorService getBackgroundExecutor() {
        return this.backgroundExecutor;
    }
}

