/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.addon;

import com.google.common.base.Preconditions;
import java.util.Objects;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class AddonDependency {
    private final String id;
    private final boolean optional;
    private final boolean mod;

    public AddonDependency(@NonNull String id, boolean optional, boolean mod) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"id cannot be empty");
        this.optional = optional;
        this.mod = mod;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddonDependency that = (AddonDependency)o;
        return this.optional == that.optional && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.optional);
    }

    public String toString() {
        return "AddonDependency{id='" + this.id + '\'' + ", optional=" + this.optional + '}';
    }

    public String getId() {
        return this.id;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isMod() {
        return this.mod;
    }
}

