/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.client.event.audio.capture;

import lombok.NonNull;
import su.plo.voice.api.client.audio.capture.AudioCapture;
import su.plo.voice.api.client.audio.device.InputDevice;
import su.plo.voice.api.event.Event;

public final class AudioCaptureProcessedEvent
implements Event {
    private final AudioCapture capture;
    private final InputDevice device;
    private final short[] samples;
    private final short[] monoSamplesProcessed;

    public AudioCaptureProcessedEvent(@NonNull AudioCapture capture, @NonNull InputDevice device, short[] samples, short[] monoSamplesProcessed) {
        if (capture == null) {
            throw new NullPointerException("capture is marked non-null but is null");
        }
        if (device == null) {
            throw new NullPointerException("device is marked non-null but is null");
        }
        this.capture = capture;
        this.device = device;
        this.samples = samples;
        this.monoSamplesProcessed = monoSamplesProcessed;
    }

    public short[] getOrProcessSamples() {
        if (this.monoSamplesProcessed != null) {
            return this.monoSamplesProcessed;
        }
        short[] samples = new short[this.samples.length];
        System.arraycopy(this.samples, 0, samples, 0, this.samples.length);
        return this.device.processFilters(samples);
    }

    public AudioCapture getCapture() {
        return this.capture;
    }

    public InputDevice getDevice() {
        return this.device;
    }

    public short[] getSamples() {
        return this.samples;
    }

    public short[] getMonoSamplesProcessed() {
        return this.monoSamplesProcessed;
    }
}

