/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.audio.capture;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.server.permission.PermissionDefault;
import su.plo.lib.api.server.player.MinecraftServerPlayer;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerAudioEndPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;

public interface ServerActivation
extends Activation {
    @NotNull
    public AddonContainer getAddon();

    @NotNull
    public Optional<Requirements> getRequirements();

    @NotNull
    public Collection<String> getPermissions();

    public void addPermission(@NotNull String var1);

    public void removePermission(@NotNull String var1);

    public void clearPermissions();

    default public boolean checkPermissions(@NotNull VoicePlayer player) {
        return this.checkPermissions(player.getInstance());
    }

    public boolean checkPermissions(@NotNull MinecraftServerPlayer var1);

    public void setDistances(List<Integer> var1);

    public boolean checkDistance(int var1);

    public void setTransitive(boolean var1);

    public void setProximity(boolean var1);

    public void onPlayerActivation(@NotNull PlayerActivationListener var1);

    public void onPlayerActivationStart(@NotNull PlayerActivationStartListener var1);

    public void onPlayerActivationEnd(@NotNull PlayerActivationEndListener var1);

    public static interface Builder {
        @NotNull
        public Builder addPermission(@NotNull String var1);

        @NotNull
        public Builder setPermissionDefault(@Nullable PermissionDefault var1);

        @NotNull
        public Builder setRequirements(@Nullable Requirements var1);

        @NotNull
        public Builder setDistances(@NotNull List<Integer> var1);

        @NotNull
        public Builder setDefaultDistance(int var1);

        @NotNull
        public Builder setTransitive(boolean var1);

        @NotNull
        public Builder setProximity(boolean var1);

        @NotNull
        public Builder setStereoSupported(boolean var1);

        @NotNull
        public Builder setEncoderInfo(@Nullable CodecInfo var1);

        @NotNull
        public ServerActivation build();
    }

    public static interface Requirements {
        public boolean checkRequirements(@NotNull VoicePlayer var1, @NotNull PlayerAudioPacket var2);

        public boolean checkRequirements(@NotNull VoicePlayer var1, @NotNull PlayerAudioEndPacket var2);
    }

    public static enum Result {
        IGNORED,
        HANDLED;

    }

    @FunctionalInterface
    public static interface PlayerActivationEndListener {
        @NotNull
        public Result onActivationEnd(@NotNull VoicePlayer var1, @NotNull PlayerAudioEndPacket var2);
    }

    @FunctionalInterface
    public static interface PlayerActivationStartListener {
        public void onActivationStart(@NotNull VoicePlayer var1);
    }

    @FunctionalInterface
    public static interface PlayerActivationListener {
        @NotNull
        public Result onActivation(@NotNull VoicePlayer var1, @NotNull PlayerAudioPacket var2);
    }
}

