/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class CircularBuffer<T> {
    private final List<T> buffer;
    private int index;

    public CircularBuffer(int capacity, T defaultValue) {
        this.buffer = new ArrayList<T>(capacity);
        for (int i = 0; i < capacity; ++i) {
            this.buffer.add(defaultValue);
        }
    }

    public Collection<T> getCollection() {
        return this.buffer;
    }

    public void put(T value) {
        this.buffer.set(this.index, value);
        this.index = (this.index + 1) % this.buffer.size();
    }
}

