/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.audio.device.DeviceFactoryManager;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.audio.device.AlInputDeviceFactory;
import su.plo.voice.client.audio.device.AlOutputDeviceFactory;
import su.plo.voice.client.audio.device.JavaxInputDeviceFactory;
import su.plo.voice.client.connection.ModClientChannelHandler;
import su.plo.voice.client.event.key.KeyPressedEvent;
import su.plo.voice.client.render.ModEntityRenderer;
import su.plo.voice.client.render.ModHudRenderer;
import su.plo.voice.client.render.ModLevelRenderer;
import su.plo.voice.server.ModVoiceServer;
import su.plo.voice.universal.UKeyboard;
import su.plo.voice.universal.UMinecraft;
import su.plo.voice.util.version.ModrinthLoader;

public final class ModVoiceClient
extends BaseVoiceClient
implements ClientModInitializer {
    public static ModVoiceClient INSTANCE;
    private final String modId = "plasmovoice";
    public static final class_304 MENU_KEY;
    private final ModHudRenderer hudRenderer;
    private final ModLevelRenderer levelRenderer;
    private final ModEntityRenderer entityRenderer;
    private final ModClientChannelHandler handler = new ModClientChannelHandler(this);

    public ModVoiceClient() {
        super(ModrinthLoader.FABRIC);
        DeviceFactoryManager factoryManager = this.getDeviceFactoryManager();
        factoryManager.registerDeviceFactory(new AlOutputDeviceFactory(this));
        factoryManager.registerDeviceFactory(new AlInputDeviceFactory(this));
        this.getDeviceFactoryManager().registerDeviceFactory(new JavaxInputDeviceFactory(this));
        this.hudRenderer = new ModHudRenderer(this);
        this.levelRenderer = new ModLevelRenderer(this);
        this.entityRenderer = new ModEntityRenderer(this);
        INSTANCE = this;
        RenderUtil.getTextConverter().setLanguageSupplier(this.createLanguageSupplier());
    }

    @Override
    protected void onServerDisconnect() {
        super.onServerDisconnect();
        this.handler.close();
    }

    @EventSubscribe
    public void onKeyPressed(@NotNull KeyPressedEvent event) {
        if (UMinecraft.getPlayer() == null) {
            return;
        }
        if (MENU_KEY.method_1436()) {
            this.openSettings();
        }
    }

    @Override
    @NotNull
    public File getConfigFolder() {
        return new File("config/plasmovoice");
    }

    @Override
    @NotNull
    public File getConfigsFolder() {
        return new File("config");
    }

    @Override
    public Optional<ServerConnection> getServerConnection() {
        return this.handler.getConnection();
    }

    public void onInitializeClient() {
        super.onInitialize();
        ClientLifecycleEvents.CLIENT_STOPPING.register(minecraft -> this.onShutdown());
        HudRenderCallback.EVENT.register(this.hudRenderer::render);
        WorldRenderEvents.END.register(context -> this.levelRenderer.render(context.world(), context.matrixStack(), context.camera(), context.tickDelta()));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.onServerDisconnect());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModVoiceServer.CHANNEL, (ClientPlayNetworking.PlayChannelHandler)this.handler);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModVoiceServer.FLAG_CHANNEL, (client, handler, buf, responseSender) -> {});
        KeyBindingHelper.registerKeyBinding((class_304)MENU_KEY);
    }

    @Override
    @NotNull
    public String getVersion() {
        ModContainer modContainer = FabricLoader.getInstance().getModContainer("plasmovoice").orElse(null);
        Preconditions.checkNotNull((Object)modContainer, (Object)"modContainer cannot be null");
        return modContainer.getMetadata().getVersion().getFriendlyString();
    }

    public ModHudRenderer getHudRenderer() {
        return this.hudRenderer;
    }

    public ModLevelRenderer getLevelRenderer() {
        return this.levelRenderer;
    }

    public ModEntityRenderer getEntityRenderer() {
        return this.entityRenderer;
    }

    static {
        MENU_KEY = new class_304("key.plasmovoice.settings", class_3675.class_307.field_1668, UKeyboard.KEY_V, "Plasmo Voice");
    }
}

