/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.codec;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.audio.codec.AudioDecoder;
import su.plo.voice.api.audio.codec.AudioEncoder;
import su.plo.voice.api.audio.codec.CodecManager;
import su.plo.voice.api.audio.codec.CodecSupplier;
import su.plo.voice.proto.data.audio.codec.CodecInfo;

public final class VoiceCodecManager
implements CodecManager {
    private final Map<String, CodecSupplier<?, ?>> codecs = Maps.newHashMap();

    @Override
    @NotNull
    public synchronized <T extends AudioEncoder> T createEncoder(@NotNull CodecInfo codecInfo, int sampleRate, boolean stereo, int bufferSize, int mtuSize) {
        CodecSupplier<?, ?> supplier = this.codecs.get(codecInfo.getName());
        if (supplier == null) {
            throw new IllegalArgumentException("Codec encoder with name " + codecInfo.getName() + " is not registered");
        }
        return (T)supplier.createEncoder(sampleRate, stereo, bufferSize, mtuSize, codecInfo);
    }

    @Override
    @NotNull
    public synchronized <T extends AudioDecoder> T createDecoder(@NotNull CodecInfo codecInfo, int sampleRate, boolean stereo, int bufferSize, int mtuSize) {
        CodecSupplier<?, ?> supplier = this.codecs.get(codecInfo.getName());
        if (supplier == null) {
            throw new IllegalArgumentException("Codec encoder with name " + codecInfo.getName() + " is not registered");
        }
        return (T)supplier.createDecoder(sampleRate, stereo, bufferSize, mtuSize, codecInfo);
    }

    @Override
    public synchronized void register(@NotNull CodecSupplier<?, ?> supplier) {
        String name = supplier.getName();
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull(supplier, (Object)"supplier cannot be null");
        if (this.codecs.containsKey(name)) {
            throw new IllegalArgumentException("Codec with name " + name + " is already exist");
        }
        this.codecs.put(name, supplier);
    }

    @Override
    public synchronized boolean unregister(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        return this.codecs.remove(name) != null;
    }

    @Override
    public synchronized boolean unregister(@NotNull CodecSupplier<?, ?> supplier) {
        Preconditions.checkNotNull(supplier, (Object)"supplier cannot be null");
        Preconditions.checkNotNull((Object)supplier.getName(), (Object)"name cannot be null");
        return this.codecs.remove(supplier.getName()) != null;
    }

    @Override
    public synchronized Collection<CodecSupplier<?, ?>> getCodecs() {
        return this.codecs.values();
    }
}

