/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALUtil;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AudioDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.DeviceFactory;
import su.plo.voice.client.audio.device.AlInputDevice;

public final class AlInputDeviceFactory
implements DeviceFactory {
    private final PlasmoVoiceClient client;

    public AlInputDeviceFactory(PlasmoVoiceClient client) {
        this.client = client;
    }

    @Override
    public AudioDevice openDevice(@NotNull AudioFormat format, @Nullable String deviceName) throws DeviceException {
        Preconditions.checkNotNull((Object)format, (Object)"format cannot be null");
        return new AlInputDevice(this.client, deviceName, format);
    }

    @Override
    public String getDefaultDeviceName() {
        return ALC11.alcGetString((long)0L, (int)784);
    }

    @Override
    public ImmutableList<String> getDeviceNames() {
        List devices = ALUtil.getStringList((long)0L, (int)784);
        return devices == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)devices);
    }

    @Override
    public String getType() {
        return "AL_INPUT";
    }
}

