/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.sound.sampled.AudioFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AudioDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.filter.AudioFilter;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0018H$J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\u0018H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lsu/plo/voice/client/audio/device/BaseAudioDevice;", "Lsu/plo/voice/api/client/audio/device/AudioDevice;", "voiceClient", "Lsu/plo/voice/api/client/PlasmoVoiceClient;", "name", "", "format", "Ljavax/sound/sampled/AudioFormat;", "(Lsu/plo/voice/api/client/PlasmoVoiceClient;Ljava/lang/String;Ljavax/sound/sampled/AudioFormat;)V", "bufferSize", "", "getBufferSize", "()I", "filters", "Lcom/google/common/collect/ListMultimap;", "Lsu/plo/voice/api/client/audio/filter/AudioFilter$Priority;", "Lsu/plo/voice/api/client/audio/filter/AudioFilter;", "getFormat", "()Ljavax/sound/sampled/AudioFormat;", "getName", "()Ljava/lang/String;", "getVoiceClient", "()Lsu/plo/voice/api/client/PlasmoVoiceClient;", "addFilter", "", "filter", "priority", "getFilters", "", "open", "processFilters", "", "samples", "excludeFilter", "Ljava/util/function/Predicate;", "reload", "removeFilter", "client"})
public abstract class BaseAudioDevice
implements AudioDevice {
    @NotNull
    private final PlasmoVoiceClient voiceClient;
    @NotNull
    private final String name;
    @NotNull
    private final AudioFormat format;
    private final int bufferSize;
    @NotNull
    private final ListMultimap<AudioFilter.Priority, AudioFilter> filters;

    public BaseAudioDevice(@NotNull PlasmoVoiceClient voiceClient, @NotNull String name, @NotNull AudioFormat format) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(format, "format");
        this.voiceClient = voiceClient;
        this.name = name;
        this.format = format;
        this.bufferSize = (int)this.getFormat().getSampleRate() / 1000 * 20;
        ListMultimap listMultimap = Multimaps.synchronizedListMultimap((ListMultimap)Multimaps.newListMultimap((Map)new HashMap(), BaseAudioDevice::filters$lambda-0));
        Intrinsics.checkNotNullExpressionValue(listMultimap, "synchronizedListMultimap\u2026()) { ArrayList() }\n    )");
        this.filters = listMultimap;
    }

    @NotNull
    protected final PlasmoVoiceClient getVoiceClient() {
        return this.voiceClient;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void reload() throws DeviceException {
        if (!this.isOpen()) {
            throw new DeviceException("Device is not open");
        }
        this.close();
        this.open();
    }

    @Override
    public void addFilter(@NotNull AudioFilter filter2, @NotNull AudioFilter.Priority priority) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter((Object)priority, "priority");
        for (AudioFilter.Priority filtersPriority : AudioFilter.Priority.values()) {
            List list = this.filters.get((Object)filtersPriority);
            Intrinsics.checkNotNullExpressionValue(list, "filters[filtersPriority]");
            Collection filters = list;
            if (!filters.contains(filter2)) continue;
            boolean bl = false;
            String string = "Filter is already exist with priority: " + filtersPriority;
            throw new IllegalArgumentException(string.toString());
        }
        this.filters.put((Object)priority, (Object)filter2);
    }

    @Override
    public void removeFilter(@NotNull AudioFilter filter2) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        for (AudioFilter.Priority filtersPriority : AudioFilter.Priority.values()) {
            List list = this.filters.get((Object)filtersPriority);
            Intrinsics.checkNotNullExpressionValue(list, "filters[filtersPriority]");
            Collection filters = list;
            filters.remove(filter2);
        }
    }

    @Override
    @NotNull
    public Collection<AudioFilter> getFilters() {
        Collection collection = this.filters.values();
        Intrinsics.checkNotNullExpressionValue(collection, "filters.values()");
        return collection;
    }

    @Override
    @NotNull
    public short[] processFilters(@NotNull short[] samples, @Nullable Predicate<AudioFilter> excludeFilter) {
        Intrinsics.checkNotNullParameter(samples, "samples");
        int channels = this.getFormat().getChannels();
        short[] samples2 = samples;
        for (AudioFilter filter2 : this.filters.values()) {
            if (!filter2.isEnabled() || filter2.getSupportedChannels() > 0 && filter2.getSupportedChannels() != channels) continue;
            Predicate<AudioFilter> predicate = excludeFilter;
            if (predicate == null ? false : predicate.test(filter2)) continue;
            short[] sArray = filter2.process(samples2);
            Intrinsics.checkNotNullExpressionValue(sArray, "filter.process(samples)");
            samples2 = sArray;
        }
        return samples2;
    }

    protected abstract void open() throws DeviceException;

    private static final List filters$lambda-0() {
        return new ArrayList();
    }
}

