/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AudioDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.DeviceFactory;
import su.plo.voice.client.audio.device.JavaxInputDevice;

public final class JavaxInputDeviceFactory
implements DeviceFactory {
    private final PlasmoVoiceClient client;

    public JavaxInputDeviceFactory(PlasmoVoiceClient client) {
        this.client = client;
    }

    @Override
    public AudioDevice openDevice(@NotNull AudioFormat format, @Nullable String deviceName) throws DeviceException {
        Preconditions.checkNotNull((Object)format, (Object)"format cannot be null");
        if (Strings.emptyToNull((String)deviceName) == null) {
            deviceName = this.getDefaultDeviceName();
        }
        return new JavaxInputDevice(this.client, deviceName, format);
    }

    @Override
    public String getDefaultDeviceName() {
        return (String)this.getDeviceNames().iterator().next();
    }

    @Override
    public ImmutableList<String> getDeviceNames() {
        Mixer.Info[] mixers;
        ArrayList<String> devices = new ArrayList<String>();
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            Line.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo = new Line.Info(TargetDataLine.class))) continue;
            devices.add(mixerInfo.getName());
        }
        return ImmutableList.copyOf(devices);
    }

    @Override
    public String getType() {
        return "JAVAX_INPUT";
    }
}

