/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import su.plo.voice.api.client.audio.device.DeviceFactory;
import su.plo.voice.api.client.audio.device.DeviceFactoryManager;

public final class VoiceDeviceFactoryManager
implements DeviceFactoryManager {
    protected final Map<String, DeviceFactory> deviceFactories = Maps.newConcurrentMap();

    @Override
    public void registerDeviceFactory(DeviceFactory factory2) {
        if (this.deviceFactories.containsKey(factory2.getType())) {
            throw new IllegalArgumentException("Device factory with the same type already exist");
        }
        this.deviceFactories.put(factory2.getType(), factory2);
    }

    @Override
    public boolean unregisterDeviceFactory(DeviceFactory factory2) {
        return this.unregisterDeviceFactory(factory2.getType());
    }

    @Override
    public boolean unregisterDeviceFactory(String type) {
        return this.deviceFactories.remove(type) != null;
    }

    @Override
    public Optional<DeviceFactory> getDeviceFactory(String type) {
        return Optional.ofNullable(this.deviceFactories.get(type));
    }

    @Override
    public Collection<DeviceFactory> getDeviceFactories() {
        return this.deviceFactories.values();
    }
}

