/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device.source;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.client.audio.device.AudioDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.DeviceManager;
import su.plo.voice.api.client.audio.device.DeviceType;
import su.plo.voice.api.client.audio.device.OutputDevice;
import su.plo.voice.api.client.audio.device.source.DeviceSource;
import su.plo.voice.api.client.audio.device.source.SourceGroup;
import su.plo.voice.api.util.Params;

public final class VoiceOutputSourceGroup
implements SourceGroup {
    private final DeviceManager devices;
    private final List<DeviceSource> sources = new CopyOnWriteArrayList<DeviceSource>();

    public VoiceOutputSourceGroup(@NotNull DeviceManager devices) {
        this.devices = devices;
    }

    @Override
    public void create(boolean stereo, @NotNull Params params) throws DeviceException {
        for (AudioDevice device : this.devices.getDevices(DeviceType.OUTPUT)) {
            OutputDevice outputDevice = (OutputDevice)device;
            this.sources.add((DeviceSource)outputDevice.createSource(stereo, params));
        }
    }

    @Override
    public void clear() {
        this.sources.forEach(DeviceSource::closeAsync);
        this.sources.clear();
    }

    @Override
    public Collection<DeviceSource> getSources() {
        return this.sources;
    }
}

