/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.source;

import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.audio.source.BaseClientAudioSource;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0018H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020 H\u0016R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lsu/plo/voice/client/audio/source/ClientPlayerSource;", "Lsu/plo/voice/client/audio/source/BaseClientAudioSource;", "Lsu/plo/voice/proto/data/audio/source/PlayerSourceInfo;", "voiceClient", "Lsu/plo/voice/client/BaseVoiceClient;", "config", "Lsu/plo/voice/client/config/VoiceClientConfig;", "sourceInfo", "(Lsu/plo/voice/client/BaseVoiceClient;Lsu/plo/voice/client/config/VoiceClientConfig;Lsu/plo/voice/proto/data/audio/source/PlayerSourceInfo;)V", "sourceMute", "Lsu/plo/config/entry/BooleanConfigEntry;", "getSourceMute", "()Lsu/plo/config/entry/BooleanConfigEntry;", "sourcePlayer", "Lnet/minecraft/world/entity/player/Player;", "getSourcePlayer", "()Lnet/minecraft/world/entity/player/Player;", "sourceVolume", "Lsu/plo/config/entry/DoubleConfigEntry;", "getSourceVolume", "()Lsu/plo/config/entry/DoubleConfigEntry;", "setSourceVolume", "(Lsu/plo/config/entry/DoubleConfigEntry;)V", "getLookAngle", "Lnet/minecraft/world/phys/Vec3;", "getPosition", "isPanningDisabled", "", "process", "", "packet", "Lsu/plo/voice/proto/packets/tcp/clientbound/SourceAudioEndPacket;", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "client"})
public final class ClientPlayerSource
extends BaseClientAudioSource<PlayerSourceInfo> {
    @NotNull
    private DoubleConfigEntry sourceVolume;

    public ClientPlayerSource(@NotNull BaseVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull PlayerSourceInfo sourceInfo) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(sourceInfo, "sourceInfo");
        super(voiceClient, config, (SourceInfo)sourceInfo);
        this.sourceVolume = config.getVoice().getVolumes().getVolume("source_" + sourceInfo.getPlayerInfo().getPlayerId());
    }

    @Override
    @NotNull
    public DoubleConfigEntry getSourceVolume() {
        return this.sourceVolume;
    }

    @Override
    public void setSourceVolume(@NotNull DoubleConfigEntry doubleConfigEntry) {
        Intrinsics.checkNotNullParameter(doubleConfigEntry, "<set-?>");
        this.sourceVolume = doubleConfigEntry;
    }

    @Override
    public void process(@NotNull SourceAudioPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Object e = this.getSourceMute().value();
        Intrinsics.checkNotNullExpressionValue(e, "sourceMute.value()");
        if (((Boolean)e).booleanValue()) {
            return;
        }
        super.process(packet);
    }

    @Override
    public void process(@NotNull SourceAudioEndPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Object e = this.getSourceMute().value();
        Intrinsics.checkNotNullExpressionValue(e, "sourceMute.value()");
        if (((Boolean)e).booleanValue()) {
            return;
        }
        super.process(packet);
    }

    @Override
    @NotNull
    protected class_243 getPosition() {
        class_1657 class_16572 = this.getSourcePlayer();
        Object object = class_16572 == null ? null : class_16572.method_33571();
        if (object == null) {
            class_243 class_2432 = class_243.field_1353;
            Intrinsics.checkNotNullExpressionValue(class_2432, "ZERO");
            object = class_2432;
        }
        return object;
    }

    @Override
    @NotNull
    protected class_243 getLookAngle() {
        class_1657 class_16572 = this.getSourcePlayer();
        Object object = class_16572 == null ? null : class_16572.method_5720();
        if (object == null) {
            class_243 class_2432 = class_243.field_1353;
            Intrinsics.checkNotNullExpressionValue(class_2432, "ZERO");
            object = class_2432;
        }
        return object;
    }

    @Override
    protected boolean isPanningDisabled() {
        return Intrinsics.areEqual(this.getSourcePlayer(), this.getListener()) || super.isPanningDisabled();
    }

    private final BooleanConfigEntry getSourceMute() {
        return this.getConfig().getVoice().getVolumes().getMute("source_" + ((PlayerSourceInfo)this.getSourceInfo()).getPlayerInfo().getPlayerId());
    }

    private final class_1657 getSourcePlayer() {
        class_638 class_6382 = class_310.method_1551().field_1687;
        return class_6382 == null ? null : class_6382.method_18470(((PlayerSourceInfo)this.getSourceInfo()).getPlayerInfo().getPlayerId());
    }
}

