/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings;

import java.util.stream.Collectors;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.chat.MinecraftTextStyle;
import su.plo.lib.api.chat.MinecraftTranslatableText;
import su.plo.lib.mod.client.gui.screen.GuiScreen;
import su.plo.lib.mod.client.gui.screen.TooltipScreen;
import su.plo.lib.mod.client.gui.widget.GuiWidgetListener;
import su.plo.lib.mod.client.language.LanguageUtil;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.event.socket.UdpClientClosedEvent;
import su.plo.voice.api.client.event.socket.UdpClientTimedOutEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.gui.settings.MicrophoneTestController;
import su.plo.voice.client.gui.settings.VoiceSettingsAboutFeature;
import su.plo.voice.client.gui.settings.VoiceSettingsNavigation;
import su.plo.voice.client.gui.settings.tab.ActivationTabWidget;
import su.plo.voice.client.gui.settings.tab.AddonsTabWidget;
import su.plo.voice.client.gui.settings.tab.AdvancedTabWidget;
import su.plo.voice.client.gui.settings.tab.DevicesTabWidget;
import su.plo.voice.client.gui.settings.tab.HotKeysTabWidget;
import su.plo.voice.client.gui.settings.tab.OverlayTabWidget;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.tab.VolumeTabWidget;
import su.plo.voice.client.utils.TextKt;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;

public final class VoiceSettingsScreen
extends GuiScreen
implements GuiWidgetListener,
TooltipScreen {
    private final BaseVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final MinecraftTextComponent title;
    private final VoiceSettingsNavigation navigation;
    private final VoiceSettingsAboutFeature aboutFeature;
    private final MicrophoneTestController testController;
    private int titleWidth;
    @Nullable
    private MinecraftTextComponent tooltip;
    private boolean preventEscClose;

    public VoiceSettingsScreen(@NotNull BaseVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
        this.title = this.getSettingsTitle();
        this.navigation = new VoiceSettingsNavigation(voiceClient, this, config);
        this.aboutFeature = new VoiceSettingsAboutFeature(this);
        this.testController = new MicrophoneTestController(voiceClient, config);
        voiceClient.getEventBus().register(voiceClient, this);
    }

    @Override
    public void tick() {
        this.navigation.tick();
        this.aboutFeature.tick();
    }

    @Override
    public void init() {
        this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this.testController);
        this.voiceClient.getEventBus().register(this.voiceClient, this.testController);
        this.titleWidth = RenderUtil.getTextWidth(this.getTitle());
        this.clearWidgets();
        this.navigation.addTab(MinecraftTextComponent.translatable("gui.plasmovoice.devices", new Object[0]), new class_2960("plasmovoice:textures/icons/tabs/devices.png"), new DevicesTabWidget(this, this.voiceClient, this.config, this.testController));
        this.navigation.addTab(MinecraftTextComponent.translatable("gui.plasmovoice.volume", new Object[0]), new class_2960("plasmovoice:textures/icons/tabs/volume.png"), new VolumeTabWidget(this, this.voiceClient, this.config));
        this.navigation.addTab(MinecraftTextComponent.translatable("gui.plasmovoice.activation", new Object[0]), new class_2960("plasmovoice:textures/icons/tabs/activation.png"), new ActivationTabWidget(this, this.voiceClient, this.config));
        this.navigation.addTab(MinecraftTextComponent.translatable("gui.plasmovoice.overlay", new Object[0]), new class_2960("plasmovoice:textures/icons/tabs/overlay.png"), new OverlayTabWidget(this, this.voiceClient, this.config));
        this.navigation.addTab(MinecraftTextComponent.translatable("gui.plasmovoice.advanced", new Object[0]), new class_2960("plasmovoice:textures/icons/tabs/advanced.png"), new AdvancedTabWidget(this, this.voiceClient, this.config));
        this.navigation.addTab(MinecraftTextComponent.translatable("gui.plasmovoice.hotkeys", new Object[0]), new class_2960("plasmovoice:textures/icons/tabs/hotkeys.png"), new HotKeysTabWidget(this, this.voiceClient, this.config));
        if (this.voiceClient.getAddonConfigs().size() > 0) {
            this.navigation.addTab(MinecraftTextComponent.translatable("gui.plasmovoice.addons", new Object[0]), new class_2960("plasmovoice:textures/icons/tabs/addons.png"), new AddonsTabWidget(this, this.voiceClient, this.config));
        }
        this.addWidget(this.navigation);
        this.navigation.init();
    }

    @Override
    public void removed() {
        this.navigation.removed();
        this.testController.stop();
        this.config.save(true);
        this.navigation.getActiveTab().ifPresent(TabWidget::removed);
        this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this);
        this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this.testController);
    }

    @Override
    public void clearWidgets() {
        this.navigation.clearTabs();
        super.clearWidgets();
    }

    @Override
    @NotNull
    public MinecraftTextComponent getTitle() {
        return this.title;
    }

    @Override
    public boolean shouldCloseOnEsc() {
        if (this.preventEscClose) {
            this.preventEscClose = false;
            return false;
        }
        return true;
    }

    @Override
    public void render(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        this.tooltip = null;
        this.screen.renderBackground(stack);
        this.navigation.renderTab(stack, mouseX, mouseY, delta);
        this.navigation.renderBackground(stack);
        super.render(stack, mouseX, mouseY, delta);
        RenderUtil.drawString(stack, this.title, 14, 15, 0xFFFFFF);
        this.navigation.renderButtons(stack, mouseX, mouseY, delta);
        this.aboutFeature.render(stack, delta);
        if (this.tooltip == null && this.isTitleHovered(mouseX, mouseY)) {
            this.tooltip = this.getVersionTooltip();
        }
        if (this.tooltip != null) {
            this.screen.renderTooltip(stack, TextKt.getStringSplitToWidth(RenderUtil.getFormattedString(this.tooltip), 180.0f, true, true).stream().map(MinecraftTextComponent::literal).collect(Collectors.toList()), mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isTitleHovered(mouseX, mouseY) && this.navigation.getActive() >= 0) {
            this.aboutFeature.titleClicked();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isTitleHovered(double mouseX, double mouseY) {
        return mouseX >= 14.0 && mouseX <= (double)(14 + this.titleWidth) && mouseY >= 15.0 && mouseY <= (double)(15 + UGraphics.getFontHeight());
    }

    @EventSubscribe
    public void onTimedOut(@NotNull UdpClientTimedOutEvent event) {
        if (event.isTimedOut()) {
            this.voiceClient.openNotAvailable();
        }
    }

    @EventSubscribe
    public void onClosed(@NotNull UdpClientClosedEvent event) {
        this.voiceClient.openNotAvailable();
    }

    private MinecraftTextComponent getSettingsTitle() {
        String[] versionSplit = this.voiceClient.getVersion().split("\\+");
        String version = versionSplit[0];
        MinecraftTextStyle versionColor = MinecraftTextStyle.WHITE;
        if (versionSplit.length > 1) {
            versionColor = MinecraftTextStyle.YELLOW;
        }
        MinecraftTranslatableText title = MinecraftTextComponent.translatable("gui.plasmovoice.title", MinecraftTextComponent.literal("Plasmo Voice"), MinecraftTextComponent.literal(version).withStyle(versionColor));
        if (LanguageUtil.getOrDefault("gui.plasmovoice.title").split("%").length != 3) {
            return MinecraftTextComponent.literal(String.format("Plasmo Voice %s%s Settings", new Object[]{versionColor, version}));
        }
        return title;
    }

    private MinecraftTextComponent getVersionTooltip() {
        String[] versionSplit = this.voiceClient.getVersion().split("\\+");
        if (versionSplit.length < 2) {
            return null;
        }
        return MinecraftTextComponent.literal("build+" + versionSplit[1]);
    }

    public VoiceSettingsNavigation getNavigation() {
        return this.navigation;
    }

    public MicrophoneTestController getTestController() {
        return this.testController;
    }

    public int getTitleWidth() {
        return this.titleWidth;
    }

    @Override
    public void setTooltip(@Nullable MinecraftTextComponent tooltip) {
        this.tooltip = tooltip;
    }

    public void setPreventEscClose(boolean preventEscClose) {
        this.preventEscClose = preventEscClose;
    }
}

