/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.audio.capture.ClientActivationManager;
import su.plo.voice.api.client.config.keybind.KeyBinding;
import su.plo.voice.client.audio.capture.VoiceClientActivation;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.config.keybind.ConfigKeyBindings;
import su.plo.voice.client.config.keybind.KeyBindingConfigEntry;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.AbstractHotKeysTabWidget;
import su.plo.voice.client.gui.settings.tab.TabWidget;

public final class HotKeysTabWidget
extends AbstractHotKeysTabWidget {
    private final ClientActivationManager activations;

    public HotKeysTabWidget(VoiceSettingsScreen parent, PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        super(parent, voiceClient, config);
        this.activations = voiceClient.getActivationManager();
    }

    @Override
    public void init() {
        super.init();
        ((ConfigKeyBindings)this.hotKeys).getCategoryEntries().asMap().forEach(this::createCategory);
        ArrayList activations = Lists.newArrayList(this.activations.getActivations());
        Collections.reverse(activations);
        activations.forEach(this::createActivation);
    }

    private void createActivation(ClientActivation activation) {
        if (activation.getDistances().size() == 0 || activation.getDistances().get(0) == -1) {
            return;
        }
        this.addEntry(new TabWidget.CategoryEntry(this, MinecraftTextComponent.translatable("key.plasmovoice.distance", MinecraftTextComponent.translatable(activation.getTranslation(), new Object[0]))));
        VoiceClientActivation clientActivation = (VoiceClientActivation)activation;
        this.addEntry(this.createHotKey("key.plasmovoice.distance.increase", null, clientActivation.getDistanceIncreaseConfigEntry()));
        this.addEntry(this.createHotKey("key.plasmovoice.distance.decrease", null, clientActivation.getDistanceDecreaseConfigEntry()));
    }

    private void createCategory(String category, Collection<KeyBindingConfigEntry> list) {
        if (category.equals("hidden")) {
            return;
        }
        this.addEntry(new TabWidget.CategoryEntry(this, MinecraftTextComponent.translatable(category, new Object[0])));
        list.forEach(entry -> this.addEntry(this.createHotKey(((KeyBinding)entry.value()).getName(), null, (KeyBindingConfigEntry)entry)));
    }
}

