/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.voice.client.gui.settings.widget.UpdatableWidget;

public final class CircularButton
extends Button
implements UpdatableWidget {
    private final List<MinecraftTextComponent> values;
    @Nullable
    private final UpdateAction updateAction;
    private int index;

    public CircularButton(@NotNull List<MinecraftTextComponent> values2, int index, int x, int y, int width, int height, @Nullable UpdateAction updateAction, @NotNull Button.OnTooltip tooltipAction) {
        super(x, y, width, height, MinecraftTextComponent.empty(), NO_ACTION, tooltipAction);
        this.values = values2;
        this.index = index;
        this.updateAction = updateAction;
        this.updateValue();
    }

    @Override
    public void updateValue() {
        this.setText(this.values.get(this.index));
    }

    @Override
    public void onPress() {
        super.onPress();
        this.index = (this.index + 1) % this.values.size();
        this.updateValue();
        if (this.updateAction != null) {
            this.updateAction.onUpdate(this.index);
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static interface UpdateAction {
        public void onUpdate(int var1);
    }
}

