/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.cape;

import com.google.common.hash.Hashing;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1071;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.render.texture.ModPlayerSkins;
import su.plo.voice.client.meta.PlasmoVoiceMeta;
import su.plo.voice.client.meta.developer.Developer;
import su.plo.voice.client.render.cape.SkinManagerAccessor;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lsu/plo/voice/client/render/cape/DeveloperCapeManager;", "", "()V", "loadedCapes", "", "", "Lnet/minecraft/resources/ResourceLocation;", "clearLoadedCapes", "", "getCapeLocation", "playerName", "registerTextures", "client"})
public final class DeveloperCapeManager {
    @NotNull
    public static final DeveloperCapeManager INSTANCE = new DeveloperCapeManager();
    @NotNull
    private static final Map<String, class_2960> loadedCapes = new ConcurrentHashMap();

    private DeveloperCapeManager() {
    }

    public final void clearLoadedCapes() {
        loadedCapes.clear();
    }

    public final void registerTextures(@NotNull String playerName) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(playerName, "playerName");
            Iterable $this$none$iv = PlasmoVoiceMeta.Companion.getMETA().getDevelopers();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Developer developer = (Developer)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(developer.getName(), playerName) || developer.getAliases().contains(playerName))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        String string = playerName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        class_2960 capeLocation = new class_2960("plasmovoice", "developer_capes/" + (String)string);
        class_156.method_18349().execute(() -> DeveloperCapeManager.registerTextures$lambda-3(playerName, capeLocation));
    }

    @Nullable
    public final class_2960 getCapeLocation(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        return loadedCapes.get(playerName);
    }

    private static final void registerTextures$lambda-3$lambda-2$lambda-1() {
    }

    private static final void registerTextures$lambda-3$lambda-2(class_2960 $capeLocation, File $capeFile, MinecraftProfileTexture $texture, String $playerName) {
        Intrinsics.checkNotNullParameter($capeLocation, "$capeLocation");
        Intrinsics.checkNotNullParameter($capeFile, "$capeFile");
        Intrinsics.checkNotNullParameter($texture, "$texture");
        Intrinsics.checkNotNullParameter($playerName, "$playerName");
        class_310.method_1551().method_1531().method_4616($capeLocation, (class_1044)new class_1046($capeFile, $texture.getUrl(), ModPlayerSkins.getDefaultSkin(UUID.randomUUID()), false, DeveloperCapeManager::registerTextures$lambda-3$lambda-2$lambda-1));
        loadedCapes.put($playerName, $capeLocation);
    }

    private static final void registerTextures$lambda-3(String $playerName, class_2960 $capeLocation) {
        String string;
        Intrinsics.checkNotNullParameter($playerName, "$playerName");
        Intrinsics.checkNotNullParameter($capeLocation, "$capeLocation");
        URL url = new URL("https://plasmovoice.com/capes/" + $playerName + ".png");
        MinecraftProfileTexture texture = new MinecraftProfileTexture(url.toString(), (Map)new HashMap());
        String string2 = Hashing.sha1().hashUnencodedChars((CharSequence)texture.getHash()).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sha1().hashUnencodedChars(texture.hash).toString()");
        String string3 = string2;
        class_1071 class_10712 = class_310.method_1551().method_1582();
        if (class_10712 == null) {
            throw new NullPointerException("null cannot be cast to non-null type su.plo.voice.client.render.cape.SkinManagerAccessor");
        }
        File skinsFolder = ((SkinManagerAccessor)class_10712).getSkinsCacheFolder();
        if (string3.length() > 2) {
            String string4 = string3.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string4;
        } else {
            string = "xx";
        }
        File hashFolder = new File(skinsFolder, string);
        File capeFile = new File(hashFolder, string3);
        if (capeFile.exists() && System.currentTimeMillis() - capeFile.lastModified() > 86400000L) {
            capeFile.delete();
        }
        RenderSystem.recordRenderCall(() -> DeveloperCapeManager.registerTextures$lambda-3$lambda-2($capeLocation, capeFile, texture, $playerName));
    }
}

