/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.voice;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.lib.api.chat.MinecraftLiteralText;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.line.ClientSourceLine;
import su.plo.voice.api.client.audio.source.ClientAudioSource;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.render.EntityRenderEvent;
import su.plo.voice.client.event.render.LevelRenderEvent;
import su.plo.voice.client.event.render.PlayerRenderEvent;
import su.plo.voice.client.gui.PlayerVolumeAction;
import su.plo.voice.client.render.ModCamera;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.audio.source.StaticSourceInfo;
import su.plo.voice.proto.data.player.VoicePlayerInfo;
import su.plo.voice.proto.data.pos.Pos3d;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;
import su.plo.voice.universal.UMinecraft;

public final class SourceIconRenderer {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final PlayerVolumeAction volumeAction;

    public SourceIconRenderer(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull PlayerVolumeAction volumeAction) {
        this.voiceClient = voiceClient;
        this.config = config;
        this.volumeAction = volumeAction;
    }

    @EventSubscribe
    public void onLevelRender(@NotNull LevelRenderEvent event) {
        if (this.isIconHidden() || !((Boolean)this.config.getOverlay().getShowStaticSourceIcons().value()).booleanValue()) {
            return;
        }
        for (ClientAudioSource source : this.voiceClient.getSourceManager().getSources()) {
            if (!(source.getSourceInfo() instanceof StaticSourceInfo) || !((SourceInfo)source.getSourceInfo()).isIconVisible() || !source.isActivated()) continue;
            Optional sourceLine = this.voiceClient.getSourceLineManager().getLineById(((SourceInfo)source.getSourceInfo()).getLineId());
            if (!sourceLine.isPresent()) {
                return;
            }
            Pos3d sourcePosition = ((StaticSourceInfo)source.getSourceInfo()).getPosition();
            this.renderStatic(event.getStack(), event.getCamera(), event.getLightSupplier().getLight(sourcePosition), new class_2960(((ClientSourceLine)sourceLine.get()).getIcon()), sourcePosition);
        }
    }

    @EventSubscribe
    public void onPlayerRender(@NotNull PlayerRenderEvent event) {
        String iconLocation;
        Optional<ServerConnection> connection = this.voiceClient.getServerConnection();
        if (!connection.isPresent()) {
            return;
        }
        class_1657 player = event.getPlayer();
        class_746 clientPlayer = UMinecraft.getPlayer();
        if (clientPlayer == null) {
            return;
        }
        if (this.isIconHidden() || player.method_5667().equals(clientPlayer.method_5667()) || event.isFakePlayer() || player.method_5756((class_1657)clientPlayer)) {
            return;
        }
        boolean hasPercent = false;
        Optional<VoicePlayerInfo> playerInfo = connection.get().getPlayerById(player.method_5667());
        if (!playerInfo.isPresent()) {
            iconLocation = "plasmovoice:textures/icons/headset_not_installed.png";
        } else if (((Boolean)this.config.getVoice().getVolumes().getMute("source_" + player.method_5667()).value()).booleanValue()) {
            iconLocation = "plasmovoice:textures/icons/speaker_disabled.png";
        } else if (playerInfo.get().isMuted()) {
            iconLocation = "plasmovoice:textures/icons/speaker_muted.png";
        } else if (playerInfo.get().isVoiceDisabled()) {
            iconLocation = "plasmovoice:textures/icons/headset_disabled.png";
        } else {
            Collection sources = this.voiceClient.getSourceManager().getPlayerSources(player.method_5667()).stream().map(source -> source).collect(Collectors.toList());
            hasPercent = this.volumeAction.isShown(player);
            if (hasPercent) {
                this.renderPercent(event.getStack(), event.getCamera(), event.getLight(), (class_1297)player, event.hasLabel());
            }
            if (sources.isEmpty()) {
                return;
            }
            ClientSourceLine highestSourceLine = this.getHighestActivatedSourceLine(sources);
            if (highestSourceLine == null) {
                return;
            }
            iconLocation = highestSourceLine.getIcon();
        }
        this.renderEntity(event.getStack(), event.getCamera(), event.getLight(), (class_1297)player, new class_2960(iconLocation), event.hasLabel(), hasPercent);
    }

    @EventSubscribe
    public void onEntityRender(@NotNull EntityRenderEvent event) {
        Optional<ServerConnection> connection = this.voiceClient.getServerConnection();
        if (!connection.isPresent()) {
            return;
        }
        class_1297 entity = event.getEntity();
        class_746 clientPlayer = UMinecraft.getPlayer();
        if (clientPlayer == null) {
            return;
        }
        if (this.isIconHidden() || entity.method_5756((class_1657)clientPlayer)) {
            return;
        }
        Collection sources = this.voiceClient.getSourceManager().getEntitySources(entity.method_5628()).stream().map(source -> source).collect(Collectors.toList());
        ClientSourceLine highestSourceLine = this.getHighestActivatedSourceLine(sources);
        if (highestSourceLine == null) {
            return;
        }
        this.renderEntity(event.getStack(), event.getCamera(), event.getLight(), entity, new class_2960(highestSourceLine.getIcon()), event.hasLabel(), false);
    }

    public void renderEntity(@NonNull UMatrixStack stack, @NonNull ModCamera camera, int light, @NonNull class_1297 entity, @NonNull class_2960 iconLocation, boolean hasLabel, boolean hasPercent) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (camera == null) {
            throw new NullPointerException("camera is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (iconLocation == null) {
            throw new NullPointerException("iconLocation is marked non-null but is null");
        }
        class_243 position = entity.method_19538();
        double distance = camera.position().method_1025(position);
        if (distance > 4096.0) {
            return;
        }
        UGraphics buffer = UGraphics.getFromTessellator();
        stack.push();
        if (hasPercent) {
            stack.translate(0.0, 0.3, 0.0);
        }
        this.translateEntityMatrix(stack, camera, entity, distance, hasLabel);
        UGraphics.bindTexture(0, iconLocation);
        UGraphics.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        UGraphics.enableBlend();
        UGraphics.tryBlendFuncSeparate(770, 771, 1, 771);
        RenderUtil.turnOnLightLayer();
        if (entity.method_21752()) {
            this.vertices(stack, buffer, 40, light, false);
        } else {
            this.vertices(stack, buffer, 255, light, false);
            this.vertices(stack, buffer, 40, light, true);
        }
        stack.pop();
        UGraphics.disableBlend();
        RenderUtil.defaultBlendFunc();
        UGraphics.depthMask(true);
        UGraphics.enableDepth();
        UGraphics.depthFunc(515);
    }

    private void renderPercent(@NonNull UMatrixStack stack, @NonNull ModCamera camera, int light, @NotNull class_1297 entity, boolean hasLabel) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (camera == null) {
            throw new NullPointerException("camera is marked non-null but is null");
        }
        class_243 position = entity.method_19538();
        double distance = camera.position().method_1025(position);
        if (distance > 4096.0) {
            return;
        }
        stack.push();
        this.translateEntityMatrix(stack, camera, entity, distance, hasLabel);
        stack.translate(5.0, 0.0, 0.0);
        DoubleConfigEntry volume = this.config.getVoice().getVolumes().getVolume("source_" + entity.method_5667());
        MinecraftLiteralText text = MinecraftTextComponent.literal((int)Math.round((Double)volume.value() * 100.0) + "%");
        int backgroundColor = 0x3F000000;
        int xOffset = -RenderUtil.getTextWidth(text) / 2;
        UGraphics.disableDepth();
        UGraphics.enableBlend();
        UGraphics.depthMask(false);
        RenderUtil.fill(stack, xOffset - 1, -1, xOffset + RenderUtil.getTextWidth(text) + 1, 8, backgroundColor);
        RenderUtil.drawStringLight(stack, text, xOffset, 0, 0x20FFFFFF, light, !entity.method_21752(), false);
        UGraphics.enableDepth();
        UGraphics.depthMask(true);
        RenderUtil.drawStringLight(stack, text, xOffset, 0, -1, light, false, false);
        UGraphics.disableBlend();
        stack.pop();
    }

    private void translateEntityMatrix(@NonNull UMatrixStack stack, @NonNull ModCamera camera, @NotNull class_1297 entity, double distance, boolean hasLabel) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (camera == null) {
            throw new NullPointerException("camera is marked non-null but is null");
        }
        if (hasLabel) {
            class_1657 player;
            stack.translate(0.0, 0.3, 0.0);
            if (entity instanceof class_1657 && (player = (class_1657)entity).method_7327().method_1189(2) != null && distance < 100.0) {
                stack.translate(0.0, 0.3, 0.0);
            }
        }
        stack.translate(0.0, (double)entity.method_17682() + 0.5, 0.0);
        stack.rotate(-camera.pitch(), 0.0f, 1.0f, 0.0f);
        stack.rotate(camera.yaw(), 1.0f, 0.0f, 0.0f);
        stack.scale(-0.025f, -0.025f, 0.025f);
        stack.translate(-5.0, -1.0, 0.0);
    }

    private void renderStatic(@NonNull UMatrixStack stack, @NonNull ModCamera camera, int light, @NotNull class_2960 iconLocation, @NotNull Pos3d position) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (camera == null) {
            throw new NullPointerException("camera is marked non-null but is null");
        }
        class_243 class_2432 = new class_243(position.getX(), position.getY(), position.getZ());
        if (camera.position().method_1025(class_2432) > 4096.0) {
            return;
        }
        UGraphics.bindTexture(0, iconLocation);
        UGraphics.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        UGraphics.enableBlend();
        UGraphics.tryBlendFuncSeparate(770, 771, 1, 771);
        RenderUtil.turnOnLightLayer();
        UGraphics buffer = UGraphics.getFromTessellator();
        stack.push();
        stack.translate(position.getX() - camera.position().field_1352, position.getY() - camera.position().field_1351, position.getZ() - camera.position().field_1350);
        stack.rotate(-camera.pitch(), 0.0f, 1.0f, 0.0f);
        stack.rotate(camera.yaw(), 1.0f, 0.0f, 0.0f);
        stack.scale(-0.025f, -0.025f, 0.025f);
        stack.translate(-5.0, 0.0, 0.0);
        this.vertices(stack, buffer, 255, light, false);
        this.vertices(stack, buffer, 40, light, true);
        stack.pop();
        UGraphics.disableBlend();
        RenderUtil.defaultBlendFunc();
        UGraphics.depthMask(true);
        UGraphics.enableDepth();
        UGraphics.depthFunc(515);
    }

    private void vertices(@NonNull UMatrixStack stack, @NonNull UGraphics buffer, int alpha, int light, boolean seeThrough) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        if (seeThrough) {
            UGraphics.disableDepth();
            UGraphics.depthMask(false);
        } else {
            UGraphics.enableDepth();
            UGraphics.depthMask(true);
        }
        if (seeThrough) {
            UGraphics.setShader(class_757::method_34530);
        } else {
            UGraphics.setShader(class_757::method_34529);
        }
        buffer.beginWithActiveShader(UGraphics.DrawMode.QUADS, class_290.field_20888);
        this.vertex(stack, buffer, 0.0f, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
        this.vertex(stack, buffer, 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
        this.vertex(stack, buffer, 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
        this.vertex(stack, buffer, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        buffer.drawDirect();
    }

    private void vertex(@NonNull UMatrixStack stack, @NonNull UGraphics buffer, float x, float y, float z, float u, float v, int alpha, int light) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        buffer.pos(stack, x, y, z);
        buffer.color(255, 255, 255, alpha);
        buffer.tex(u, v);
        buffer.overlay(0, 10);
        buffer.light(light & 0xFFFF, light >> 16 & 0xFFFF);
        buffer.norm(stack, 0.0f, 0.0f, -1.0f);
        buffer.endVertex();
    }

    private boolean isIconHidden() {
        int showIcons = (Integer)this.config.getOverlay().getShowSourceIcons().value();
        return showIcons == 2 || UMinecraft.getSettings().field_1842 && showIcons == 0;
    }

    private ClientSourceLine getHighestActivatedSourceLine(@NotNull Collection<ClientAudioSource<?>> sources) {
        SourceLine highestSourceLine = null;
        for (ClientAudioSource<?> source : sources) {
            Optional sourceLine;
            if (!source.isActivated() || !((SourceInfo)source.getSourceInfo()).isIconVisible() || !(sourceLine = this.voiceClient.getSourceLineManager().getLineById(((SourceInfo)source.getSourceInfo()).getLineId())).isPresent() || highestSourceLine != null && highestSourceLine.getWeight() >= ((ClientSourceLine)sourceLine.get()).getWeight()) continue;
            highestSourceLine = (ClientSourceLine)sourceLine.get();
        }
        return highestSourceLine;
    }
}

