/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.libs.kotlinx.serialization.json.internal;

import java.lang.annotation.Annotation;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.libs.kotlin.KotlinNothingValueException;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.Reflection;
import su.plo.voice.libs.kotlinx.serialization.DeserializationStrategy;
import su.plo.voice.libs.kotlinx.serialization.PolymorphicSerializerKt;
import su.plo.voice.libs.kotlinx.serialization.SealedClassSerializer;
import su.plo.voice.libs.kotlinx.serialization.SerializationStrategy;
import su.plo.voice.libs.kotlinx.serialization.descriptors.PolymorphicKind;
import su.plo.voice.libs.kotlinx.serialization.descriptors.PrimitiveKind;
import su.plo.voice.libs.kotlinx.serialization.descriptors.SerialDescriptor;
import su.plo.voice.libs.kotlinx.serialization.descriptors.SerialKind;
import su.plo.voice.libs.kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import su.plo.voice.libs.kotlinx.serialization.internal.JsonInternalDependenciesKt;
import su.plo.voice.libs.kotlinx.serialization.json.Json;
import su.plo.voice.libs.kotlinx.serialization.json.JsonClassDiscriminator;
import su.plo.voice.libs.kotlinx.serialization.json.JsonDecoder;
import su.plo.voice.libs.kotlinx.serialization.json.JsonElement;
import su.plo.voice.libs.kotlinx.serialization.json.JsonElementKt;
import su.plo.voice.libs.kotlinx.serialization.json.JsonEncoder;
import su.plo.voice.libs.kotlinx.serialization.json.JsonObject;
import su.plo.voice.libs.kotlinx.serialization.json.JsonPrimitive;
import su.plo.voice.libs.kotlinx.serialization.json.internal.JsonExceptionsKt;
import su.plo.voice.libs.kotlinx.serialization.json.internal.TreeJsonDecoderKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a*\u0010\n\u001a\u00020\u00012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a%\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u0014*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0017H\u0000\u00a2\u0006\u0002\u0010\u0018\u001aE\u0010\u0019\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0014*\u00020\u001a2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00140\f2\u0006\u0010\u001b\u001a\u0002H\u00142\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u001dH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"checkKind", "", "kind", "Lsu/plo/voice/libs/kotlinx/serialization/descriptors/SerialKind;", "throwSerializerNotFound", "", "type", "", "jsonTree", "Lsu/plo/voice/libs/kotlinx/serialization/json/JsonObject;", "validateIfSealed", "serializer", "Lsu/plo/voice/libs/kotlinx/serialization/SerializationStrategy;", "actualSerializer", "", "classDiscriminator", "Lsu/plo/voice/libs/kotlinx/serialization/descriptors/SerialDescriptor;", "json", "Lsu/plo/voice/libs/kotlinx/serialization/json/Json;", "decodeSerializableValuePolymorphic", "T", "Lsu/plo/voice/libs/kotlinx/serialization/json/JsonDecoder;", "deserializer", "Lsu/plo/voice/libs/kotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/JsonDecoder;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "encodePolymorphically", "Lsu/plo/voice/libs/kotlinx/serialization/json/JsonEncoder;", "value", "ifPolymorphic", "Lsu/plo/voice/libs/kotlin/Function1;", "(Lkotlinx/serialization/json/JsonEncoder;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "su.plo.voice.libs.kotlinx-serialization-json"})
public final class PolymorphicKt {
    public static final <T> void encodePolymorphically(@NotNull JsonEncoder $this$encodePolymorphically, @NotNull SerializationStrategy<? super T> serializer, T value, @NotNull Function1<? super String, Unit> ifPolymorphic) {
        Intrinsics.checkNotNullParameter($this$encodePolymorphically, "<this>");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        Intrinsics.checkNotNullParameter(ifPolymorphic, "ifPolymorphic");
        boolean $i$f$encodePolymorphically = false;
        if (!(serializer instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer.serialize($this$encodePolymorphically, value);
            return;
        }
        AbstractPolymorphicSerializer casted = (AbstractPolymorphicSerializer)serializer;
        String baseClassDiscriminator = PolymorphicKt.classDiscriminator(serializer.getDescriptor(), $this$encodePolymorphically.getJson());
        T t = value;
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
        }
        SerializationStrategy<T> actualSerializer = PolymorphicSerializerKt.findPolymorphicSerializer(casted, $this$encodePolymorphically, t);
        PolymorphicKt.validateIfSealed(casted, actualSerializer, baseClassDiscriminator);
        PolymorphicKt.checkKind(actualSerializer.getDescriptor().getKind());
        ifPolymorphic.invoke(baseClassDiscriminator);
        actualSerializer.serialize($this$encodePolymorphically, value);
    }

    private static final void validateIfSealed(SerializationStrategy<?> serializer, SerializationStrategy<Object> actualSerializer, String classDiscriminator) {
        if (!(serializer instanceof SealedClassSerializer)) {
            return;
        }
        if (JsonInternalDependenciesKt.jsonCachedSerialNames(actualSerializer.getDescriptor()).contains(classDiscriminator)) {
            String baseName = serializer.getDescriptor().getSerialName();
            String actualName = actualSerializer.getDescriptor().getSerialName();
            throw new IllegalStateException(("Sealed class '" + actualName + "' cannot be serialized as base class '" + baseName + "' because it has property name that conflicts with JSON class discriminator '" + classDiscriminator + "'. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism").toString());
        }
    }

    public static final void checkKind(@NotNull SerialKind kind) {
        Intrinsics.checkNotNullParameter(kind, "kind");
        if (kind instanceof SerialKind.ENUM) {
            throw new IllegalStateException("Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (kind instanceof PrimitiveKind) {
            throw new IllegalStateException("Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (kind instanceof PolymorphicKind) {
            throw new IllegalStateException("Actual serializer for polymorphic cannot be polymorphic itself".toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T decodeSerializableValuePolymorphic(@NotNull JsonDecoder $this$decodeSerializableValuePolymorphic, @NotNull DeserializationStrategy<T> deserializer) {
        String string;
        void value$iv;
        Intrinsics.checkNotNullParameter($this$decodeSerializableValuePolymorphic, "<this>");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        if (!(deserializer instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic.getJson().getConfiguration().getUseArrayPolymorphism()) {
            return deserializer.deserialize($this$decodeSerializableValuePolymorphic);
        }
        JsonElement jsonElement = $this$decodeSerializableValuePolymorphic.decodeJsonElement();
        SerialDescriptor descriptor$iv = deserializer.getDescriptor();
        boolean $i$f$cast = false;
        if (!(value$iv instanceof JsonObject)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " as the serialized body of " + descriptor$iv.getSerialName() + ", but had " + Reflection.getOrCreateKotlinClass(value$iv.getClass()));
        }
        JsonObject jsonTree = (JsonObject)value$iv;
        String discriminator = PolymorphicKt.classDiscriminator(deserializer.getDescriptor(), $this$decodeSerializableValuePolymorphic.getJson());
        JsonElement jsonElement2 = (JsonElement)jsonTree.get((Object)discriminator);
        if (jsonElement2 == null) {
            string = null;
        } else {
            JsonPrimitive jsonPrimitive = JsonElementKt.getJsonPrimitive(jsonElement2);
            string = jsonPrimitive == null ? null : jsonPrimitive.getContent();
        }
        String type = string;
        DeserializationStrategy deserializationStrategy = ((AbstractPolymorphicSerializer)deserializer).findPolymorphicSerializerOrNull($this$decodeSerializableValuePolymorphic, type);
        if (deserializationStrategy == null) {
            PolymorphicKt.throwSerializerNotFound(type, jsonTree);
            throw new KotlinNothingValueException();
        }
        DeserializationStrategy actualSerializer = deserializationStrategy;
        return TreeJsonDecoderKt.readPolymorphicJson($this$decodeSerializableValuePolymorphic.getJson(), discriminator, jsonTree, actualSerializer);
    }

    private static final Void throwSerializerNotFound(String type, JsonObject jsonTree) {
        String suffix = type == null ? "missing class discriminator ('null')" : "class discriminator '" + type + '\'';
        throw JsonExceptionsKt.JsonDecodingException(-1, Intrinsics.stringPlus("Polymorphic serializer was not found for ", suffix), jsonTree.toString());
    }

    @NotNull
    public static final String classDiscriminator(@NotNull SerialDescriptor $this$classDiscriminator, @NotNull Json json2) {
        Intrinsics.checkNotNullParameter($this$classDiscriminator, "<this>");
        Intrinsics.checkNotNullParameter(json2, "json");
        for (Annotation annotation : $this$classDiscriminator.getAnnotations()) {
            if (!(annotation instanceof JsonClassDiscriminator)) continue;
            return ((JsonClassDiscriminator)annotation).discriminator();
        }
        return json2.getConfiguration().getClassDiscriminator();
    }
}

