/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.audio.source;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.proto.data.pos.Pos3d;

public final class DirectSourceInfo
extends SourceInfo {
    @Nullable
    private MinecraftGameProfile sender;
    @Nullable
    private Pos3d relativePosition;
    @Nullable
    private Pos3d lookAngle;
    private boolean cameraRelative = true;

    public DirectSourceInfo(@NotNull String addonId, @NotNull UUID sourceId, @NotNull UUID lineId, @Nullable String sourceName, byte state, @Nullable CodecInfo decoderInfo, boolean stereo, boolean iconVisible, int angle, @Nullable MinecraftGameProfile sender, @Nullable Pos3d relativePosition, @Nullable Pos3d lookAngle, boolean cameraRelative) {
        super(addonId, sourceId, lineId, sourceName, state, decoderInfo, stereo, iconVisible, angle);
        this.sender = sender;
        this.relativePosition = relativePosition;
        this.lookAngle = lookAngle;
        this.cameraRelative = cameraRelative;
    }

    @Override
    public void deserialize(ByteArrayDataInput in) throws IOException {
        super.deserialize(in);
        if (in.readBoolean()) {
            this.sender = new MinecraftGameProfile();
            this.sender.deserialize(in);
        }
        if (in.readBoolean()) {
            this.relativePosition = new Pos3d();
            this.relativePosition.deserialize(in);
        }
        this.cameraRelative = in.readBoolean();
    }

    @Override
    public void serialize(ByteArrayDataOutput out) throws IOException {
        super.serialize(out);
        out.writeBoolean(this.sender != null);
        if (this.sender != null) {
            this.sender.serialize(out);
        }
        out.writeBoolean(this.relativePosition != null);
        if (this.relativePosition != null) {
            this.relativePosition.serialize(out);
        }
        out.writeBoolean(this.cameraRelative);
    }

    @Override
    public SourceInfo.Type getType() {
        return SourceInfo.Type.DIRECT;
    }

    public DirectSourceInfo() {
    }

    @Override
    public String toString() {
        return "DirectSourceInfo(super=" + super.toString() + ", sender=" + this.getSender() + ", relativePosition=" + this.getRelativePosition() + ", lookAngle=" + this.getLookAngle() + ", cameraRelative=" + this.isCameraRelative() + ")";
    }

    @Nullable
    public MinecraftGameProfile getSender() {
        return this.sender;
    }

    @Nullable
    public Pos3d getRelativePosition() {
        return this.relativePosition;
    }

    @Nullable
    public Pos3d getLookAngle() {
        return this.lookAngle;
    }

    public boolean isCameraRelative() {
        return this.cameraRelative;
    }
}

