/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.udp;

import com.google.common.io.ByteArrayDataInput;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketHandler;

public class PacketUdp {
    public static final int TTL = 2000;
    private final UUID secret;
    private final long timestamp;
    private final Packet<?> packet;
    private ByteArrayDataInput input;
    private boolean read;

    public PacketUdp(@NotNull UUID secret, long timestamp, @NotNull Packet<?> packet, @NotNull ByteArrayDataInput input) {
        this.secret = secret;
        this.timestamp = timestamp;
        this.packet = packet;
        this.input = input;
    }

    public <T extends PacketHandler> Packet<T> getPacket() throws IOException {
        if (!this.read) {
            this.readPacket();
        }
        return this.packet;
    }

    private synchronized void readPacket() throws IOException {
        if (this.input == null) {
            return;
        }
        this.read = true;
        this.packet.read(this.input);
        this.input = null;
    }

    public String toString() {
        return "PacketUdp(secret=" + this.getSecret() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public UUID getSecret() {
        return this.secret;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ByteArrayDataInput getInput() {
        return this.input;
    }

    public boolean isRead() {
        return this.read;
    }
}

