/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.udp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.udp.bothbound.BaseAudioPacket;
import su.plo.voice.proto.packets.udp.clientbound.ClientPacketUdpHandler;

public final class SourceAudioPacket
extends BaseAudioPacket<ClientPacketUdpHandler> {
    private UUID sourceId;
    private byte sourceState;
    private short distance;

    public SourceAudioPacket(long sequenceNumber, byte sourceState, byte[] data, @NotNull UUID sourceId, short distance) {
        super(sequenceNumber, data);
        this.sourceId = sourceId;
        this.sourceState = sourceState;
        this.distance = distance;
    }

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        super.read(in);
        this.sourceId = PacketUtil.readUUID(in);
        this.sourceState = in.readByte();
        this.distance = in.readShort();
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        super.write(out);
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.sourceId, (Object)"sourceId"));
        out.writeByte((int)this.sourceState);
        out.writeShort((int)this.distance);
    }

    @Override
    public void handle(ClientPacketUdpHandler handler) {
        handler.handle(this);
    }

    public SourceAudioPacket() {
    }

    @Override
    public String toString() {
        return "SourceAudioPacket(sourceId=" + this.getSourceId() + ", sourceState=" + this.getSourceState() + ", distance=" + this.getDistance() + ")";
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public byte getSourceState() {
        return this.sourceState;
    }

    public void setSourceState(byte sourceState) {
        this.sourceState = sourceState;
    }

    public short getDistance() {
        return this.distance;
    }

    public void setDistance(short distance) {
        this.distance = distance;
    }
}

