/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.server.entity.MinecraftServerEntity;
import su.plo.lib.api.server.world.ServerPos3d;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerEntitySource;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.EntitySourceInfo;
import su.plo.voice.server.audio.source.VoiceServerPositionalSource;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerEntitySource;", "Lsu/plo/voice/server/audio/source/VoiceServerPositionalSource;", "Lsu/plo/voice/proto/data/audio/source/EntitySourceInfo;", "Lsu/plo/voice/api/server/audio/source/ServerEntitySource;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "line", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "stereo", "", "entity", "Lsu/plo/lib/api/server/entity/MinecraftServerEntity;", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;Lsu/plo/voice/api/addon/AddonContainer;Lsu/plo/voice/api/server/audio/line/ServerSourceLine;Lsu/plo/voice/proto/data/audio/codec/CodecInfo;ZLsu/plo/lib/api/server/entity/MinecraftServerEntity;)V", "getEntity", "()Lsu/plo/lib/api/server/entity/MinecraftServerEntity;", "entityPosition", "Lsu/plo/lib/api/server/world/ServerPos3d;", "position", "getPosition", "()Lsu/plo/lib/api/server/world/ServerPos3d;", "sourceInfo", "getSourceInfo", "()Lsu/plo/voice/proto/data/audio/source/EntitySourceInfo;", "common"})
public final class VoiceServerEntitySource
extends VoiceServerPositionalSource<EntitySourceInfo>
implements ServerEntitySource {
    @NotNull
    private final MinecraftServerEntity entity;
    @NotNull
    private final ServerPos3d entityPosition;

    public VoiceServerEntitySource(@NotNull PlasmoVoiceServer voiceServer, @NotNull AddonContainer addon, @NotNull ServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo, @NotNull MinecraftServerEntity entity) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(line, "line");
        Intrinsics.checkNotNullParameter(entity, "entity");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID()");
        super(voiceServer, addon, uUID, line, decoderInfo, stereo);
        this.entity = entity;
        this.entityPosition = new ServerPos3d();
    }

    @Override
    @NotNull
    public MinecraftServerEntity getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public ServerPos3d getPosition() {
        ServerPos3d serverPos3d = this.getEntity().getServerPosition(this.entityPosition);
        Intrinsics.checkNotNullExpressionValue(serverPos3d, "entity.getServerPosition(entityPosition)");
        return serverPos3d;
    }

    @Override
    @NotNull
    public EntitySourceInfo getSourceInfo() {
        return new EntitySourceInfo(this.addon.getId(), this.id, this.line.getId(), this.name, (byte)this.state.get(), this.decoderInfo, this.stereo, this.iconVisible, this.angle, this.getEntity().getId());
    }
}

