/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.server.world.ServerPos3d;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerStaticSource;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.StaticSourceInfo;
import su.plo.voice.server.audio.source.VoiceServerPositionalSource;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R$\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerStaticSource;", "Lsu/plo/voice/server/audio/source/VoiceServerPositionalSource;", "Lsu/plo/voice/proto/data/audio/source/StaticSourceInfo;", "Lsu/plo/voice/api/server/audio/source/ServerStaticSource;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "line", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "stereo", "", "defaultPosition", "Lsu/plo/lib/api/server/world/ServerPos3d;", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;Lsu/plo/voice/api/addon/AddonContainer;Lsu/plo/voice/api/server/audio/line/ServerSourceLine;Lsu/plo/voice/proto/data/audio/codec/CodecInfo;ZLsu/plo/lib/api/server/world/ServerPos3d;)V", "position", "getPosition", "()Lsu/plo/lib/api/server/world/ServerPos3d;", "setPosition", "(Lsu/plo/lib/api/server/world/ServerPos3d;)V", "sourceInfo", "getSourceInfo", "()Lsu/plo/voice/proto/data/audio/source/StaticSourceInfo;", "sourcePosition", "common"})
public final class VoiceServerStaticSource
extends VoiceServerPositionalSource<StaticSourceInfo>
implements ServerStaticSource {
    @NotNull
    private ServerPos3d sourcePosition;

    public VoiceServerStaticSource(@NotNull PlasmoVoiceServer voiceServer, @NotNull AddonContainer addon, @NotNull ServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo, @NotNull ServerPos3d defaultPosition) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(line, "line");
        Intrinsics.checkNotNullParameter(defaultPosition, "defaultPosition");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID()");
        super(voiceServer, addon, uUID, line, decoderInfo, stereo);
        this.sourcePosition = defaultPosition;
    }

    @Override
    @NotNull
    public ServerPos3d getPosition() {
        return this.sourcePosition;
    }

    @Override
    public void setPosition(@NotNull ServerPos3d position) {
        Intrinsics.checkNotNullParameter(position, "position");
        if (!Intrinsics.areEqual(this.sourcePosition, position)) {
            this.sourcePosition = position;
            this.setDirty();
        }
    }

    @Override
    @NotNull
    public StaticSourceInfo getSourceInfo() {
        return new StaticSourceInfo(this.addon.getId(), this.id, this.line.getId(), this.name, (byte)this.state.get(), this.decoderInfo, this.stereo, this.iconVisible, this.angle, this.getPosition().toPosition(), this.getPosition().getLookAngle());
    }
}

