/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.config;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.Config;
import su.plo.config.ConfigField;
import su.plo.config.ConfigFieldProcessor;
import su.plo.config.ConfigValidator;
import su.plo.voice.api.server.config.ServerConfig;

@Config
public final class VoiceServerConfig
implements ServerConfig {
    @ConfigField(comment="Used to store server-related config file on the client\nSet it to a single value on different servers if you want them to share config")
    private String serverId = UUID.randomUUID().toString();
    @ConfigField
    private String defaultLanguage = "en_us";
    @ConfigField
    private boolean debug = false;
    @ConfigField
    private boolean disableCrowdin = false;
    @ConfigField
    private boolean checkForUpdates = true;
    @ConfigField
    private Host host = new Host();
    @ConfigField
    private Voice voice = new Voice();

    @Override
    public String serverId() {
        return this.serverId;
    }

    @Override
    public String defaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public boolean debug() {
        return this.debug;
    }

    @Override
    public boolean disableCrowdin() {
        return this.disableCrowdin;
    }

    @Override
    public boolean checkForUpdates() {
        return this.checkForUpdates;
    }

    @Override
    public Host host() {
        return this.host;
    }

    @Override
    public Voice voice() {
        return this.voice;
    }

    public VoiceServerConfig serverId(String serverId) {
        this.serverId = serverId;
        return this;
    }

    public VoiceServerConfig defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    public VoiceServerConfig debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public VoiceServerConfig disableCrowdin(boolean disableCrowdin) {
        this.disableCrowdin = disableCrowdin;
        return this;
    }

    public VoiceServerConfig checkForUpdates(boolean checkForUpdates) {
        this.checkForUpdates = checkForUpdates;
        return this;
    }

    public VoiceServerConfig host(Host host) {
        this.host = host;
        return this;
    }

    public VoiceServerConfig voice(Voice voice) {
        this.voice = voice;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoiceServerConfig)) {
            return false;
        }
        VoiceServerConfig other = (VoiceServerConfig)o;
        if (this.debug() != other.debug()) {
            return false;
        }
        if (this.disableCrowdin() != other.disableCrowdin()) {
            return false;
        }
        if (this.checkForUpdates() != other.checkForUpdates()) {
            return false;
        }
        String this$serverId = this.serverId();
        String other$serverId = other.serverId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        String this$defaultLanguage = this.defaultLanguage();
        String other$defaultLanguage = other.defaultLanguage();
        if (this$defaultLanguage == null ? other$defaultLanguage != null : !this$defaultLanguage.equals(other$defaultLanguage)) {
            return false;
        }
        Host this$host = this.host();
        Host other$host = other.host();
        if (this$host == null ? other$host != null : !((Object)this$host).equals(other$host)) {
            return false;
        }
        Voice this$voice = this.voice();
        Voice other$voice = other.voice();
        return !(this$voice == null ? other$voice != null : !((Object)this$voice).equals(other$voice));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + (this.debug() ? 79 : 97);
        result2 = result2 * 59 + (this.disableCrowdin() ? 79 : 97);
        result2 = result2 * 59 + (this.checkForUpdates() ? 79 : 97);
        String $serverId = this.serverId();
        result2 = result2 * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        String $defaultLanguage = this.defaultLanguage();
        result2 = result2 * 59 + ($defaultLanguage == null ? 43 : $defaultLanguage.hashCode());
        Host $host = this.host();
        result2 = result2 * 59 + ($host == null ? 43 : ((Object)$host).hashCode());
        Voice $voice = this.voice();
        result2 = result2 * 59 + ($voice == null ? 43 : ((Object)$voice).hashCode());
        return result2;
    }

    public String toString() {
        return "VoiceServerConfig(serverId=" + this.serverId() + ", defaultLanguage=" + this.defaultLanguage() + ", debug=" + this.debug() + ", disableCrowdin=" + this.disableCrowdin() + ", checkForUpdates=" + this.checkForUpdates() + ", host=" + this.host() + ", voice=" + this.voice() + ")";
    }

    @Config
    public static class Voice
    implements ServerConfig.Voice {
        private byte[] aesEncryptionKey = null;
        @ConfigField(comment="Supported sample rates:\n8000\n12000\n24000\n48000")
        @ConfigValidator(value=SampleRateValidator.class, allowed={"8000", "16000", "24000", "48000"})
        private int sampleRate = 48000;
        @ConfigField
        @ConfigValidator(value=KeepAliveTimeoutValidator.class, allowed={"1000-120000"})
        private int keepAliveTimeoutMs = 15000;
        @ConfigField
        @ConfigValidator(value=MtuSizeValidator.class, allowed={"128-5000"})
        private int mtuSize = 1024;
        @ConfigField
        private boolean clientModRequired = false;
        @ConfigField
        private long clientModRequiredCheckTimeoutMs = 3000L;
        @ConfigField
        private Proximity proximity = new Proximity();
        @ConfigField
        private Opus opus = new Opus();
        @ConfigField
        private Weights weights = new Weights();

        @Override
        public byte[] aesEncryptionKey() {
            return this.aesEncryptionKey;
        }

        @Override
        public int sampleRate() {
            return this.sampleRate;
        }

        @Override
        public int keepAliveTimeoutMs() {
            return this.keepAliveTimeoutMs;
        }

        @Override
        public int mtuSize() {
            return this.mtuSize;
        }

        @Override
        public boolean clientModRequired() {
            return this.clientModRequired;
        }

        @Override
        public long clientModRequiredCheckTimeoutMs() {
            return this.clientModRequiredCheckTimeoutMs;
        }

        @Override
        public Proximity proximity() {
            return this.proximity;
        }

        @Override
        public Opus opus() {
            return this.opus;
        }

        @Override
        public Weights weights() {
            return this.weights;
        }

        public Voice aesEncryptionKey(byte[] aesEncryptionKey) {
            this.aesEncryptionKey = aesEncryptionKey;
            return this;
        }

        public Voice sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Voice keepAliveTimeoutMs(int keepAliveTimeoutMs) {
            this.keepAliveTimeoutMs = keepAliveTimeoutMs;
            return this;
        }

        public Voice mtuSize(int mtuSize) {
            this.mtuSize = mtuSize;
            return this;
        }

        public Voice clientModRequired(boolean clientModRequired) {
            this.clientModRequired = clientModRequired;
            return this;
        }

        public Voice clientModRequiredCheckTimeoutMs(long clientModRequiredCheckTimeoutMs) {
            this.clientModRequiredCheckTimeoutMs = clientModRequiredCheckTimeoutMs;
            return this;
        }

        public Voice proximity(Proximity proximity) {
            this.proximity = proximity;
            return this;
        }

        public Voice opus(Opus opus) {
            this.opus = opus;
            return this;
        }

        public Voice weights(Weights weights) {
            this.weights = weights;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Voice)) {
                return false;
            }
            Voice other = (Voice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.sampleRate() != other.sampleRate()) {
                return false;
            }
            if (this.keepAliveTimeoutMs() != other.keepAliveTimeoutMs()) {
                return false;
            }
            if (this.mtuSize() != other.mtuSize()) {
                return false;
            }
            if (this.clientModRequired() != other.clientModRequired()) {
                return false;
            }
            if (this.clientModRequiredCheckTimeoutMs() != other.clientModRequiredCheckTimeoutMs()) {
                return false;
            }
            if (!Arrays.equals(this.aesEncryptionKey(), other.aesEncryptionKey())) {
                return false;
            }
            Proximity this$proximity = this.proximity();
            Proximity other$proximity = other.proximity();
            if (this$proximity == null ? other$proximity != null : !((Object)this$proximity).equals(other$proximity)) {
                return false;
            }
            Opus this$opus = this.opus();
            Opus other$opus = other.opus();
            if (this$opus == null ? other$opus != null : !((Object)this$opus).equals(other$opus)) {
                return false;
            }
            Weights this$weights = this.weights();
            Weights other$weights = other.weights();
            return !(this$weights == null ? other$weights != null : !((Object)this$weights).equals(other$weights));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Voice;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + this.sampleRate();
            result2 = result2 * 59 + this.keepAliveTimeoutMs();
            result2 = result2 * 59 + this.mtuSize();
            result2 = result2 * 59 + (this.clientModRequired() ? 79 : 97);
            long $clientModRequiredCheckTimeoutMs = this.clientModRequiredCheckTimeoutMs();
            result2 = result2 * 59 + (int)($clientModRequiredCheckTimeoutMs >>> 32 ^ $clientModRequiredCheckTimeoutMs);
            result2 = result2 * 59 + Arrays.hashCode(this.aesEncryptionKey());
            Proximity $proximity = this.proximity();
            result2 = result2 * 59 + ($proximity == null ? 43 : ((Object)$proximity).hashCode());
            Opus $opus = this.opus();
            result2 = result2 * 59 + ($opus == null ? 43 : ((Object)$opus).hashCode());
            Weights $weights = this.weights();
            result2 = result2 * 59 + ($weights == null ? 43 : ((Object)$weights).hashCode());
            return result2;
        }

        public String toString() {
            return "VoiceServerConfig.Voice(aesEncryptionKey=" + Arrays.toString(this.aesEncryptionKey()) + ", sampleRate=" + this.sampleRate() + ", keepAliveTimeoutMs=" + this.keepAliveTimeoutMs() + ", mtuSize=" + this.mtuSize() + ", clientModRequired=" + this.clientModRequired() + ", clientModRequiredCheckTimeoutMs=" + this.clientModRequiredCheckTimeoutMs() + ", proximity=" + this.proximity() + ", opus=" + this.opus() + ", weights=" + this.weights() + ")";
        }

        public static class KeepAliveTimeoutValidator
        implements Predicate<Object> {
            @Override
            public boolean test(Object o) {
                if (o == null) {
                    return true;
                }
                if (!(o instanceof Long)) {
                    return false;
                }
                long keepAliveTimeout = (Long)o;
                return keepAliveTimeout >= 1000L && keepAliveTimeout <= 120000L;
            }
        }

        public static class SampleRateValidator
        implements Predicate<Object> {
            @Override
            public boolean test(Object o) {
                if (!(o instanceof Long)) {
                    return false;
                }
                long sampleRate = (Long)o;
                return sampleRate == 8000L || sampleRate == 12000L || sampleRate == 24000L || sampleRate == 48000L;
            }
        }

        public static class MtuSizeValidator
        implements Predicate<Object> {
            @Override
            public boolean test(Object o) {
                if (!(o instanceof Long)) {
                    return false;
                }
                long mtuSize = (Long)o;
                return mtuSize >= 128L && mtuSize <= 5000L;
            }
        }

        @Config
        public static class Opus
        implements ServerConfig.Voice.Opus {
            @ConfigField(comment="Opus application mode\nSupported values: VOIP, AUDIO, RESTRICTED_LOWDELAY\nDefault is VOIP")
            @ConfigValidator(value=ModeValidator.class, allowed={"VOIP", "AUDIO", "RESTRICTED_LOWDELAY"})
            private String mode = "VOIP";
            @ConfigField(comment="Opus bitrate\nSupported values: -1000 (auto), -1 (max), [500-512_000]\nDefault is -1000")
            @ConfigValidator(value=BitrateValidator.class, allowed={"-1000 (auto)", "-1 (max)", "500-512000"})
            private int bitrate = -1000;

            @Override
            public String mode() {
                return this.mode;
            }

            @Override
            public int bitrate() {
                return this.bitrate;
            }

            public Opus mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Opus bitrate(int bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Opus)) {
                    return false;
                }
                Opus other = (Opus)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.bitrate() != other.bitrate()) {
                    return false;
                }
                String this$mode = this.mode();
                String other$mode = other.mode();
                return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Opus;
            }

            public int hashCode() {
                int PRIME = 59;
                int result2 = 1;
                result2 = result2 * 59 + this.bitrate();
                String $mode = this.mode();
                result2 = result2 * 59 + ($mode == null ? 43 : $mode.hashCode());
                return result2;
            }

            public String toString() {
                return "VoiceServerConfig.Voice.Opus(mode=" + this.mode() + ", bitrate=" + this.bitrate() + ")";
            }

            public static class BitrateValidator
            implements Predicate<Object> {
                @Override
                public boolean test(Object o) {
                    if (!(o instanceof Long)) {
                        return false;
                    }
                    long bitrate = (Long)o;
                    return bitrate == -1L || bitrate == -1000L || bitrate >= 500L && bitrate <= 512000L;
                }
            }

            public static class ModeValidator
            implements Predicate<Object> {
                @Override
                public boolean test(Object o) {
                    if (!(o instanceof String)) {
                        return false;
                    }
                    String mode = (String)o;
                    return mode.equals("VOIP") || mode.equals("AUDIO") || mode.equals("RESTRICTED_LOWDELAY");
                }
            }
        }

        @Config
        public static class Proximity
        implements ServerConfig.Voice.Proximity {
            @ConfigField
            @ConfigFieldProcessor(value={DistancesSorter.class})
            private List<Integer> distances = Arrays.asList(8, 16, 32);
            @ConfigField
            private int defaultDistance = 16;

            public List<Integer> distances() {
                return this.distances;
            }

            @Override
            public int defaultDistance() {
                return this.defaultDistance;
            }

            public Proximity distances(List<Integer> distances) {
                this.distances = distances;
                return this;
            }

            public Proximity defaultDistance(int defaultDistance) {
                this.defaultDistance = defaultDistance;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Proximity)) {
                    return false;
                }
                Proximity other = (Proximity)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.defaultDistance() != other.defaultDistance()) {
                    return false;
                }
                Collection this$distances = this.distances();
                Collection other$distances = other.distances();
                return !(this$distances == null ? other$distances != null : !((Object)this$distances).equals(other$distances));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Proximity;
            }

            public int hashCode() {
                int PRIME = 59;
                int result2 = 1;
                result2 = result2 * 59 + this.defaultDistance();
                Collection $distances = this.distances();
                result2 = result2 * 59 + ($distances == null ? 43 : ((Object)$distances).hashCode());
                return result2;
            }

            public String toString() {
                return "VoiceServerConfig.Voice.Proximity(distances=" + this.distances() + ", defaultDistance=" + this.defaultDistance() + ")";
            }

            public static class DistancesSorter
            implements Function<List<Long>, List<Integer>> {
                @Override
                public List<Integer> apply(List<Long> distances) {
                    Collections.sort(distances);
                    return distances.stream().map(Long::intValue).collect(Collectors.toList());
                }
            }
        }

        @Config
        public static class Weights
        implements ServerConfig.Voice.Weights {
            @ConfigField(path="activations")
            private Map<String, Integer> weightByActivationName = Maps.newConcurrentMap();
            @ConfigField(path="source_lines")
            private Map<String, Integer> weightBySourceLineName = Maps.newConcurrentMap();

            @Override
            public Optional<Integer> getActivationWeight(@NotNull String activationName) {
                return Optional.ofNullable(this.weightByActivationName.get(activationName));
            }

            @Override
            public Optional<Integer> getSourceLineWeight(@NotNull String sourceLineName) {
                return Optional.ofNullable(this.weightBySourceLineName.get(sourceLineName));
            }

            public Map<String, Integer> weightByActivationName() {
                return this.weightByActivationName;
            }

            public Map<String, Integer> weightBySourceLineName() {
                return this.weightBySourceLineName;
            }

            public Weights weightByActivationName(Map<String, Integer> weightByActivationName) {
                this.weightByActivationName = weightByActivationName;
                return this;
            }

            public Weights weightBySourceLineName(Map<String, Integer> weightBySourceLineName) {
                this.weightBySourceLineName = weightBySourceLineName;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Weights)) {
                    return false;
                }
                Weights other = (Weights)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Integer> this$weightByActivationName = this.weightByActivationName();
                Map<String, Integer> other$weightByActivationName = other.weightByActivationName();
                if (this$weightByActivationName == null ? other$weightByActivationName != null : !((Object)this$weightByActivationName).equals(other$weightByActivationName)) {
                    return false;
                }
                Map<String, Integer> this$weightBySourceLineName = this.weightBySourceLineName();
                Map<String, Integer> other$weightBySourceLineName = other.weightBySourceLineName();
                return !(this$weightBySourceLineName == null ? other$weightBySourceLineName != null : !((Object)this$weightBySourceLineName).equals(other$weightBySourceLineName));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Weights;
            }

            public int hashCode() {
                int PRIME = 59;
                int result2 = 1;
                Map<String, Integer> $weightByActivationName = this.weightByActivationName();
                result2 = result2 * 59 + ($weightByActivationName == null ? 43 : ((Object)$weightByActivationName).hashCode());
                Map<String, Integer> $weightBySourceLineName = this.weightBySourceLineName();
                result2 = result2 * 59 + ($weightBySourceLineName == null ? 43 : ((Object)$weightBySourceLineName).hashCode());
                return result2;
            }

            public String toString() {
                return "VoiceServerConfig.Voice.Weights(weightByActivationName=" + this.weightByActivationName() + ", weightBySourceLineName=" + this.weightBySourceLineName() + ")";
            }
        }
    }

    @Config
    public static class Host
    implements ServerConfig.Host {
        private UUID forwardingSecret = null;
        @ConfigField
        private String ip = "0.0.0.0";
        @ConfigField
        @ConfigValidator(value=PortValidator.class, allowed={"0-65535"})
        private int port = 0;
        @ConfigField(path="public")
        @Nullable
        private Public hostPublic = null;

        public UUID forwardingSecret() {
            return this.forwardingSecret;
        }

        @Override
        public String ip() {
            return this.ip;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        @Nullable
        public Public hostPublic() {
            return this.hostPublic;
        }

        public Host forwardingSecret(UUID forwardingSecret) {
            this.forwardingSecret = forwardingSecret;
            return this;
        }

        public Host ip(String ip) {
            this.ip = ip;
            return this;
        }

        public Host port(int port) {
            this.port = port;
            return this;
        }

        public Host hostPublic(@Nullable Public hostPublic) {
            this.hostPublic = hostPublic;
            return this;
        }

        public String toString() {
            return "VoiceServerConfig.Host(forwardingSecret=" + this.forwardingSecret() + ", ip=" + this.ip() + ", port=" + this.port() + ", hostPublic=" + this.hostPublic() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Host)) {
                return false;
            }
            Host other = (Host)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.port() != other.port()) {
                return false;
            }
            UUID this$forwardingSecret = this.forwardingSecret();
            UUID other$forwardingSecret = other.forwardingSecret();
            if (this$forwardingSecret == null ? other$forwardingSecret != null : !((Object)this$forwardingSecret).equals(other$forwardingSecret)) {
                return false;
            }
            String this$ip = this.ip();
            String other$ip = other.ip();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            Public this$hostPublic = this.hostPublic();
            Public other$hostPublic = other.hostPublic();
            return !(this$hostPublic == null ? other$hostPublic != null : !((Object)this$hostPublic).equals(other$hostPublic));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Host;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + this.port();
            UUID $forwardingSecret = this.forwardingSecret();
            result2 = result2 * 59 + ($forwardingSecret == null ? 43 : ((Object)$forwardingSecret).hashCode());
            String $ip = this.ip();
            result2 = result2 * 59 + ($ip == null ? 43 : $ip.hashCode());
            Public $hostPublic = this.hostPublic();
            result2 = result2 * 59 + ($hostPublic == null ? 43 : ((Object)$hostPublic).hashCode());
            return result2;
        }

        public static class PortValidator
        implements Predicate<Object> {
            @Override
            public boolean test(Object o) {
                if (!(o instanceof Long)) {
                    return false;
                }
                long port = (Long)o;
                return port >= 0L && port <= 65535L;
            }
        }

        @Config
        public static class Public
        implements ServerConfig.Host.Public {
            @ConfigField
            private String ip = "127.0.0.1";
            @ConfigField
            @ConfigValidator(value=PortValidator.class, allowed={"0-65535"})
            private int port = 0;

            @Override
            public String ip() {
                return this.ip;
            }

            @Override
            public int port() {
                return this.port;
            }

            public Public ip(String ip) {
                this.ip = ip;
                return this;
            }

            public Public port(int port) {
                this.port = port;
                return this;
            }

            public String toString() {
                return "VoiceServerConfig.Host.Public(ip=" + this.ip() + ", port=" + this.port() + ")";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Public)) {
                    return false;
                }
                Public other = (Public)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.port() != other.port()) {
                    return false;
                }
                String this$ip = this.ip();
                String other$ip = other.ip();
                return !(this$ip == null ? other$ip != null : !this$ip.equals(other$ip));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Public;
            }

            public int hashCode() {
                int PRIME = 59;
                int result2 = 1;
                result2 = result2 * 59 + this.port();
                String $ip = this.ip();
                result2 = result2 * 59 + ($ip == null ? 43 : $ip.hashCode());
                return result2;
            }
        }
    }
}

