/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.mute.storage;

import java.io.File;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.server.mute.storage.MuteStorage;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.mute.storage.file.JsonMuteStorage;

public final class MuteStorageFactory {
    private final BaseVoiceServer voiceServer;
    private final ExecutorService executor;

    public MuteStorage createStorage(@NotNull String storageType) {
        switch (storageType) {
            case "json": {
                return new JsonMuteStorage(this.executor, new File(this.voiceServer.getConfigFolder(), "voice_mutes.json"));
            }
        }
        throw new IllegalArgumentException("Unknown storage type: " + storageType);
    }

    public MuteStorageFactory(BaseVoiceServer voiceServer, ExecutorService executor) {
        this.voiceServer = voiceServer;
        this.executor = executor;
    }
}

